/*###############################################################################
# Linux Management Providers (LMP), OS provider package
# Copyright (C) 2007 Ilsoo Byun, ETRI <widepis@etri.re.kr ,widepis@empal.com>
# 
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
# 
# Modified by 2009 Khahramon NURIDDINOV, TUIT <qahramon0786@gmail.com>
# Modified by 2009 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr, guillaumebottex@gmail.com>
###############################################################################*/

#ifndef OPENDRIM_OPERATINGSYSTEMCURRENTRUNLEVELACCESS_H_
#define OPENDRIM_OPERATINGSYSTEMCURRENTRUNLEVELACCESS_H_

#include "OS_Common.h"

#include "OpenDRIM_OperatingSystemCurrentRunLevel.h"

int OS_OpenDRIM_OperatingSystemCurrentRunLevel_load(const CMPIBroker* broker, string& errorMessage);

int OS_OpenDRIM_OperatingSystemCurrentRunLevel_unload(string& errorMessage);

int OS_OpenDRIM_OperatingSystemCurrentRunLevel_retrieve(const CMPIBroker* broker, const CMPIContext* ctx, vector<OpenDRIM_OperatingSystemCurrentRunLevel>& instances, const char** properties, string& errorMessage, const string& discriminant);

int OS_OpenDRIM_OperatingSystemCurrentRunLevel_getInstance(const CMPIBroker* broker, const CMPIContext* ctx, OpenDRIM_OperatingSystemCurrentRunLevel& instance, const char** properties, string& errorMessage);

int OS_OpenDRIM_OperatingSystemCurrentRunLevel_setInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_OperatingSystemCurrentRunLevel& newInstance, const OpenDRIM_OperatingSystemCurrentRunLevel& oldInstance, const char** properties, string& errorMessage);

int OS_OpenDRIM_OperatingSystemCurrentRunLevel_createInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_OperatingSystemCurrentRunLevel& instance, string& errorMessage);

int OS_OpenDRIM_OperatingSystemCurrentRunLevel_deleteInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_OperatingSystemCurrentRunLevel& instance, string& errorMessage);

int OS_OpenDRIM_OperatingSystemCurrentRunLevel_populate(OpenDRIM_OperatingSystemCurrentRunLevel& instance, string& errorMessage);

int OS_OpenDRIM_OperatingSystemCurrentRunLevel_getInstanceInfo(OpenDRIM_OperatingSystemCurrentRunLevel& instance, string& errorMessage);

int OS_OpenDRIM_OperatingSystemCurrentRunLevel_getValue(unsigned char& Value, string& errorMessage);

int OS_OpenDRIM_OperatingSystemCurrentRunLevel_setValue(const unsigned char& newValue, string& errorMessage);

#endif /*OPENDRIM_OPERATINGSYSTEMCURRENTRUNLEVELACCESS_H_*/
