# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1371-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(58594);
 script_cve_id("CVE-2007-2024", "CVE-2007-2025", "CVE-2007-3193");
 script_version ("$");
 script_tag(name:"cvss_base", value:"10.0");
 script_tag(name:"risk_factor", value:"Critical");
 name = "Debian Security Advisory DSA 1371-1 (phpwiki)";
 script_name(name);

 desc = "The remote host is missing an update to phpwiki
announced via advisory DSA 1371-1.

Several vulnerabilities have been discovered in phpWiki, a wiki engine
written in PHP. The Common Vulnerabilities and Exposures project
identifies the following problems:

CVE-2007-2024

It was discovered that phpWiki performs insufficient file name
validation, which allows unrestricted file uploads.

CVE-2007-2025

It was discovered that phpWiki performs insufficient file name
validation, which allows unrestricted file uploads.

CVE-2007-3193

If the configuration lacks a nonzero PASSWORD_LENGTH_MINIMUM,
phpWiki might allow remote attackers to bypass authentication via
an empty password, which causes ldap_bind to return true when used
with certain LDAP implementations.


The old stable distribution (sarge) does not contain phpwiki packages.

For the stable distribution (etch) these problems have been fixed in
version 1.3.12p3-5etch1.

For the unstable distribution (sid) these problems have been fixed in
version 1.3.12p3-6.1.

We recommend that you upgrade your phpmyadmin package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201371-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 1371-1 (phpwiki)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"phpwiki", ver:"1.3.12p3-5etch1", rls:"DEB4.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
