# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1792-1 (drupal6)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(63957);
 script_version ("$");
 script_tag(name:"risk_factor", value:"High");
 name = "Debian Security Advisory DSA 1792-1 (drupal6)";
 script_name(name);

 desc = "The remote host is missing an update to drupal6
announced via advisory DSA 1792-1.

Multiple vulnerabilities have been discovered in drupal, a web content
management system.

pod.Edge discovered a cross-site scripting vulnerability due that can be
triggered when some browsers interpret UTF-8 strings as UTF-7 if they
appear before the generated HTML document defines its Content-Type.
This allows a malicious user to execute arbitrary javascript in the
context of the web site if they're allowed to post content.

Moritz Naumann discovered an information disclosure vulnerability.  If
a user is tricked into visiting the site via a specially crafted URL
and then submits a form (such as the search box) from that page, the
information in their form submission may be directed to a third-party
site determined by the URL and thus disclosed to the third party. The
third party site may then execute a cross-site request forgery attack
against the submitted form.

For the stable distribution (lenny), these problems have been fixed in version
6.6-3lenny1.

The old stable distribution (etch) does not contain drupal and is not
affected.

For the unstable distribution (sid), these problems have been fixed in
version 6.11-1

We recommend that you upgrade your drupal6 package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201792-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 1792-1 (drupal6)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"drupal6", ver:"6.6-3lenny1", rls:"DEB5.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
