# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 289-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53360);
 script_bugtraq_id(7377);
 script_cve_id("CVE-2003-0212");
 script_version ("$");
 script_tag(name:"cvss_base", value:"7.5");
 script_tag(name:"risk_factor", value:"High");
 name = "Debian Security Advisory DSA 289-1 (rinetd)";
 script_name(name);

 desc = "The remote host is missing an update to rinetd
announced via advisory DSA 289-1.

Sam Hocevar discovered a security problem in rinetd, an IP connection
redirection server.  When the connection list is full, rinetd resizes
the list in order to store the new incoming connection.  However, this
is done improperly, resulting in a denial of service and potentially
execution of arbitrary code.

For the stable distribution (woody) this problem has been fixed in
version 0.61-1.1.

For the old stable distribution (potato) this problem has been
fixed in version 0.52-2.1.

For the unstable distribution (sid) this problem has been fixed in
version 0.61-2

We recommend that you upgrade your rinetd package.


Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20289-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 289-1 (rinetd)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"rinetd", ver:"0.52-2.1", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"rinetd", ver:"0.61-1.1", rls:"DEB3.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
