# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 933-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(56112);
 script_bugtraq_id(16151);
 script_cve_id("CVE-2005-3539");
 script_version ("$");
 script_tag(name:"cvss_base", value:"7.5");
 script_tag(name:"risk_factor", value:"High");
 name = "Debian Security Advisory DSA 933-1 (hylafax)";
 script_name(name);

 desc = "The remote host is missing an update to hylafax
announced via advisory DSA 933-1.

Patrice Fournier found that hylafax passes unsanitized user data in the
notify script, allowing users with the ability to submit jobs to run
arbitrary commands  with the privileges of the hylafax server.

For the old stable distribution (woody) this problem has been fixed in
version 4.1.1-4woody1.

For the stable distribution (sarge) this problem has been fixed in
version 4.2.1-5sarge3.

For the unstable distribution the problem has been fixed in version
4.2.4-2.

We recommend that you upgrade your hylafax package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20933-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 933-1 (hylafax)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2006 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"hylafax-doc", ver:"4.1.1-4woody1", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"hylafax-client", ver:"4.1.1-4woody1", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"hylafax-server", ver:"4.1.1-4woody1", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"hylafax-doc", ver:"4.2.1-5sarge3", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"hylafax-client", ver:"4.2.1-5sarge3", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"hylafax-server", ver:"4.2.1-5sarge3", rls:"DEB3.1")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
