# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory FEDORA-2009-0814 (moodle)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(63260);
 script_cve_id("CVE-2008-5153", "CVE-2008-4796");
 script_version ("$");
 script_tag(name:"cvss_base", value:"10.0");
 script_tag(name:"risk_factor", value:"Critical");
 name = "Fedora Core 9 FEDORA-2009-0814 (moodle)";
 script_name(name);

 desc = "The remote host is missing an update to moodle
announced via advisory FEDORA-2009-0814.

Update Information:

Fix for spellcheck security flaw, and some font correction.

ChangeLog:

* Tue Jan 20 2009 Jon Ciesla  - 1.9.3-5
- Dropped and symlinked illegal sm and to fonts.
- Symlinking to FreeSans.
- Drop spell-check-logic.cgi, CVE-2008-5153, per upstream, BZ 472117, 472119, 472120.

References:

[ 1 ] Bug #472117 - CVE-2008-5153 moodle insecure temporary file use
https://bugzilla.redhat.com/show_bug.cgi?id=472117

Solution: Apply the appropriate updates.

This update can be installed with the yum update program.  Use 
su -c 'yum update moodle' at the command line.
For more information, refer to Managing Software with yum,
available at http://docs.fedoraproject.org/yum/.

https://secure1.securityspace.com/smysecure/catid.html?in=FEDORA-2009-0814

Risk factor : High";

 script_description(desc);

 summary = "Fedora Core 9 FEDORA-2009-0814 (moodle)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family = "Fedora Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"moodle", rpm:"moodle~1.9.3~5.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"moodle-af", rpm:"moodle-af~1.9.3~5.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"moodle-ar", rpm:"moodle-ar~1.9.3~5.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"moodle-be", rpm:"moodle-be~1.9.3~5.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"moodle-bg", rpm:"moodle-bg~1.9.3~5.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"moodle-bn", rpm:"moodle-bn~1.9.3~5.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"moodle-bs", rpm:"moodle-bs~1.9.3~5.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"moodle-ca", rpm:"moodle-ca~1.9.3~5.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"moodle-cs", rpm:"moodle-cs~1.9.3~5.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"moodle-cy", rpm:"moodle-cy~1.9.3~5.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"moodle-da", rpm:"moodle-da~1.9.3~5.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"moodle-de", rpm:"moodle-de~1.9.3~5.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"moodle-de_du", rpm:"moodle-de_du~1.9.3~5.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"moodle-el", rpm:"moodle-el~1.9.3~5.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"moodle-es", rpm:"moodle-es~1.9.3~5.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"moodle-et", rpm:"moodle-et~1.9.3~5.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"moodle-eu", rpm:"moodle-eu~1.9.3~5.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"moodle-fa", rpm:"moodle-fa~1.9.3~5.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"moodle-fi", rpm:"moodle-fi~1.9.3~5.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"moodle-fil", rpm:"moodle-fil~1.9.3~5.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"moodle-fr", rpm:"moodle-fr~1.9.3~5.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"moodle-fr_ca", rpm:"moodle-fr_ca~1.9.3~5.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"moodle-ga", rpm:"moodle-ga~1.9.3~5.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"moodle-gl", rpm:"moodle-gl~1.9.3~5.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"moodle-gu", rpm:"moodle-gu~1.9.3~5.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"moodle-he", rpm:"moodle-he~1.9.3~5.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"moodle-hi", rpm:"moodle-hi~1.9.3~5.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"moodle-hr", rpm:"moodle-hr~1.9.3~5.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"moodle-hu", rpm:"moodle-hu~1.9.3~5.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"moodle-hy", rpm:"moodle-hy~1.9.3~5.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"moodle-id", rpm:"moodle-id~1.9.3~5.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"moodle-is", rpm:"moodle-is~1.9.3~5.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"moodle-it", rpm:"moodle-it~1.9.3~5.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"moodle-ja", rpm:"moodle-ja~1.9.3~5.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"moodle-ka", rpm:"moodle-ka~1.9.3~5.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"moodle-km", rpm:"moodle-km~1.9.3~5.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"moodle-kn", rpm:"moodle-kn~1.9.3~5.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"moodle-ko", rpm:"moodle-ko~1.9.3~5.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"moodle-lo", rpm:"moodle-lo~1.9.3~5.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"moodle-lt", rpm:"moodle-lt~1.9.3~5.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"moodle-lv", rpm:"moodle-lv~1.9.3~5.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"moodle-mi_tn", rpm:"moodle-mi_tn~1.9.3~5.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"moodle-mi_wwow", rpm:"moodle-mi_wwow~1.9.3~5.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"moodle-mk", rpm:"moodle-mk~1.9.3~5.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"moodle-ml", rpm:"moodle-ml~1.9.3~5.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"moodle-mn", rpm:"moodle-mn~1.9.3~5.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"moodle-ms", rpm:"moodle-ms~1.9.3~5.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"moodle-nl", rpm:"moodle-nl~1.9.3~5.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"moodle-nn", rpm:"moodle-nn~1.9.3~5.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"moodle-no", rpm:"moodle-no~1.9.3~5.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"moodle-no_gr", rpm:"moodle-no_gr~1.9.3~5.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"moodle-pl", rpm:"moodle-pl~1.9.3~5.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"moodle-pt", rpm:"moodle-pt~1.9.3~5.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"moodle-pt_br", rpm:"moodle-pt_br~1.9.3~5.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"moodle-ro", rpm:"moodle-ro~1.9.3~5.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"moodle-ru", rpm:"moodle-ru~1.9.3~5.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"moodle-si", rpm:"moodle-si~1.9.3~5.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"moodle-sk", rpm:"moodle-sk~1.9.3~5.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"moodle-sl", rpm:"moodle-sl~1.9.3~5.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"moodle-sm", rpm:"moodle-sm~1.9.3~5.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"moodle-so", rpm:"moodle-so~1.9.3~5.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"moodle-sq", rpm:"moodle-sq~1.9.3~5.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"moodle-sr_cr", rpm:"moodle-sr_cr~1.9.3~5.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"moodle-sr_cr_bo", rpm:"moodle-sr_cr_bo~1.9.3~5.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"moodle-sr_lt", rpm:"moodle-sr_lt~1.9.3~5.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"moodle-sv", rpm:"moodle-sv~1.9.3~5.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"moodle-ta", rpm:"moodle-ta~1.9.3~5.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"moodle-ta_lk", rpm:"moodle-ta_lk~1.9.3~5.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"moodle-th", rpm:"moodle-th~1.9.3~5.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"moodle-tl", rpm:"moodle-tl~1.9.3~5.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"moodle-to", rpm:"moodle-to~1.9.3~5.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"moodle-tr", rpm:"moodle-tr~1.9.3~5.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"moodle-uk", rpm:"moodle-uk~1.9.3~5.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"moodle-uz", rpm:"moodle-uz~1.9.3~5.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"moodle-vi", rpm:"moodle-vi~1.9.3~5.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"moodle-zh_cn", rpm:"moodle-zh_cn~1.9.3~5.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"moodle-zh_tw", rpm:"moodle-zh_tw~1.9.3~5.fc9", rls:"FC9")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
