# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory FEDORA-2009-12966 (rubygem-actionpack)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(66496);
 script_cve_id("CVE-2009-4214", "CVE-2009-3009", "CVE-2008-5189");
 script_version ("$Revision$");
 script_tag(name:"cvss_base", value:"5.0");
 script_tag(name:"risk_factor", value:"Medium");
 script_name("Fedora Core 10 FEDORA-2009-12966 (rubygem-actionpack)");

 desc = "The remote host is missing an update to rubygem-actionpack
announced via advisory FEDORA-2009-12966.

Update Information:

Two security issues are found on activepack shipped on Fedora 10.  One bug is
that there is a weakness in the strip_tags function in ruby on rails (bug
542786, CVE-2009-4214). Another one is a possibility to circumvent protection
against cross-site request forgery (CSRF) attacks (bug 544329).

ChangeLog:

* Mon Dec  7 2009 Mamoru Tasaka  - 2.1.1-5
- Fix for potential CSRF protection circumvention (bug 544329)
- Fix for XSS weakness in strip_tags (bug 542786)

References:

[ 1 ] Bug #542786 - rubygem-actionpack: XSS weakness in strip_tags
https://bugzilla.redhat.com/show_bug.cgi?id=542786
[ 2 ] Bug #544329 - rubygem-actionpack: Potential CSRF protection circumvention
https://bugzilla.redhat.com/show_bug.cgi?id=544329

Solution: Apply the appropriate updates.

This update can be installed with the yum update program.  Use 
su -c 'yum update rubygem-actionpack' at the command line.
For more information, refer to Managing Software with yum,
available at http://docs.fedoraproject.org/yum/.

https://secure1.securityspace.com/smysecure/catid.html?in=FEDORA-2009-12966

Risk factor : High";

 script_description(desc);

 script_summary("Fedora Core 10 FEDORA-2009-12966 (rubygem-actionpack)");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 script_family("Fedora Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"rubygem-actionpack", rpm:"rubygem-actionpack~2.1.1~5.fc10", rls:"FC10")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
