#
#VID 9750cf22-216d-11da-bc01-000e0c2e438a
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from vuxml or freebsd advisories
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(55306);
 script_cve_id("CVE-2005-2475");
 script_bugtraq_id(14450);
 script_version ("$");
 script_tag(name:"cvss_base", value:"1.2");
 script_tag(name:"risk_factor", value:"Low");
 name = "FreeBSD Ports: unzip, zh-unzip, ko-unzip";
 script_name(name);

 desc = "The remote host is missing an update to the system
as announced in the referenced advisory.

The following packages are affected:
   unzip
   zh-unzip
   ko-unzip

CVE-2005-2475
Race condition in Unzip 5.52 allows local users to modify permissions
of arbitrary files via a hard link attack on a file while it is being
decompressed, whose permissions are changed by Unzip after the
decompression is complete.

Solution:
Update your system with the appropriate patches or
software upgrades.

http://marc.theaimsgroup.com/?l=bugtraq&m=112300046224117
http://www.vuxml.org/freebsd/9750cf22-216d-11da-bc01-000e0c2e438a.html

Risk factor : High";

 script_description(desc);

 summary = "FreeBSD Ports: unzip, zh-unzip, ko-unzip";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "FreeBSD Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"unzip");
if(!isnull(bver) && revcomp(a:bver, b:"5.52_2")<0) {
    security_note(0, data:"Package unzip version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"zh-unzip");
if(!isnull(bver) && revcomp(a:bver, b:"5.52_2")<0) {
    security_note(0, data:"Package zh-unzip version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"ko-unzip");
if(!isnull(bver) && revcomp(a:bver, b:"5.52_2")<0) {
    security_note(0, data:"Package ko-unzip version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
