###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_adobe_flash_player_swf_proc_vuln.nasl 726 2008-12-18 18:12:53Z dec $
#
# Adobe Flash Player for Linux SWF Processing Vulnerability
#
# Authors:
# Chandan S <schandan@secpod.com>
#
# Copyright:
# Copyright (c) 2008 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800087);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"9.3");
  script_tag(name:"risk_factor", value:"Critical");
  script_cve_id("CVE-2008-5499");
  script_name("Adobe Flash Player for Linux SWF Processing Vulnerability");
  desc = "

  Overview: This host has Adobe Flash Player installed and is prone to
  Shockwave Flash (SWF) Processing vulnerabilities.

  Vulnerability Insight:
  The issue is due to the way Flash Player handles the SWF files.

  Impact:
  Successful attack could result in execution of arbitrary code on the remote
  affected system.

  Impact Level: System

  Affected Software/OS:
  Adobe Flash Player prior to 9.0.152.0/10.0.15.3 on Linux.

  Fix: Upgrade to Adobe Flash Player 9.0.152.0 or 10.0.15.3,
  http://www.adobe.com/downloads

  References:
  http://www.adobe.com/support/security/bulletins/apsb08-24.html

  CVSS Score:
    CVSS Base Score     : 9.3 (AV:N/AC:M/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 6.9
  Risk factor: High";

  script_description(desc);
  script_summary("Check for the version of Adobe Flash Player");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2008 Intevation GmbH");
  script_family("Denial of Service");
  script_dependencies("gb_adobe_flash_player_detect_lin.nasl");
  exit(0);
}


include("version_func.inc");

adobeVer = get_kb_item("AdobeFlashPlayer/Linux/Ver");
if(!adobeVer){
  exit(0);
}
# Version match 9.0 to 9.0.151.0 and 10.0 to 10.0.12.36
if(version_in_range(version:adobeVer, test_version:"9.0",
                    test_version2:"9.0.151.0")){
  security_hole(0);
}
else if(version_in_range(version:adobeVer, test_version:"10.0",
                         test_version2:"10.0.12.36")){
  security_hole(0);
}
