###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_mcafee_groupshield_exchange_sec_bypass_vuln.nasl 2158 2009-05-14 20:07:05Z may $
#
# McAfee GroupShield for Exchange X-Header Security Bypass Vulnerability
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
##############################################################################

if(description)
{
  script_id(800619);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"9.3");
  script_tag(name:"risk_factor", value:"Critical");
  script_cve_id("CVE-2009-1491");
  script_bugtraq_id(34949);
  script_name("McAfee GroupShield for Exchange X-Header Security Bypass Vulnerability");
  desc = "

  Overview: This host is installed McAfee GroupShield for Microsoft Exchange and
  is prone to X-Header Security Bypass Vulnerability.

  Vulnerability Insight:
  This flaw is caused due to failure in scanning X-Headers while sending mail
  messages.

  Impact:
  Successful exploits will let the attacker craft malicious contents inside the
  X-Header and can bypass antivirus detection and launch further attacks into
  the affected system.

  Impact Level: System

  Affected Software/OS:
  McAfee GroupShield for Exchange version 6.0.616.102 and prior.

  Fix: No solution or patch is available as on 22nd May, 2009. Information
  regarding this issue will be updated once the solution details are available.
  For updates refer,
  http://www.mcafee.com/us/enterprise/products/anti_virus/email_servers/groupshield_microsoft_exchange.html

  References:
  http://xforce.iss.net/xforce/xfdb/50354
  http://www.nmrc.org/~thegnome/blog/apr09

  CVSS Score:
   CVSS Base Score     : 9.3 (AV:N/AC:M/Au:NR/C:C/I:C/A:C)
   CVSS Temporal Score : 8.4
  Risk factor: Critical";

  script_description(desc);
  script_summary("Check for the version of McAfee GroupShield Exchange");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("SMTP problems");
  script_dependencies("gb_mcafee_groupshield_detect.nasl");
  script_require_keys("McAfee/GroupShield/Exchange/Ver");
  exit(0);
}


include("version_func.inc");

groupVer = get_kb_item("McAfee/GroupShield/Exchange/Ver");
if(groupVer != NULL)
{
  # Grep for McAfee Groupshield for Exchange version 6.0.616.102
  if(version_is_less_equal(version:groupVer, test_version:"6.0.616.102")){
    security_hole(0);
  }
}
