###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_sun_java_web_console_xss_vuln.nasl 3227 2009-07-08 15:13:17Z jul $
#
# Sun Java Web Console Multiple XSS Vulnerabilities
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800826);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"4.3");
  script_tag(name:"risk_factor", value:"Medium");
  script_cve_id("CVE-2009-2283");
  script_name("Sun Java Web Console Multiple XSS Vulnerabilities");
  desc = "

  Overview: The host is running Java Web Console and is prone to Multiple
  Cross-Site Scripting Vulnerabilities.

  Vulnerability Insight:
  Errors in help jsp script that is not properly sanitising input data before
  being returned to the user, which can be exploited to cause web script or
  HTML code injection.

  Impact:
  Successful exploitation will let the remote attacker to execute arbitrary HTML
  and script code in a user's browser session in the context of an affected site.

  Impact Level: Application

  Affected Software/OS:
  Sun Java Web Console version 3.0.2 to 3.0.5

  Fix: Apply patch from below link,
  http://sunsolve.sun.com/search/document.do?assetkey=1-66-262428-1

  References:
  http://secunia.com/advisories/35597
  http://www.vupen.com/english/advisories/2009/1712
  http://sunsolve.sun.com/search/document.do?assetkey=1-21-136987-03-1

  CVSS Score:
    CVSS Base Score     : 4.3 (AV:N/AC:M/Au:NR/C:N/I:P/A:N)
    CVSS Temporal Score : 3.2
  Risk factor: Medium";

  script_description(desc);
  script_summary("Check for the Version of Java Web Console");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Web application abuses");
  script_dependencies("gb_sun_java_web_console_detect.nasl");
  script_require_keys("Sun/JavaWebConsole/Ver");
  exit(0);
}


include("version_func.inc");

jwcPort = 6789;
jwcVer = get_kb_item("Sun/JavaWebConsole/Ver");

if(jwcVer != NULL)
{
  # Check for Version 3.0.2 <= 3.0.5
  if(version_in_range(version:jwcVer, test_version:"3.0.2",
                                      test_version2:"3.0.5")){
    security_warning(jwcPort);
  }
}
