################################################################################
# OpenVAS Vulnerability Test
# $Id: gb_thunderbird_mime_dos_vuln_lin.nasl 0843 2009-01-13 09:33:55 Jan $
#
# Thunderbird DoS attacks via malformed MIME emails (Linux)
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
################################################################################

if(description)
{
  script_id(800502);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"4.3");
  script_tag(name:"risk_factor", value:"Medium");
  script_cve_id("CVE-2008-5430");
  script_name("Thunderbird DoS attacks via malformed MIME emails (Linux)");
  desc = "

  Overview: The host is running Mozilla Thunderbird which is prone to denial
  of service vulnerability.

  Vulnerability:
  Flaw is caused due to improper handling of multipart/mixed e-mail messages
  with many MIME parts and e-mail messages with many Content-type: message/rfc822
  headers.

  Impact: Successful exploitation could result in disruption or unavailability
  of service.

  Impact Level: Application.

  Affected Software/OS:
  Thunderbird version 2.0.0.14 and prior on Linux.

  Fix: Upgrade to Thunderbird version 3.0.4 or later
  For updates refer, http://www.mozilla.com/en-US/products/thunderbird/

  References:
  http://en.securitylab.ru/nvd/364761.php
  http://www.mozilla.org/security/announce/2008/mfsa2008-68.html

  CVSS Score:
    CVSS Base Score     : 4.3 (AV:N/AC:M/Au:NR/C:N/I:N/A:P)
    CVSS Temporal Score : 3.9
  Risk factor: Medium";

  script_description(desc);
  script_summary("Check for the version of Thunderbird");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Denial of Service");
  script_dependencies("gb_thunderbird_detect_lin.nasl");
  exit(0);
}


include("version_func.inc");

tbVer = get_kb_item("Thunderbird/Linux/Ver");
if(!tbVer){
  exit(0);
}

# Thunderbird version <= 2.0.0.14
 if(version_is_less_equal(version:tbVer, test_version:"2.0.0.14")){
   security_warning(0);
   }
