###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_formmax_bof_vuln.nasl 5501 2009-10-30 18:11:45Z oct $
#
# FormMax Buffer Overflow Vulnerability
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900972);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"9.3");
  script_tag(name:"risk_factor", value:"Critical");
  script_cve_id("CVE-2009-3790");
  script_name("FormMax Buffer Overflow Vulnerability");
  desc = "
  Overview: The host is installed with FormMax and is prone to Buffer
  Overflow Vulnerability.

  Vulnerability Insight:
  The flaw is caused due to boundary error while processing malicious '.aim'
  import files leading to heap-based buffer overflow.

  Impact:
  Attackers can exploit this issue by executing arbitrary code in the context
  of an affected application.

  Impact Level: Application

  Affected Software/OS:
  FormMax version 3.5 and prior

  Fix: No solution or patch is available as on 30th October, 2009. Information
  regarding this issue will be updated once the solution details are available.
  For updates refer, http://www.cutepdf.com/products/FormMax/

  References:
  http://osvdb.org/59079
  http://secunia.com/advisories/36943
  http://xforce.iss.net/xforce/xfdb/53890

  CVSS Score:
    CVSS Base Score     : 9.3 (AV:N/AC:M/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 7.9
  Risk factor: High";

  script_description(desc);
  script_summary("Check for the version of FormMax");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Buffer overflow");
  script_dependencies("secpod_formmax_detect.nasl");
  script_require_keys("FormMax/Evaluation/Ver");
  exit(0);
}


include("version_func.inc");

fmVer = get_kb_item("FormMax/Evaluation/Ver");
if(!fmVer){
  exit(0);
}

if(version_is_less_equal(version:fmVer, test_version:"3.5")){
  security_hole(0);
}
