/*
 * Copyright (c) 2007 Advanced Micro Devices, Inc.
 * Contributed by Robert Richter <robert.richter@amd.com>
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
 * of the Software, and to permit persons to whom the Software is furnished to do so,
 * subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED,
 * INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
 * PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
 * HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
 * CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE
 * OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 * This file is part of libpfm, a performance monitoring support library for
 * applications on Linux.
 */

/* History
 *
 * Feb 06 2009 -- Robert Richter, robert.richter@amd.com:
 *
 * Update for Family 10h RevD (Istanbul) from: BIOS and Kernel
 * Developer's Guide (BKDG) For AMD Family 10h Processors, 31116 Rev
 * 3.20 - February 04, 2009
 *
 * Update for Family 10h RevC (Shanghai) from: BIOS and Kernel
 * Developer's Guide (BKDG) For AMD Family 10h Processors, 31116 Rev
 * 3.20 - February 04, 2009
 *
 *
 * Dec 12 2007 -- Robert Richter, robert.richter@amd.com:
 *
 * Created from: BIOS and Kernel Developer's Guide (BKDG) For AMD
 * Family 10h Processors, 31116 Rev 3.00 - September 07, 2007
 */

static pme_amd64_entry_t amd64_fam10h_pe[]={

/* Family 10h RevB, Barcelona */

/*  0 */{.pme_name = "DISPATCHED_FPU",
	.pme_code  = 0x00,
	.pme_desc  = "Dispatched FPU Operations",
	.pme_flags = PFMLIB_AMD64_UMASK_COMBO,
	.pme_numasks = 7,
	.pme_umasks  = {
		{ .pme_uname = "OPS_ADD",
		  .pme_udesc = "Add pipe ops excluding load ops and SSE move ops",
		  .pme_ucode = 0x01,
		},
		{ .pme_uname = "OPS_MULTIPLY",
		  .pme_udesc = "Multiply pipe ops excluding load ops and SSE move ops",
		  .pme_ucode = 0x02,
		},
		{ .pme_uname = "OPS_STORE",
		  .pme_udesc = "Store pipe ops excluding load ops and SSE move ops",
		  .pme_ucode = 0x04,
		},
		{ .pme_uname = "OPS_ADD_PIPE_LOAD_OPS",
		  .pme_udesc = "Add pipe load ops and SSE move ops",
		  .pme_ucode = 0x08,
		},
		{ .pme_uname = "OPS_MULTIPLY_PIPE_LOAD_OPS",
		  .pme_udesc = "Multiply pipe load ops and SSE move ops",
		  .pme_ucode = 0x10,
		},
		{ .pme_uname = "OPS_STORE_PIPE_LOAD_OPS",
		  .pme_udesc = "Store pipe load ops and SSE move ops",
		  .pme_ucode = 0x20,
		},
		{ .pme_uname = "ALL",
		  .pme_udesc = "All sub-events selected",
		  .pme_ucode = 0x3F,
		},
	 },
	},
/*  1 */{.pme_name = "CYCLES_NO_FPU_OPS_RETIRED",
	.pme_code  = 0x01,
	.pme_desc  = "Cycles in which the FPU is Empty",
	},
/*  2 */{.pme_name = "DISPATCHED_FPU_OPS_FAST_FLAG",
	.pme_code  = 0x02,
	.pme_desc  = "Dispatched Fast Flag FPU Operations",
	},
/*  3 */{.pme_name = "RETIRED_SSE_OPERATIONS",
	.pme_code  = 0x03,
	.pme_desc  = "Retired SSE Operations",
	.pme_flags = PFMLIB_AMD64_UMASK_COMBO,
	.pme_numasks = 8,
	.pme_umasks  = {
		{ .pme_uname = "SINGLE_ADD_SUB_OPS",
		  .pme_udesc = "Single precision add/subtract ops",
		  .pme_ucode = 0x01,
		},
		{ .pme_uname = "SINGLE_MUL_OPS",
		  .pme_udesc = "Single precision multiply ops",
		  .pme_ucode = 0x02,
		},
		{ .pme_uname = "SINGLE_DIV_OPS",
		  .pme_udesc = "Single precision divide/square root ops",
		  .pme_ucode = 0x04,
		},
		{ .pme_uname = "DOUBLE_ADD_SUB_OPS",
		  .pme_udesc = "Double precision add/subtract ops",
		  .pme_ucode = 0x08,
		},
		{ .pme_uname = "DOUBLE_MUL_OPS",
		  .pme_udesc = "Double precision multiply ops",
		  .pme_ucode = 0x10,
		},
		{ .pme_uname = "DOUBLE_DIV_OPS",
		  .pme_udesc = "Double precision divide/square root ops",
		  .pme_ucode = 0x20,
		},
		{ .pme_uname = "OP_TYPE",
		  .pme_udesc = "Op type: 0=uops. 1=FLOPS",
		  .pme_ucode = 0x40,
		},
		{ .pme_uname = "ALL",
		  .pme_udesc = "All sub-events selected",
		  .pme_ucode = 0x7F,
		},
	 },
	},
/*  4 */{.pme_name = "RETIRED_MOVE_OPS",
	.pme_code  = 0x04,
	.pme_desc  = "Retired Move Ops",
	.pme_flags = PFMLIB_AMD64_UMASK_COMBO,
	.pme_numasks = 5,
	.pme_umasks  = {
		{ .pme_uname = "LOW_QW_MOVE_UOPS",
		  .pme_udesc = "Merging low quadword move uops",
		  .pme_ucode = 0x01,
		},
		{ .pme_uname = "HIGH_QW_MOVE_UOPS",
		  .pme_udesc = "Merging high quadword move uops",
		  .pme_ucode = 0x02,
		},
		{ .pme_uname = "ALL_OTHER_MERGING_MOVE_UOPS",
		  .pme_udesc = "All other merging move uops",
		  .pme_ucode = 0x04,
		},
		{ .pme_uname = "ALL_OTHER_MOVE_UOPS",
		  .pme_udesc = "All other move uops",
		  .pme_ucode = 0x08,
		},
		{ .pme_uname = "ALL",
		  .pme_udesc = "All sub-events selected",
		  .pme_ucode = 0x0F,
		},
	 },
	},
/*  5 */{.pme_name = "RETIRED_SERIALIZING_OPS",
	.pme_code  = 0x05,
	.pme_desc  = "Retired Serializing Ops",
	.pme_flags = PFMLIB_AMD64_UMASK_COMBO,
	.pme_numasks = 5,
	.pme_umasks  = {
		{ .pme_uname = "SSE_BOTTOM_EXECUTING_UOPS",
		  .pme_udesc = "SSE bottom-executing uops retired",
		  .pme_ucode = 0x01,
		},
		{ .pme_uname = "SSE_BOTTOM_SERIALIZING_UOPS",
		  .pme_udesc = "SSE bottom-serializing uops retired",
		  .pme_ucode = 0x02,
		},
		{ .pme_uname = "X87_BOTTOM_EXECUTING_UOPS",
		  .pme_udesc = "x87 bottom-executing uops retired",
		  .pme_ucode = 0x04,
		},
		{ .pme_uname = "X87_BOTTOM_SERIALIZING_UOPS",
		  .pme_udesc = "x87 bottom-serializing uops retired",
		  .pme_ucode = 0x08,
		},
		{ .pme_uname = "ALL",
		  .pme_udesc = "All sub-events selected",
		  .pme_ucode = 0x0F,
		},
	 },
	},
/*  6 */{.pme_name = "FP_SCHEDULER_CYCLES",
	.pme_code  = 0x06,
	.pme_desc  = "Number of Cycles that a Serializing uop is in the FP Scheduler",
	.pme_flags = PFMLIB_AMD64_UMASK_COMBO,
	.pme_numasks = 3,
	.pme_umasks  = {
		{ .pme_uname = "BOTTOM_EXECUTE_CYCLES",
		  .pme_udesc = "Number of cycles a bottom-execute uop is in the FP scheduler",
		  .pme_ucode = 0x01,
		},
		{ .pme_uname = "BOTTOM_SERIALIZING_CYCLES",
		  .pme_udesc = "Number of cycles a bottom-serializing uop is in the FP scheduler",
		  .pme_ucode = 0x02,
		},
		{ .pme_uname = "ALL",
		  .pme_udesc = "All sub-events selected",
		  .pme_ucode = 0x03,
		},
	 },
	},
/*  7 */{.pme_name = "SEGMENT_REGISTER_LOADS",
	.pme_code  = 0x20,
	.pme_desc  = "Segment Register Loads",
	.pme_flags = PFMLIB_AMD64_UMASK_COMBO,
	.pme_numasks = 8,
	.pme_umasks  = {
		{ .pme_uname = "ES",
		  .pme_udesc = "ES",
		  .pme_ucode = 0x01,
		},
		{ .pme_uname = "CS",
		  .pme_udesc = "CS",
		  .pme_ucode = 0x02,
		},
		{ .pme_uname = "SS",
		  .pme_udesc = "SS",
		  .pme_ucode = 0x04,
		},
		{ .pme_uname = "DS",
		  .pme_udesc = "DS",
		  .pme_ucode = 0x08,
		},
		{ .pme_uname = "FS",
		  .pme_udesc = "FS",
		  .pme_ucode = 0x10,
		},
		{ .pme_uname = "GS",
		  .pme_udesc = "GS",
		  .pme_ucode = 0x20,
		},
		{ .pme_uname = "HS",
		  .pme_udesc = "HS",
		  .pme_ucode = 0x40,
		},
		{ .pme_uname = "ALL",
		  .pme_udesc = "All sub-events selected",
		  .pme_ucode = 0x7F,
		},
	 },
	},
/*  8 */{.pme_name = "PIPELINE_RESTART_DUE_TO_SELF_MODIFYING_CODE",
	.pme_code  = 0x21,
	.pme_desc  = "Pipeline Restart Due to Self-Modifying Code",
	},
/*  9 */{.pme_name = "PIPELINE_RESTART_DUE_TO_PROBE_HIT",
	.pme_code  = 0x22,
	.pme_desc  = "Pipeline Restart Due to Probe Hit",
	},
/* 10 */{.pme_name = "LS_BUFFER_2_FULL_CYCLES",
	.pme_code  = 0x23,
	.pme_desc  = "LS Buffer 2 Full",
	},
/* 11 */{.pme_name = "LOCKED_OPS",
	.pme_code  = 0x24,
	.pme_desc  = "Locked Operations",
	.pme_flags = PFMLIB_AMD64_UMASK_COMBO,
	.pme_numasks = 5,
	.pme_umasks  = {
		{ .pme_uname = "EXECUTED",
		  .pme_udesc = "The number of locked instructions executed",
		  .pme_ucode = 0x01,
		},
		{ .pme_uname = "CYCLES_SPECULATIVE_PHASE",
		  .pme_udesc = "The number of cycles spent in speculative phase",
		  .pme_ucode = 0x02,
		},
		{ .pme_uname = "CYCLES_NON_SPECULATIVE_PHASE",
		  .pme_udesc = "The number of cycles spent in non-speculative phase (including cache miss penalty)",
		  .pme_ucode = 0x04,
		},
		{ .pme_uname = "CYCLES_WAITING",
		  .pme_udesc = "The number of cycles waiting for a cache hit (cache miss penalty).",
		  .pme_ucode = 0x08,
		},
		{ .pme_uname = "ALL",
		  .pme_udesc = "All sub-events selected",
		  .pme_ucode = 0x0F,
		},
	 },
	},
/* 12 */{.pme_name = "RETIRED_CLFLUSH_INSTRUCTIONS",
	.pme_code  = 0x26,
	.pme_desc  = "Retired CLFLUSH Instructions",
	},
/* 13 */{.pme_name = "RETIRED_CPUID_INSTRUCTIONS",
	.pme_code  = 0x27,
	.pme_desc  = "Retired CPUID Instructions",
	},
/* 14 */{.pme_name = "CANCELLED_STORE_TO_LOAD_FORWARD_OPERATIONS",
	.pme_code  = 0x2A,
	.pme_desc  = "Cancelled Store to Load Forward Operations",
	.pme_flags = PFMLIB_AMD64_UMASK_COMBO,
	.pme_numasks = 4,
	.pme_umasks  = {
		{ .pme_uname = "ADDRESS_MISMATCHES",
		  .pme_udesc = "Address mismatches (starting byte not the same).",
		  .pme_ucode = 0x01,
		},
		{ .pme_uname = "STORE_IS_SMALLER_THAN_LOAD",
		  .pme_udesc = "Store is smaller than load.",
		  .pme_ucode = 0x02,
		},
		{ .pme_uname = "MISALIGNED",
		  .pme_udesc = "Misaligned.",
		  .pme_ucode = 0x04,
		},
		{ .pme_uname = "ALL",
		  .pme_udesc = "All sub-events selected",
		  .pme_ucode = 0x07,
		},
	 },
	},
/* 15 */{.pme_name = "SMIS_RECEIVED",
	.pme_code  = 0x2B,
	.pme_desc  = "SMIs Received",
	},
/* 16 */{.pme_name = "DATA_CACHE_ACCESSES",
	.pme_code  = 0x40,
	.pme_desc  = "Data Cache Accesses",
	},
/* 17 */{.pme_name = "DATA_CACHE_MISSES",
	.pme_code  = 0x41,
	.pme_desc  = "Data Cache Misses",
	},
/* 18 */{.pme_name = "DATA_CACHE_REFILLS",
	.pme_code  = 0x42,
	.pme_desc  = "Data Cache Refills from L2 or Northbridge",
	.pme_flags = PFMLIB_AMD64_UMASK_COMBO,
	.pme_numasks = 6,
	.pme_umasks  = {
		{ .pme_uname = "SYSTEM",
		  .pme_udesc = "Refill from the Northbridge",
		  .pme_ucode = 0x01,
		},
		{ .pme_uname = "L2_SHARED",
		  .pme_udesc = "Shared-state line from L2",
		  .pme_ucode = 0x02,
		},
		{ .pme_uname = "L2_EXCLUSIVE",
		  .pme_udesc = "Exclusive-state line from L2",
		  .pme_ucode = 0x04,
		},
		{ .pme_uname = "L2_OWNED",
		  .pme_udesc = "Owned-state line from L2",
		  .pme_ucode = 0x08,
		},
		{ .pme_uname = "L2_MODIFIED",
		  .pme_udesc = "Modified-state line from L2",
		  .pme_ucode = 0x10,
		},
		{ .pme_uname = "ALL",
		  .pme_udesc = "All sub-events selected",
		  .pme_ucode = 0x1F,
		},
	 },
	},
/* 19 */{.pme_name = "DATA_CACHE_REFILLS_FROM_SYSTEM",
	.pme_code  = 0x43,
	.pme_desc  = "Data Cache Refills from the Northbridge",
	.pme_flags = PFMLIB_AMD64_UMASK_COMBO,
	.pme_numasks = 6,
	.pme_umasks  = {
		{ .pme_uname = "INVALID",
		  .pme_udesc = "Invalid",
		  .pme_ucode = 0x01,
		},
		{ .pme_uname = "SHARED",
		  .pme_udesc = "Shared",
		  .pme_ucode = 0x02,
		},
		{ .pme_uname = "EXCLUSIVE",
		  .pme_udesc = "Exclusive",
		  .pme_ucode = 0x04,
		},
		{ .pme_uname = "OWNED",
		  .pme_udesc = "Owned",
		  .pme_ucode = 0x08,
		},
		{ .pme_uname = "MODIFIED",
		  .pme_udesc = "Modified",
		  .pme_ucode = 0x10,
		},
		{ .pme_uname = "ALL",
		  .pme_udesc = "All sub-events selected",
		  .pme_ucode = 0x1F,
		},
	 },
	},
/* 20 */{.pme_name = "DATA_CACHE_LINES_EVICTED",
	.pme_code  = 0x44,
	.pme_desc  = "Data Cache Lines Evicted",
	.pme_flags = PFMLIB_AMD64_UMASK_COMBO,
	.pme_numasks = 8,
	.pme_umasks  = {
		{ .pme_uname = "INVALID",
		  .pme_udesc = "Invalid",
		  .pme_ucode = 0x01,
		},
		{ .pme_uname = "SHARED",
		  .pme_udesc = "Shared",
		  .pme_ucode = 0x02,
		},
		{ .pme_uname = "EXCLUSIVE",
		  .pme_udesc = "Exclusive",
		  .pme_ucode = 0x04,
		},
		{ .pme_uname = "OWNED",
		  .pme_udesc = "Owned",
		  .pme_ucode = 0x08,
		},
		{ .pme_uname = "MODIFIED",
		  .pme_udesc = "Modified",
		  .pme_ucode = 0x10,
		},
		{ .pme_uname = "BY_PREFETCHNTA",
		  .pme_udesc = "Cache line evicted was brought into the cache with by a PrefetchNTA instruction.",
		  .pme_ucode = 0x20,
		},
		{ .pme_uname = "NOT_BY_PREFETCHNTA",
		  .pme_udesc = "Cache line evicted was not brought into the cache with by a PrefetchNTA instruction.",
		  .pme_ucode = 0x40,
		},
		{ .pme_uname = "ALL",
		  .pme_udesc = "All sub-events selected",
		  .pme_ucode = 0x7F,
		},
	 },
	},
/* 21 */{.pme_name = "L1_DTLB_MISS_AND_L2_DTLB_HIT",
	.pme_code  = 0x45,
	.pme_desc  = "L1 DTLB Miss and L2 DTLB Hit",
	.pme_flags = PFMLIB_AMD64_UMASK_COMBO,
	.pme_numasks = 5,
	.pme_umasks  = {
		{ .pme_uname = "L2_4K_TLB_HIT",
		  .pme_udesc = "L2 4K TLB hit",
		  .pme_ucode = 0x01,
		},
		{ .pme_uname = "L2_2M_TLB_HIT",
		  .pme_udesc = "L2 2M TLB hit",
		  .pme_ucode = 0x02,
		},
		{ .pme_uname = "ALL",
		  .pme_udesc = "All sub-events selected",
		  .pme_ucode = 0x03,
		  .pme_uflags = PFMLIB_AMD64_TILL_FAM10H_REV_B,
		},
		{ .pme_uname = "L2_1G_TLB_HIT",
		  .pme_udesc = "L2 1G TLB hit",
		  .pme_ucode = 0x04,
		  .pme_uflags = PFMLIB_AMD64_FAM10H_REV_C,
		},
		{ .pme_uname = "ALL",
		  .pme_udesc = "All sub-events selected",
		  .pme_ucode = 0x07,
		  .pme_uflags = PFMLIB_AMD64_FAM10H_REV_C,
		},
	 },
	},
/* 22 */{.pme_name = "L1_DTLB_AND_L2_DTLB_MISS",
	.pme_code  = 0x46,
	.pme_desc  = "L1 DTLB and L2 DTLB Miss",
	.pme_flags = PFMLIB_AMD64_UMASK_COMBO,
	.pme_numasks = 4,
	.pme_umasks  = {
		{ .pme_uname = "4K_TLB_RELOAD",
		  .pme_udesc = "4K TLB reload",
		  .pme_ucode = 0x01,
		},
		{ .pme_uname = "2M_TLB_RELOAD",
		  .pme_udesc = "2M TLB reload",
		  .pme_ucode = 0x02,
		},
		{ .pme_uname = "1G_TLB_RELOAD",
		  .pme_udesc = "1G TLB reload",
		  .pme_ucode = 0x04,
		},
		{ .pme_uname = "ALL",
		  .pme_udesc = "All sub-events selected",
		  .pme_ucode = 0x07,
		},
	 },
	},
/* 23 */{.pme_name = "MISALIGNED_ACCESSES",
	.pme_code  = 0x47,
	.pme_desc  = "Misaligned Accesses",
	},
/* 24 */{.pme_name = "MICROARCHITECTURAL_LATE_CANCEL_OF_AN_ACCESS",
	.pme_code  = 0x48,
	.pme_desc  = "Microarchitectural Late Cancel of an Access",
	},
/* 25 */{.pme_name = "MICROARCHITECTURAL_EARLY_CANCEL_OF_AN_ACCESS",
	.pme_code  = 0x49,
	.pme_desc  = "Microarchitectural Early Cancel of an Access",
	},
/* 26 */{.pme_name = "SCRUBBER_SINGLE_BIT_ECC_ERRORS",
	.pme_code  = 0x4A,
	.pme_desc  = "Single-bit ECC Errors Recorded by Scrubber",
	.pme_flags = PFMLIB_AMD64_UMASK_COMBO,
	.pme_numasks = 5,
	.pme_umasks  = {
		{ .pme_uname = "SCRUBBER_ERROR",
		  .pme_udesc = "Scrubber error",
		  .pme_ucode = 0x01,
		},
		{ .pme_uname = "PIGGYBACK_ERROR",
		  .pme_udesc = "Piggyback scrubber errors",
		  .pme_ucode = 0x02,
		},
		{ .pme_uname = "LOAD_PIPE_ERROR",
		  .pme_udesc = "Load pipe error",
		  .pme_ucode = 0x04,
		},
		{ .pme_uname = "STORE_WRITE_PIPE_ERROR",
		  .pme_udesc = "Store write pipe error",
		  .pme_ucode = 0x08,
		},
		{ .pme_uname = "ALL",
		  .pme_udesc = "All sub-events selected",
		  .pme_ucode = 0x0F,
		},
	 },
	},
/* 27 */{.pme_name = "PREFETCH_INSTRUCTIONS_DISPATCHED",
	.pme_code  = 0x4B,
	.pme_desc  = "Prefetch Instructions Dispatched",
	.pme_flags = PFMLIB_AMD64_UMASK_COMBO,
	.pme_numasks = 4,
	.pme_umasks  = {
		{ .pme_uname = "LOAD",
		  .pme_udesc = "Load (Prefetch, PrefetchT0/T1/T2)",
		  .pme_ucode = 0x01,
		},
		{ .pme_uname = "STORE",
		  .pme_udesc = "Store (PrefetchW)",
		  .pme_ucode = 0x02,
		},
		{ .pme_uname = "NTA",
		  .pme_udesc = "NTA (PrefetchNTA)",
		  .pme_ucode = 0x04,
		},
		{ .pme_uname = "ALL",
		  .pme_udesc = "All sub-events selected",
		  .pme_ucode = 0x07,
		},
	 },
	},
/* 28 */{.pme_name = "DCACHE_MISSES_BY_LOCKED_INSTRUCTIONS",
	.pme_code  = 0x4C,
	.pme_desc  = "DCACHE Misses by Locked Instructions",
	.pme_flags = PFMLIB_AMD64_UMASK_COMBO,
	.pme_numasks = 2,
	.pme_umasks  = {
		{ .pme_uname = "DATA_CACHE_MISSES_BY_LOCKED_INSTRUCTIONS",
		  .pme_udesc = "Data cache misses by locked instructions",
		  .pme_ucode = 0x02,
		},
		{ .pme_uname = "ALL",
		  .pme_udesc = "All sub-events selected",
		  .pme_ucode = 0x02,
		},
	 },
	},
/* 29 */{.pme_name = "L1_DTLB_HIT",
	.pme_code  = 0x4D,
	.pme_desc  = "L1 DTLB Hit",
	.pme_flags = PFMLIB_AMD64_UMASK_COMBO,
	.pme_numasks = 4,
	.pme_umasks  = {
		{ .pme_uname = "L1_4K_TLB_HIT",
		  .pme_udesc = "L1 4K TLB hit",
		  .pme_ucode = 0x01,
		},
		{ .pme_uname = "L1_2M_TLB_HIT",
		  .pme_udesc = "L1 2M TLB hit",
		  .pme_ucode = 0x02,
		},
		{ .pme_uname = "L1_1G_TLB_HIT",
		  .pme_udesc = "L1 1G TLB hit",
		  .pme_ucode = 0x04,
		},
		{ .pme_uname = "ALL",
		  .pme_udesc = "All sub-events selected",
		  .pme_ucode = 0x07,
		},
	 },
	},
/* 30 */{.pme_name = "INEFFECTIVE_SW_PREFETCHES",
	.pme_code  = 0x52,
	.pme_desc  = "Ineffective Software Prefetches",
	.pme_flags = PFMLIB_AMD64_UMASK_COMBO,
	.pme_numasks = 3,
	.pme_umasks  = {
		{ .pme_uname = "SW_PREFETCH_HIT_IN_L1",
		  .pme_udesc = "Software prefetch hit in the L1.",
		  .pme_ucode = 0x01,
		},
		{ .pme_uname = "SW_PREFETCH_HIT_IN_L2",
		  .pme_udesc = "Software prefetch hit in L2.",
		  .pme_ucode = 0x08,
		},
		{ .pme_uname = "ALL",
		  .pme_udesc = "All sub-events selected",
		  .pme_ucode = 0x09,
		},
	 },
	},
/* 31 */{.pme_name = "GLOBAL_TLB_FLUSHES",
	.pme_code  = 0x54,
	.pme_desc  = "Global TLB Flushes",
	},
/* 32 */{.pme_name = "MEMORY_REQUESTS",
	.pme_code  = 0x65,
	.pme_desc  = "Memory Requests by Type",
	.pme_flags = PFMLIB_AMD64_UMASK_COMBO,
	.pme_numasks = 4,
	.pme_umasks  = {
		{ .pme_uname = "NON_CACHEABLE",
		  .pme_udesc = "Requests to non-cacheable (UC) memory",
		  .pme_ucode = 0x01,
		},
		{ .pme_uname = "WRITE_COMBINING",
		  .pme_udesc = "Requests to write-combining (WC) memory or WC buffer flushes to WB memory",
		  .pme_ucode = 0x02,
		},
		{ .pme_uname = "STREAMING_STORE",
		  .pme_udesc = "Streaming store (SS) requests",
		  .pme_ucode = 0x80,
		},
		{ .pme_uname = "ALL",
		  .pme_udesc = "All sub-events selected",
		  .pme_ucode = 0x83,
		},
	 },
	},
/* 33 */{.pme_name = "DATA_PREFETCHES",
	.pme_code  = 0x67,
	.pme_desc  = "Data Prefetcher",
	.pme_flags = PFMLIB_AMD64_UMASK_COMBO,
	.pme_numasks = 3,
	.pme_umasks  = {
		{ .pme_uname = "CANCELLED",
		  .pme_udesc = "Cancelled prefetches",
		  .pme_ucode = 0x01,
		},
		{ .pme_uname = "ATTEMPTED",
		  .pme_udesc = "Prefetch attempts",
		  .pme_ucode = 0x02,
		},
		{ .pme_uname = "ALL",
		  .pme_udesc = "All sub-events selected",
		  .pme_ucode = 0x03,
		},
	 },
	},
/* 34 */{.pme_name = "SYSTEM_READ_RESPONSES",
	.pme_code  = 0x6C,
	.pme_desc  = "Northbridge Read Responses by Coherency State",
	.pme_flags = PFMLIB_AMD64_UMASK_COMBO,
	.pme_numasks = 6,
	.pme_umasks  = {
		{ .pme_uname = "EXCLUSIVE",
		  .pme_udesc = "Exclusive",
		  .pme_ucode = 0x01,
		},
		{ .pme_uname = "MODIFIED",
		  .pme_udesc = "Modified",
		  .pme_ucode = 0x02,
		},
		{ .pme_uname = "SHARED",
		  .pme_udesc = "Shared",
		  .pme_ucode = 0x04,
		},
		{ .pme_uname = "OWNED",
		  .pme_udesc = "Owned",
		  .pme_ucode = 0x08,
		},
		{ .pme_uname = "DATA_ERROR",
		  .pme_udesc = "Data Error",
		  .pme_ucode = 0x10,
		},
		{ .pme_uname = "ALL",
		  .pme_udesc = "All sub-events selected",
		  .pme_ucode = 0x1F,
		},
	 },
	},
/* 35 */{.pme_name = "QUADWORDS_WRITTEN_TO_SYSTEM",
	.pme_code  = 0x6D,
	.pme_desc  = "Octwords Written to System",
	.pme_flags = PFMLIB_AMD64_UMASK_COMBO,
	.pme_numasks = 2,
	.pme_umasks  = {
		{ .pme_uname = "QUADWORD_WRITE_TRANSFER",
		  .pme_udesc = "Octword write transfer",
		  .pme_ucode = 0x01,
		},
		{ .pme_uname = "ALL",
		  .pme_udesc = "All sub-events selected",
		  .pme_ucode = 0x01,
		},
	 },
	},
/* 36 */{.pme_name = "CPU_CLK_UNHALTED",
	.pme_code  = 0x76,
	.pme_desc  = "CPU Clocks not Halted",
	},
/* 37 */{.pme_name = "REQUESTS_TO_L2",
	.pme_code  = 0x7D,
	.pme_desc  = "Requests to L2 Cache",
	.pme_flags = PFMLIB_AMD64_UMASK_COMBO,
	.pme_numasks = 7,
	.pme_umasks  = {
		{ .pme_uname = "INSTRUCTIONS",
		  .pme_udesc = "IC fill",
		  .pme_ucode = 0x01,
		},
		{ .pme_uname = "DATA",
		  .pme_udesc = "DC fill",
		  .pme_ucode = 0x02,
		},
		{ .pme_uname = "TLB_WALK",
		  .pme_udesc = "TLB fill (page table walks)",
		  .pme_ucode = 0x04,
		},
		{ .pme_uname = "SNOOP",
		  .pme_udesc = "Tag snoop request",
		  .pme_ucode = 0x08,
		},
		{ .pme_uname = "CANCELLED",
		  .pme_udesc = "Cancelled request",
		  .pme_ucode = 0x10,
		},
		{ .pme_uname = "HW_PREFETCH_FROM_DC",
		  .pme_udesc = "Hardware prefetch from DC",
		  .pme_ucode = 0x20,
		},
		{ .pme_uname = "ALL",
		  .pme_udesc = "All sub-events selected",
		  .pme_ucode = 0x3F,
		},
	 },
	},
/* 38 */{.pme_name = "L2_CACHE_MISS",
	.pme_code  = 0x7E,
	.pme_desc  = "L2 Cache Misses",
	.pme_flags = PFMLIB_AMD64_UMASK_COMBO,
	.pme_numasks = 5,
	.pme_umasks  = {
		{ .pme_uname = "INSTRUCTIONS",
		  .pme_udesc = "IC fill",
		  .pme_ucode = 0x01,
		},
		{ .pme_uname = "DATA",
		  .pme_udesc = "DC fill (includes possible replays, whereas EventSelect 041h does not)",
		  .pme_ucode = 0x02,
		},
		{ .pme_uname = "TLB_WALK",
		  .pme_udesc = "TLB page table walk",
		  .pme_ucode = 0x04,
		},
		{ .pme_uname = "HW_PREFETCH_FROM_DC",
		  .pme_udesc = "Hardware prefetch from DC",
		  .pme_ucode = 0x08,
		},
		{ .pme_uname = "ALL",
		  .pme_udesc = "All sub-events selected",
		  .pme_ucode = 0x0F,
		},
	 },
	},
/* 39 */{.pme_name = "L2_FILL_WRITEBACK",
	.pme_code  = 0x7F,
	.pme_desc  = "L2 Fill/Writeback",
	.pme_flags = PFMLIB_AMD64_UMASK_COMBO,
	.pme_numasks = 3,
	.pme_umasks  = {
		{ .pme_uname = "L2_FILLS",
		  .pme_udesc = "L2 fills (victims from L1 caches, TLB page table walks and data prefetches)",
		  .pme_ucode = 0x01,
		},
		{ .pme_uname = "L2_WRITEBACKS",
		  .pme_udesc = "L2 Writebacks to system.",
		  .pme_ucode = 0x02,
		},
		{ .pme_uname = "ALL",
		  .pme_udesc = "All sub-events selected",
		  .pme_ucode = 0x03,
		},
	 },
	},
/* 40 */{.pme_name = "INSTRUCTION_CACHE_FETCHES",
	.pme_code  = 0x80,
	.pme_desc  = "Instruction Cache Fetches",
	},
/* 41 */{.pme_name = "INSTRUCTION_CACHE_MISSES",
	.pme_code  = 0x81,
	.pme_desc  = "Instruction Cache Misses",
	},
/* 42 */{.pme_name = "INSTRUCTION_CACHE_REFILLS_FROM_L2",
	.pme_code  = 0x82,
	.pme_desc  = "Instruction Cache Refills from L2",
	},
/* 43 */{.pme_name = "INSTRUCTION_CACHE_REFILLS_FROM_SYSTEM",
	.pme_code  = 0x83,
	.pme_desc  = "Instruction Cache Refills from System",
	},
/* 44 */{.pme_name = "L1_ITLB_MISS_AND_L2_ITLB_HIT",
	.pme_code  = 0x84,
	.pme_desc  = "L1 ITLB Miss and L2 ITLB Hit",
	},
/* 45 */{.pme_name = "L1_ITLB_MISS_AND_L2_ITLB_MISS",
	.pme_code  = 0x85,
	.pme_desc  = "L1 ITLB Miss and L2 ITLB Miss",
	.pme_flags = PFMLIB_AMD64_UMASK_COMBO,
	.pme_numasks = 3,
	.pme_umasks  = {
		{ .pme_uname = "4K_PAGE_FETCHES",
		  .pme_udesc = "Instruction fetches to a 4K page.",
		  .pme_ucode = 0x01,
		},
		{ .pme_uname = "2M_PAGE_FETCHES",
		  .pme_udesc = "Instruction fetches to a 2M page.",
		  .pme_ucode = 0x02,
		},
		{ .pme_uname = "ALL",
		  .pme_udesc = "All sub-events selected",
		  .pme_ucode = 0x03,
		},
	 },
	},
/* 46 */{.pme_name = "PIPELINE_RESTART_DUE_TO_INSTRUCTION_STREAM_PROBE",
	.pme_code  = 0x86,
	.pme_desc  = "Pipeline Restart Due to Instruction Stream Probe",
	},
/* 47 */{.pme_name = "INSTRUCTION_FETCH_STALL",
	.pme_code  = 0x87,
	.pme_desc  = "Instruction Fetch Stall",
	},
/* 48 */{.pme_name = "RETURN_STACK_HITS",
	.pme_code  = 0x88,
	.pme_desc  = "Return Stack Hits",
	},
/* 49 */{.pme_name = "RETURN_STACK_OVERFLOWS",
	.pme_code  = 0x89,
	.pme_desc  = "Return Stack Overflows",
	},
/* 50 */{.pme_name = "INSTRUCTION_CACHE_VICTIMS",
	.pme_code  = 0x8B,
	.pme_desc  = "Instruction Cache Victims",
	},
/* 51 */{.pme_name = "INSTRUCTION_CACHE_LINES_INVALIDATED",
	.pme_code  = 0x8C,
	.pme_desc  = "Instruction Cache Lines Invalidated",
	.pme_flags = PFMLIB_AMD64_UMASK_COMBO,
	.pme_numasks = 3,
	.pme_umasks  = {
		{ .pme_uname = "INVALIDATING_PROBE_NO_IN_FLIGHT",
		  .pme_udesc = "Invalidating probe that did not hit any in-flight instructions.",
		  .pme_ucode = 0x01,
		},
		{ .pme_uname = "INVALIDATING_PROBE_ONE_OR_MORE_IN_FLIGHT",
		  .pme_udesc = "Invalidating probe that hit one or more in-flight instructions.",
		  .pme_ucode = 0x02,
		},
		{ .pme_uname = "ALL",
		  .pme_udesc = "All sub-events selected",
		  .pme_ucode = 0x03,
		},
	 },
	},
/* 52 */{.pme_name = "ITLB_RELOADS",
	.pme_code  = 0x99,
	.pme_desc  = "ITLB Reloads",
	},
/* 53 */{.pme_name = "ITLB_RELOADS_ABORTED",
	.pme_code  = 0x9A,
	.pme_desc  = "ITLB Reloads Aborted",
	},
/* 54 */{.pme_name = "RETIRED_INSTRUCTIONS",
	.pme_code  = 0xC0,
	.pme_desc  = "Retired Instructions",
	},
/* 55 */{.pme_name = "RETIRED_UOPS",
	.pme_code  = 0xC1,
	.pme_desc  = "Retired uops",
	},
/* 56 */{.pme_name = "RETIRED_BRANCH_INSTRUCTIONS",
	.pme_code  = 0xC2,
	.pme_desc  = "Retired Branch Instructions",
	},
/* 57 */{.pme_name = "RETIRED_MISPREDICTED_BRANCH_INSTRUCTIONS",
	.pme_code  = 0xC3,
	.pme_desc  = "Retired Mispredicted Branch Instructions",
	},
/* 58 */{.pme_name = "RETIRED_TAKEN_BRANCH_INSTRUCTIONS",
	.pme_code  = 0xC4,
	.pme_desc  = "Retired Taken Branch Instructions",
	},
/* 59 */{.pme_name = "RETIRED_TAKEN_BRANCH_INSTRUCTIONS_MISPREDICTED",
	.pme_code  = 0xC5,
	.pme_desc  = "Retired Taken Branch Instructions Mispredicted",
	},
/* 60 */{.pme_name = "RETIRED_FAR_CONTROL_TRANSFERS",
	.pme_code  = 0xC6,
	.pme_desc  = "Retired Far Control Transfers",
	},
/* 61 */{.pme_name = "RETIRED_BRANCH_RESYNCS",
	.pme_code  = 0xC7,
	.pme_desc  = "Retired Branch Resyncs",
	},
/* 62 */{.pme_name = "RETIRED_NEAR_RETURNS",
	.pme_code  = 0xC8,
	.pme_desc  = "Retired Near Returns",
	},
/* 63 */{.pme_name = "RETIRED_NEAR_RETURNS_MISPREDICTED",
	.pme_code  = 0xC9,
	.pme_desc  = "Retired Near Returns Mispredicted",
	},
/* 64 */{.pme_name = "RETIRED_INDIRECT_BRANCHES_MISPREDICTED",
	.pme_code  = 0xCA,
	.pme_desc  = "Retired Indirect Branches Mispredicted",
	},
/* 65 */{.pme_name = "RETIRED_MMX_AND_FP_INSTRUCTIONS",
	.pme_code  = 0xCB,
	.pme_desc  = "Retired MMX/FP Instructions",
	.pme_flags = PFMLIB_AMD64_UMASK_COMBO,
	.pme_numasks = 4,
	.pme_umasks  = {
		{ .pme_uname = "X87",
		  .pme_udesc = "x87 instructions",
		  .pme_ucode = 0x01,
		},
		{ .pme_uname = "MMX_AND_3DNOW",
		  .pme_udesc = "MMX and 3DNow! instructions",
		  .pme_ucode = 0x02,
		},
		{ .pme_uname = "PACKED_SSE_AND_SSE2",
		  .pme_udesc = "SSE instructions (SSE, SSE2, SSE3, and SSE4A)",
		  .pme_ucode = 0x04,
		},
		{ .pme_uname = "ALL",
		  .pme_udesc = "All sub-events selected",
		  .pme_ucode = 0x07,
		},
	 },
	},
/* 66 */{.pme_name = "RETIRED_FASTPATH_DOUBLE_OP_INSTRUCTIONS",
	.pme_code  = 0xCC,
	.pme_desc  = "Retired Fastpath Double Op Instructions",
	.pme_flags = PFMLIB_AMD64_UMASK_COMBO,
	.pme_numasks = 4,
	.pme_umasks  = {
		{ .pme_uname = "POSITION_0",
		  .pme_udesc = "With low op in position 0",
		  .pme_ucode = 0x01,
		},
		{ .pme_uname = "POSITION_1",
		  .pme_udesc = "With low op in position 1",
		  .pme_ucode = 0x02,
		},
		{ .pme_uname = "POSITION_2",
		  .pme_udesc = "With low op in position 2",
		  .pme_ucode = 0x04,
		},
		{ .pme_uname = "ALL",
		  .pme_udesc = "All sub-events selected",
		  .pme_ucode = 0x07,
		},
	 },
	},
/* 67 */{.pme_name = "INTERRUPTS_MASKED_CYCLES",
	.pme_code  = 0xCD,
	.pme_desc  = "Interrupts-Masked Cycles",
	},
/* 68 */{.pme_name = "INTERRUPTS_MASKED_CYCLES_WITH_INTERRUPT_PENDING",
	.pme_code  = 0xCE,
	.pme_desc  = "Interrupts-Masked Cycles with Interrupt Pending",
	},
/* 69 */{.pme_name = "INTERRUPTS_TAKEN",
	.pme_code  = 0xCF,
	.pme_desc  = "Interrupts Taken",
	},
/* 70 */{.pme_name = "DECODER_EMPTY",
	.pme_code  = 0xD0,
	.pme_desc  = "Decoder Empty",
	},
/* 71 */{.pme_name = "DISPATCH_STALLS",
	.pme_code  = 0xD1,
	.pme_desc  = "Dispatch Stalls",
	},
/* 72 */{.pme_name = "DISPATCH_STALL_FOR_BRANCH_ABORT",
	.pme_code  = 0xD2,
	.pme_desc  = "Dispatch Stall for Branch Abort to Retire",
	},
/* 73 */{.pme_name = "DISPATCH_STALL_FOR_SERIALIZATION",
	.pme_code  = 0xD3,
	.pme_desc  = "Dispatch Stall for Serialization",
	},
/* 74 */{.pme_name = "DISPATCH_STALL_FOR_SEGMENT_LOAD",
	.pme_code  = 0xD4,
	.pme_desc  = "Dispatch Stall for Segment Load",
	},
/* 75 */{.pme_name = "DISPATCH_STALL_FOR_REORDER_BUFFER_FULL",
	.pme_code  = 0xD5,
	.pme_desc  = "Dispatch Stall for Reorder Buffer Full",
	},
/* 76 */{.pme_name = "DISPATCH_STALL_FOR_RESERVATION_STATION_FULL",
	.pme_code  = 0xD6,
	.pme_desc  = "Dispatch Stall for Reservation Station Full",
	},
/* 77 */{.pme_name = "DISPATCH_STALL_FOR_FPU_FULL",
	.pme_code  = 0xD7,
	.pme_desc  = "Dispatch Stall for FPU Full",
	},
/* 78 */{.pme_name = "DISPATCH_STALL_FOR_LS_FULL",
	.pme_code  = 0xD8,
	.pme_desc  = "Dispatch Stall for LS Full",
	},
/* 79 */{.pme_name = "DISPATCH_STALL_WAITING_FOR_ALL_QUIET",
	.pme_code  = 0xD9,
	.pme_desc  = "Dispatch Stall Waiting for All Quiet",
	},
/* 80 */{.pme_name = "DISPATCH_STALL_FOR_FAR_TRANSFER_OR_RSYNC",
	.pme_code  = 0xDA,
	.pme_desc  = "Dispatch Stall for Far Transfer or Resync to Retire",
	},
/* 81 */{.pme_name = "FPU_EXCEPTIONS",
	.pme_code  = 0xDB,
	.pme_desc  = "FPU Exceptions",
	.pme_flags = PFMLIB_AMD64_UMASK_COMBO,
	.pme_numasks = 5,
	.pme_umasks  = {
		{ .pme_uname = "X87_RECLASS_MICROFAULTS",
		  .pme_udesc = "x87 reclass microfaults",
		  .pme_ucode = 0x01,
		},
		{ .pme_uname = "SSE_RETYPE_MICROFAULTS",
		  .pme_udesc = "SSE retype microfaults",
		  .pme_ucode = 0x02,
		},
		{ .pme_uname = "SSE_RECLASS_MICROFAULTS",
		  .pme_udesc = "SSE reclass microfaults",
		  .pme_ucode = 0x04,
		},
		{ .pme_uname = "SSE_AND_X87_MICROTRAPS",
		  .pme_udesc = "SSE and x87 microtraps",
		  .pme_ucode = 0x08,
		},
		{ .pme_uname = "ALL",
		  .pme_udesc = "All sub-events selected",
		  .pme_ucode = 0x0F,
		},
	 },
	},
/* 82 */{.pme_name = "DR0_BREAKPOINT_MATCHES",
	.pme_code  = 0xDC,
	.pme_desc  = "DR0 Breakpoint Matches",
	},
/* 83 */{.pme_name = "DR1_BREAKPOINT_MATCHES",
	.pme_code  = 0xDD,
	.pme_desc  = "DR1 Breakpoint Matches",
	},
/* 84 */{.pme_name = "DR2_BREAKPOINT_MATCHES",
	.pme_code  = 0xDE,
	.pme_desc  = "DR2 Breakpoint Matches",
	},
/* 85 */{.pme_name = "DR3_BREAKPOINT_MATCHES",
	.pme_code  = 0xDF,
	.pme_desc  = "DR3 Breakpoint Matches",
	},
/* 86 */{.pme_name = "DRAM_ACCESSES_PAGE",
	.pme_code  = 0xE0,
	.pme_desc  = "DRAM Accesses",
	.pme_flags = PFMLIB_AMD64_UMASK_COMBO,
	.pme_numasks = 7,
	.pme_umasks  = {
		{ .pme_uname = "HIT",
		  .pme_udesc = "DCT0 Page hit",
		  .pme_ucode = 0x01,
		},
		{ .pme_uname = "MISS",
		  .pme_udesc = "DCT0 Page Miss",
		  .pme_ucode = 0x02,
		},
		{ .pme_uname = "CONFLICT",
		  .pme_udesc = "DCT0 Page Conflict",
		  .pme_ucode = 0x04,
		},
		{ .pme_uname = "DCT1_PAGE_HIT",
		  .pme_udesc = "DCT1 Page hit",
		  .pme_ucode = 0x08,
		},
		{ .pme_uname = "DCT1_PAGE_MISS",
		  .pme_udesc = "DCT1 Page Miss",
		  .pme_ucode = 0x10,
		},
		{ .pme_uname = "DCT1_PAGE_CONFLICT",
		  .pme_udesc = "DCT1 Page Conflict",
		  .pme_ucode = 0x20,
		},
		{ .pme_uname = "ALL",
		  .pme_udesc = "All sub-events selected",
		  .pme_ucode = 0x3F,
		},
	 },
	},
/* 87 */{.pme_name = "MEMORY_CONTROLLER_PAGE_TABLE_OVERFLOWS",
	.pme_code  = 0xE1,
	.pme_desc  = "DRAM Controller Page Table Overflows",
	.pme_flags = PFMLIB_AMD64_UMASK_COMBO,
	.pme_numasks = 3,
	.pme_umasks  = {
		{ .pme_uname = "DCT0_PAGE_TABLE_OVERFLOW",
		  .pme_udesc = "DCT0 Page Table Overflow",
		  .pme_ucode = 0x01,
		},
		{ .pme_uname = "DCT1_PAGE_TABLE_OVERFLOW",
		  .pme_udesc = "DCT1 Page Table Overflow",
		  .pme_ucode = 0x02,
		},
		{ .pme_uname = "ALL",
		  .pme_udesc = "All sub-events selected",
		  .pme_ucode = 0x03,
		},
	 },
	},
/* 88 */{.pme_name = "MEMORY_CONTROLLER_SLOT_MISSES",
	.pme_code  = 0xE2,
	.pme_desc  = "Memory Controller DRAM Command Slots Missed",
	.pme_flags = PFMLIB_AMD64_UMASK_COMBO,
	.pme_numasks = 3,
	.pme_umasks  = {
		{ .pme_uname = "DCT0_COMMAND_SLOTS_MISSED",
		  .pme_udesc = "DCT0 Command Slots Missed",
		  .pme_ucode = 0x01,
		},
		{ .pme_uname = "DCT1_COMMAND_SLOTS_MISSED",
		  .pme_udesc = "DCT1 Command Slots Missed",
		  .pme_ucode = 0x02,
		},
		{ .pme_uname = "ALL",
		  .pme_udesc = "All sub-events selected",
		  .pme_ucode = 0x03,
		},
	 },
	},
/* 89 */{.pme_name = "MEMORY_CONTROLLER_TURNAROUNDS",
	.pme_code  = 0xE3,
	.pme_desc  = "Memory Controller Turnarounds",
	.pme_flags = PFMLIB_AMD64_UMASK_COMBO,
	.pme_numasks = 7,
	.pme_umasks  = {
		{ .pme_uname = "CHIP_SELECT",
		  .pme_udesc = "DCT0 DIMM (chip select) turnaround",
		  .pme_ucode = 0x01,
		},
		{ .pme_uname = "READ_TO_WRITE",
		  .pme_udesc = "DCT0 Read to write turnaround",
		  .pme_ucode = 0x02,
		},
		{ .pme_uname = "WRITE_TO_READ",
		  .pme_udesc = "DCT0 Write to read turnaround",
		  .pme_ucode = 0x04,
		},
		{ .pme_uname = "DCT1_DIMM",
		  .pme_udesc = "DCT1 DIMM (chip select) turnaround",
		  .pme_ucode = 0x08,
		},
		{ .pme_uname = "DCT1_READ_TO_WRITE_TURNAROUND",
		  .pme_udesc = "DCT1 Read to write turnaround",
		  .pme_ucode = 0x10,
		},
		{ .pme_uname = "DCT1_WRITE_TO_READ_TURNAROUND",
		  .pme_udesc = "DCT1 Write to read turnaround",
		  .pme_ucode = 0x20,
		},
		{ .pme_uname = "ALL",
		  .pme_udesc = "All sub-events selected",
		  .pme_ucode = 0x3F,
		},
	 },
	},
/* 90 */{.pme_name = "MEMORY_CONTROLLER_BYPASS",
	.pme_code  = 0xE4,
	.pme_desc  = "Memory Controller Bypass Counter Saturation",
	.pme_flags = PFMLIB_AMD64_UMASK_COMBO,
	.pme_numasks = 5,
	.pme_umasks  = {
		{ .pme_uname = "HIGH_PRIORITY",
		  .pme_udesc = "Memory controller high priority bypass",
		  .pme_ucode = 0x01,
		},
		{ .pme_uname = "LOW_PRIORITY",
		  .pme_udesc = "Memory controller medium priority bypass",
		  .pme_ucode = 0x02,
		},
		{ .pme_uname = "DRAM_INTERFACE",
		  .pme_udesc = "DCT0 DCQ bypass",
		  .pme_ucode = 0x04,
		},
		{ .pme_uname = "DRAM_QUEUE",
		  .pme_udesc = "DCT1 DCQ bypass",
		  .pme_ucode = 0x08,
		},
		{ .pme_uname = "ALL",
		  .pme_udesc = "All sub-events selected",
		  .pme_ucode = 0x0F,
		},
	 },
	},
/* 91 */{.pme_name = "THERMAL_STATUS_AND_ECC_ERRORS",
	.pme_code  = 0xE8,
	.pme_desc  = "Thermal Status",
	.pme_flags = PFMLIB_AMD64_UMASK_COMBO,
	.pme_numasks = 6,
	.pme_umasks  = {
		{ .pme_uname = "CLKS_DIE_TEMP_TOO_HIGH",
		  .pme_udesc = "Number of times the HTC trip point is crossed",
		  .pme_ucode = 0x04,
		},
		{ .pme_uname = "CLKS_TEMP_THRESHOLD_EXCEEDED",
		  .pme_udesc = "Number of clocks when STC trip point active",
		  .pme_ucode = 0x08,
		},
		{ .pme_uname = "STC_TRIP_POINTS_CROSSED",
		  .pme_udesc = "Number of times the STC trip point is crossed",
		  .pme_ucode = 0x10,
		},
		{ .pme_uname = "CLOCKS_HTC_P_STATE_INACTIVE",
		  .pme_udesc = "Number of clocks HTC P-state is inactive.",
		  .pme_ucode = 0x20,
		},
		{ .pme_uname = "CLOCKS_HTC_P_STATE_ACTIVE",
		  .pme_udesc = "Number of clocks HTC P-state is active",
		  .pme_ucode = 0x40,
		},
		{ .pme_uname = "ALL",
		  .pme_udesc = "All sub-events selected",
		  .pme_ucode = 0x7C,
		},
	 },
	},
/* 92 */{.pme_name = "CPU_IO_REQUESTS_TO_MEMORY_IO",
	.pme_code  = 0xE9,
	.pme_desc  = "CPU/IO Requests to Memory/IO",
	.pme_flags = PFMLIB_AMD64_UMASK_COMBO,
	.pme_numasks = 9,
	.pme_umasks  = {
		{ .pme_uname = "I_O_TO_I_O",
		  .pme_udesc = "IO to IO",
		  .pme_ucode = 0x01,
		},
		{ .pme_uname = "I_O_TO_MEM",
		  .pme_udesc = "IO to Mem",
		  .pme_ucode = 0x02,
		},
		{ .pme_uname = "CPU_TO_I_O",
		  .pme_udesc = "CPU to IO",
		  .pme_ucode = 0x04,
		},
		{ .pme_uname = "CPU_TO_MEM",
		  .pme_udesc = "CPU to Mem",
		  .pme_ucode = 0x08,
		},
		{ .pme_uname = "TO_REMOTE_NODE",
		  .pme_udesc = "To remote node",
		  .pme_ucode = 0x10,
		},
		{ .pme_uname = "TO_LOCAL_NODE",
		  .pme_udesc = "To local node",
		  .pme_ucode = 0x20,
		},
		{ .pme_uname = "FROM_REMOTE_NODE",
		  .pme_udesc = "From remote node",
		  .pme_ucode = 0x40,
		},
		{ .pme_uname = "FROM_LOCAL_NODE",
		  .pme_udesc = "From local node",
		  .pme_ucode = 0x80,
		},
		{ .pme_uname = "ALL",
		  .pme_udesc = "All sub-events selected",
		  .pme_ucode = 0xFF,
		},
	 },
	},
/* 93 */{.pme_name = "CACHE_BLOCK",
	.pme_code  = 0xEA,
	.pme_desc  = "Cache Block Commands",
	.pme_flags = PFMLIB_AMD64_UMASK_COMBO,
	.pme_numasks = 6,
	.pme_umasks  = {
		{ .pme_uname = "VICTIM_WRITEBACK",
		  .pme_udesc = "Victim Block (Writeback)",
		  .pme_ucode = 0x01,
		},
		{ .pme_uname = "DCACHE_LOAD_MISS",
		  .pme_udesc = "Read Block (Dcache load miss refill)",
		  .pme_ucode = 0x04,
		},
		{ .pme_uname = "SHARED_ICACHE_REFILL",
		  .pme_udesc = "Read Block Shared (Icache refill)",
		  .pme_ucode = 0x08,
		},
		{ .pme_uname = "READ_BLOCK_MODIFIED",
		  .pme_udesc = "Read Block Modified (Dcache store miss refill)",
		  .pme_ucode = 0x10,
		},
		{ .pme_uname = "READ_TO_DIRTY",
		  .pme_udesc = "Change-to-Dirty (first store to clean block already in cache)",
		  .pme_ucode = 0x20,
		},
		{ .pme_uname = "ALL",
		  .pme_udesc = "All sub-events selected",
		  .pme_ucode = 0x3D,
		},
	 },
	},
/* 94 */{.pme_name = "SIZED_COMMANDS",
	.pme_code  = 0xEB,
	.pme_desc  = "Sized Commands",
	.pme_flags = PFMLIB_AMD64_UMASK_COMBO,
	.pme_numasks = 7,
	.pme_umasks  = {
		{ .pme_uname = "NON_POSTED_WRITE_BYTE",
		  .pme_udesc = "Non-Posted SzWr Byte (1-32 bytes) Legacy or mapped IO, typically 1-4 bytes",
		  .pme_ucode = 0x01,
		},
		{ .pme_uname = "NON_POSTED_WRITE_DWORD",
		  .pme_udesc = "Non-Posted SzWr DW (1-16 dwords) Legacy or mapped IO, typically 1 DWORD",
		  .pme_ucode = 0x02,
		},
		{ .pme_uname = "POSTED_WRITE_BYTE",
		  .pme_udesc = "Posted SzWr Byte (1-32 bytes) Sub-cache-line DMA writes, size varies; also flushes of partially-filled Write Combining buffer",
		  .pme_ucode = 0x04,
		},
		{ .pme_uname = "POSTED_WRITE_DWORD",
		  .pme_udesc = "Posted SzWr DW (1-16 dwords) Block-oriented DMA writes, often cache-line sized; also processor Write Combining buffer flushes",
		  .pme_ucode = 0x08,
		},
		{ .pme_uname = "READ_BYTE_4_BYTES",
		  .pme_udesc = "SzRd Byte (4 bytes) Legacy or mapped IO",
		  .pme_ucode = 0x10,
		},
		{ .pme_uname = "READ_DWORD_1_16_DWORDS",
		  .pme_udesc = "SzRd DW (1-16 dwords) Block-oriented DMA reads, typically cache-line size",
		  .pme_ucode = 0x20,
		},
		{ .pme_uname = "ALL",
		  .pme_udesc = "All sub-events selected",
		  .pme_ucode = 0x3F,
		},
	 },
	},
/* 95 */{.pme_name = "PROBE",
	.pme_code  = 0xEC,
	.pme_desc  = "Probe Responses and Upstream Requests",
	.pme_flags = PFMLIB_AMD64_UMASK_COMBO,
	.pme_numasks = 9,
	.pme_umasks  = {
		{ .pme_uname = "MISS",
		  .pme_udesc = "Probe miss",
		  .pme_ucode = 0x01,
		},
		{ .pme_uname = "HIT_CLEAN",
		  .pme_udesc = "Probe hit clean",
		  .pme_ucode = 0x02,
		},
		{ .pme_uname = "HIT_DIRTY_NO_MEMORY_CANCEL",
		  .pme_udesc = "Probe hit dirty without memory cancel (probed by Sized Write or Change2Dirty)",
		  .pme_ucode = 0x04,
		},
		{ .pme_uname = "HIT_DIRTY_WITH_MEMORY_CANCEL",
		  .pme_udesc = "Probe hit dirty with memory cancel (probed by DMA read or cache refill request)",
		  .pme_ucode = 0x08,
		},
		{ .pme_uname = "UPSTREAM_DISPLAY_REFRESH_READS",
		  .pme_udesc = "Upstream display refresh/ISOC reads",
		  .pme_ucode = 0x10,
		},
		{ .pme_uname = "UPSTREAM_NON_DISPLAY_REFRESH_READS",
		  .pme_udesc = "Upstream non-display refresh reads",
		  .pme_ucode = 0x20,
		},
		{ .pme_uname = "UPSTREAM_WRITES",
		  .pme_udesc = "Upstream ISOC writes",
		  .pme_ucode = 0x40,
		},
		{ .pme_uname = "UPSTREAM_NON_ISOC_WRITES",
		  .pme_udesc = "Upstream non-ISOC writes",
		  .pme_ucode = 0x80,
		},
		{ .pme_uname = "ALL",
		  .pme_udesc = "All sub-events selected",
		  .pme_ucode = 0xFF,
		},
	 },
	},
/* 96 */{.pme_name = "GART",
	.pme_code  = 0xEE,
	.pme_desc  = "GART Events",
	.pme_flags = PFMLIB_AMD64_UMASK_COMBO,
	.pme_numasks = 9,
	.pme_umasks  = {
		{ .pme_uname = "APERTURE_HIT_FROM_CPU",
		  .pme_udesc = "GART aperture hit on access from CPU",
		  .pme_ucode = 0x01,
		},
		{ .pme_uname = "APERTURE_HIT_FROM_IO",
		  .pme_udesc = "GART aperture hit on access from IO",
		  .pme_ucode = 0x02,
		},
		{ .pme_uname = "MISS",
		  .pme_udesc = "GART miss",
		  .pme_ucode = 0x04,
		},
		{ .pme_uname = "REQUEST_HIT_TABLE_WALK",
		  .pme_udesc = "GART/DEV Request hit table walk in progress",
		  .pme_ucode = 0x08,
		},
		{ .pme_uname = "DEV_HIT",
		  .pme_udesc = "DEV hit",
		  .pme_ucode = 0x10,
		},
		{ .pme_uname = "DEV_MISS",
		  .pme_udesc = "DEV miss",
		  .pme_ucode = 0x20,
		},
		{ .pme_uname = "DEV_ERROR",
		  .pme_udesc = "DEV error",
		  .pme_ucode = 0x40,
		},
		{ .pme_uname = "MULTIPLE_TABLE_WALK",
		  .pme_udesc = "GART/DEV multiple table walk in progress",
		  .pme_ucode = 0x80,
		},
		{ .pme_uname = "ALL",
		  .pme_udesc = "All sub-events selected",
		  .pme_ucode = 0xFF,
		},
	 },
	},
/* 97 */{.pme_name = "MEMORY_CONTROLLER_REQUESTS",
	.pme_code  = 0x1F0,
	.pme_desc  = "Memory Controller Requests",
	.pme_flags = PFMLIB_AMD64_UMASK_COMBO,
	.pme_numasks = 9,
	.pme_umasks  = {
		{ .pme_uname = "WRITE_REQUESTS",
		  .pme_udesc = "Write requests sent to the DCT",
		  .pme_ucode = 0x01,
		},
		{ .pme_uname = "READ_REQUESTS",
		  .pme_udesc = "Read requests (including prefetch requests) sent to the DCT",
		  .pme_ucode = 0x02,
		},
		{ .pme_uname = "PREFETCH_REQUESTS",
		  .pme_udesc = "Prefetch requests sent to the DCT",
		  .pme_ucode = 0x04,
		},
		{ .pme_uname = "32_BYTES_WRITES",
		  .pme_udesc = "32 Bytes Sized Writes",
		  .pme_ucode = 0x08,
		},
		{ .pme_uname = "64_BYTES_WRITES",
		  .pme_udesc = "64 Bytes Sized Writes",
		  .pme_ucode = 0x10,
		},
		{ .pme_uname = "32_BYTES_READS",
		  .pme_udesc = "32 Bytes Sized Reads",
		  .pme_ucode = 0x20,
		},
		{ .pme_uname = "64_BYTES_READS",
		  .pme_udesc = "64 Byte Sized Reads",
		  .pme_ucode = 0x40,
		},
		{ .pme_uname = "READ_REQUESTS_WHILE_WRITES_REQUESTS",
		  .pme_udesc = "Read requests sent to the DCT while writes requests are pending in the DCT",
		  .pme_ucode = 0x80,
		},
		{ .pme_uname = "ALL",
		  .pme_udesc = "All sub-events selected",
		  .pme_ucode = 0xFF,
		},
	 },
	},
/* 98 */{.pme_name = "CPU_TO_DRAM_REQUESTS_TO_TARGET_NODE",
	.pme_code  = 0x1E0,
	.pme_desc  = "CPU to DRAM Requests to Target Node",
	.pme_flags = PFMLIB_AMD64_UMASK_COMBO,
	.pme_numasks = 9,
	.pme_umasks  = {
		{ .pme_uname = "LOCAL_TO_0",
		  .pme_udesc = "From Local node to Node 0",
		  .pme_ucode = 0x01,
		},
		{ .pme_uname = "LOCAL_TO_1",
		  .pme_udesc = "From Local node to Node 1",
		  .pme_ucode = 0x02,
		},
		{ .pme_uname = "LOCAL_TO_2",
		  .pme_udesc = "From Local node to Node 2",
		  .pme_ucode = 0x04,
		},
		{ .pme_uname = "LOCAL_TO_3",
		  .pme_udesc = "From Local node to Node 3",
		  .pme_ucode = 0x08,
		},
		{ .pme_uname = "LOCAL_TO_4",
		  .pme_udesc = "From Local node to Node 4",
		  .pme_ucode = 0x10,
		},
		{ .pme_uname = "LOCAL_TO_5",
		  .pme_udesc = "From Local node to Node 5",
		  .pme_ucode = 0x20,
		},
		{ .pme_uname = "LOCAL_TO_6",
		  .pme_udesc = "From Local node to Node 6",
		  .pme_ucode = 0x40,
		},
		{ .pme_uname = "LOCAL_TO_7",
		  .pme_udesc = "From Local node to Node 7",
		  .pme_ucode = 0x80,
		},
		{ .pme_uname = "ALL",
		  .pme_udesc = "All sub-events selected",
		  .pme_ucode = 0xFF,
		},
	 },
	},
/* 99 */{.pme_name = "IO_TO_DRAM_REQUESTS_TO_TARGET_NODE",
	.pme_code  = 0x1E1,
	.pme_desc  = "IO to DRAM Requests to Target Node",
	.pme_flags = PFMLIB_AMD64_UMASK_COMBO,
	.pme_numasks = 9,
	.pme_umasks  = {
		{ .pme_uname = "LOCAL_TO_0",
		  .pme_udesc = "From Local node to Node 0",
		  .pme_ucode = 0x01,
		},
		{ .pme_uname = "LOCAL_TO_1",
		  .pme_udesc = "From Local node to Node 1",
		  .pme_ucode = 0x02,
		},
		{ .pme_uname = "LOCAL_TO_2",
		  .pme_udesc = "From Local node to Node 2",
		  .pme_ucode = 0x04,
		},
		{ .pme_uname = "LOCAL_TO_3",
		  .pme_udesc = "From Local node to Node 3",
		  .pme_ucode = 0x08,
		},
		{ .pme_uname = "LOCAL_TO_4",
		  .pme_udesc = "From Local node to Node 4",
		  .pme_ucode = 0x10,
		},
		{ .pme_uname = "LOCAL_TO_5",
		  .pme_udesc = "From Local node to Node 5",
		  .pme_ucode = 0x20,
		},
		{ .pme_uname = "LOCAL_TO_6",
		  .pme_udesc = "From Local node to Node 6",
		  .pme_ucode = 0x40,
		},
		{ .pme_uname = "LOCAL_TO_7",
		  .pme_udesc = "From Local node to Node 7",
		  .pme_ucode = 0x80,
		},
		{ .pme_uname = "ALL",
		  .pme_udesc = "All sub-events selected",
		  .pme_ucode = 0xFF,
		},
	 },
	},
/* 100 */{.pme_name = "CPU_READ_COMMAND_LATENCY_TO_TARGET_NODE_0_3",
	.pme_code  = 0x1E2,
	.pme_desc  = "CPU Read Command Latency to Target Node 0-3",
	.pme_flags = PFMLIB_AMD64_UMASK_COMBO,
	.pme_numasks = 9,
	.pme_umasks  = {
		{ .pme_uname = "READ_BLOCK",
		  .pme_udesc = "Read block",
		  .pme_ucode = 0x01,
		},
		{ .pme_uname = "READ_BLOCK_SHARED",
		  .pme_udesc = "Read block shared",
		  .pme_ucode = 0x02,
		},
		{ .pme_uname = "READ_BLOCK_MODIFIED",
		  .pme_udesc = "Read block modified",
		  .pme_ucode = 0x04,
		},
		{ .pme_uname = "CHANGE_TO_DIRTY",
		  .pme_udesc = "Change-to-Dirty",
		  .pme_ucode = 0x08,
		},
		{ .pme_uname = "LOCAL_TO_0",
		  .pme_udesc = "From Local node to Node 0",
		  .pme_ucode = 0x10,
		},
		{ .pme_uname = "LOCAL_TO_1",
		  .pme_udesc = "From Local node to Node 1",
		  .pme_ucode = 0x20,
		},
		{ .pme_uname = "LOCAL_TO_2",
		  .pme_udesc = "From Local node to Node 2",
		  .pme_ucode = 0x40,
		},
		{ .pme_uname = "LOCAL_TO_3",
		  .pme_udesc = "From Local node to Node 3",
		  .pme_ucode = 0x80,
		},
		{ .pme_uname = "ALL",
		  .pme_udesc = "All sub-events selected",
		  .pme_ucode = 0xFF,
		},
	 },
	},
/* 101 */{.pme_name = "CPU_READ_COMMAND_REQUESTS_TO_TARGET_NODE_0_3",
	.pme_code  = 0x1E3,
	.pme_desc  = "CPU Read Command Requests to Target Node 0-3",
	.pme_flags = PFMLIB_AMD64_UMASK_COMBO,
	.pme_numasks = 9,
	.pme_umasks  = {
		{ .pme_uname = "READ_BLOCK",
		  .pme_udesc = "Read block",
		  .pme_ucode = 0x01,
		},
		{ .pme_uname = "READ_BLOCK_SHARED",
		  .pme_udesc = "Read block shared",
		  .pme_ucode = 0x02,
		},
		{ .pme_uname = "READ_BLOCK_MODIFIED",
		  .pme_udesc = "Read block modified",
		  .pme_ucode = 0x04,
		},
		{ .pme_uname = "CHANGE_TO_DIRTY",
		  .pme_udesc = "Change-to-Dirty",
		  .pme_ucode = 0x08,
		},
		{ .pme_uname = "LOCAL_TO_0",
		  .pme_udesc = "From Local node to Node 0",
		  .pme_ucode = 0x10,
		},
		{ .pme_uname = "LOCAL_TO_1",
		  .pme_udesc = "From Local node to Node 1",
		  .pme_ucode = 0x20,
		},
		{ .pme_uname = "LOCAL_TO_2",
		  .pme_udesc = "From Local node to Node 2",
		  .pme_ucode = 0x40,
		},
		{ .pme_uname = "LOCAL_TO_3",
		  .pme_udesc = "From Local node to Node 3",
		  .pme_ucode = 0x80,
		},
		{ .pme_uname = "ALL",
		  .pme_udesc = "All sub-events selected",
		  .pme_ucode = 0xFF,
		},
	 },
	},
/* 102 */{.pme_name = "CPU_READ_COMMAND_LATENCY_TO_TARGET_NODE_4_7",
	.pme_code  = 0x1E4,
	.pme_desc  = "CPU Read Command Latency to Target Node 4-7",
	.pme_flags = PFMLIB_AMD64_UMASK_COMBO,
	.pme_numasks = 9,
	.pme_umasks  = {
		{ .pme_uname = "READ_BLOCK",
		  .pme_udesc = "Read block",
		  .pme_ucode = 0x01,
		},
		{ .pme_uname = "READ_BLOCK_SHARED",
		  .pme_udesc = "Read block shared",
		  .pme_ucode = 0x02,
		},
		{ .pme_uname = "READ_BLOCK_MODIFIED",
		  .pme_udesc = "Read block modified",
		  .pme_ucode = 0x04,
		},
		{ .pme_uname = "CHANGE_TO_DIRTY",
		  .pme_udesc = "Change-to-Dirty",
		  .pme_ucode = 0x08,
		},
		{ .pme_uname = "LOCAL_TO_4",
		  .pme_udesc = "From Local node to Node 4",
		  .pme_ucode = 0x10,
		},
		{ .pme_uname = "LOCAL_TO_5",
		  .pme_udesc = "From Local node to Node 5",
		  .pme_ucode = 0x20,
		},
		{ .pme_uname = "LOCAL_TO_6",
		  .pme_udesc = "From Local node to Node 6",
		  .pme_ucode = 0x40,
		},
		{ .pme_uname = "LOCAL_TO_7",
		  .pme_udesc = "From Local node to Node 7",
		  .pme_ucode = 0x80,
		},
		{ .pme_uname = "ALL",
		  .pme_udesc = "All sub-events selected",
		  .pme_ucode = 0xFF,
		},
	 },
	},
/* 103 */{.pme_name = "CPU_READ_COMMAND_REQUESTS_TO_TARGET_NODE_4_7",
	.pme_code  = 0x1E5,
	.pme_desc  = "CPU Read Command Requests to Target Node 4-7",
	.pme_flags = PFMLIB_AMD64_UMASK_COMBO,
	.pme_numasks = 9,
	.pme_umasks  = {
		{ .pme_uname = "READ_BLOCK",
		  .pme_udesc = "Read block",
		  .pme_ucode = 0x01,
		},
		{ .pme_uname = "READ_BLOCK_SHARED",
		  .pme_udesc = "Read block shared",
		  .pme_ucode = 0x02,
		},
		{ .pme_uname = "READ_BLOCK_MODIFIED",
		  .pme_udesc = "Read block modified",
		  .pme_ucode = 0x04,
		},
		{ .pme_uname = "CHANGE_TO_DIRTY",
		  .pme_udesc = "Change-to-Dirty",
		  .pme_ucode = 0x08,
		},
		{ .pme_uname = "LOCAL_TO_4",
		  .pme_udesc = "From Local node to Node 4",
		  .pme_ucode = 0x10,
		},
		{ .pme_uname = "LOCAL_TO_5",
		  .pme_udesc = "From Local node to Node 5",
		  .pme_ucode = 0x20,
		},
		{ .pme_uname = "LOCAL_TO_6",
		  .pme_udesc = "From Local node to Node 6",
		  .pme_ucode = 0x40,
		},
		{ .pme_uname = "LOCAL_TO_7",
		  .pme_udesc = "From Local node to Node 7",
		  .pme_ucode = 0x80,
		},
		{ .pme_uname = "ALL",
		  .pme_udesc = "All sub-events selected",
		  .pme_ucode = 0xFF,
		},
	 },
	},
/* 104 */{.pme_name = "CPU_COMMAND_LATENCY_TO_TARGET_NODE_0_3_4_7",
	.pme_code  = 0x1E6,
	.pme_desc  = "CPU Command Latency to Target Node 0-3/4-7",
	.pme_flags = PFMLIB_AMD64_UMASK_COMBO,
	.pme_numasks = 9,
	.pme_umasks  = {
		{ .pme_uname = "READ_SIZED",
		  .pme_udesc = "Read Sized",
		  .pme_ucode = 0x01,
		},
		{ .pme_uname = "WRITE_SIZED",
		  .pme_udesc = "Write Sized",
		  .pme_ucode = 0x02,
		},
		{ .pme_uname = "VICTIM_BLOCK",
		  .pme_udesc = "Victim Block",
		  .pme_ucode = 0x04,
		},
		{ .pme_uname = "NODE_GROUP_SELECT",
		  .pme_udesc = "Node Group Select. 0=Nodes 0-3. 1= Nodes 4-7.",
		  .pme_ucode = 0x08,
		},
		{ .pme_uname = "LOCAL_TO_0_4",
		  .pme_udesc = "From Local node to Node 0/4",
		  .pme_ucode = 0x10,
		},
		{ .pme_uname = "LOCAL_TO_1_5",
		  .pme_udesc = "From Local node to Node 1/5",
		  .pme_ucode = 0x20,
		},
		{ .pme_uname = "LOCAL_TO_2_6",
		  .pme_udesc = "From Local node to Node 2/6",
		  .pme_ucode = 0x40,
		},
		{ .pme_uname = "LOCAL_TO_3_7",
		  .pme_udesc = "From Local node to Node 3/7",
		  .pme_ucode = 0x80,
		},
		{ .pme_uname = "ALL",
		  .pme_udesc = "All sub-events selected",
		  .pme_ucode = 0xFF,
		},
	 },
	},
/* 105 */{.pme_name = "CPU_REQUESTS_TO_TARGET_NODE_0_3_4_7",
	.pme_code  = 0x1E7,
	.pme_desc  = "CPU Requests to Target Node 0-3/4-7",
	.pme_flags = PFMLIB_AMD64_UMASK_COMBO,
	.pme_numasks = 9,
	.pme_umasks  = {
		{ .pme_uname = "READ_SIZED",
		  .pme_udesc = "Read Sized",
		  .pme_ucode = 0x01,
		},
		{ .pme_uname = "WRITE_SIZED",
		  .pme_udesc = "Write Sized",
		  .pme_ucode = 0x02,
		},
		{ .pme_uname = "VICTIM_BLOCK",
		  .pme_udesc = "Victim Block",
		  .pme_ucode = 0x04,
		},
		{ .pme_uname = "NODE_GROUP_SELECT",
		  .pme_udesc = "Node Group Select. 0=Nodes 0-3. 1= Nodes 4-7.",
		  .pme_ucode = 0x08,
		},
		{ .pme_uname = "LOCAL_TO_0_4",
		  .pme_udesc = "From Local node to Node 0/4",
		  .pme_ucode = 0x10,
		},
		{ .pme_uname = "LOCAL_TO_1_5",
		  .pme_udesc = "From Local node to Node 1/5",
		  .pme_ucode = 0x20,
		},
		{ .pme_uname = "LOCAL_TO_2_6",
		  .pme_udesc = "From Local node to Node 2/6",
		  .pme_ucode = 0x40,
		},
		{ .pme_uname = "LOCAL_TO_3_7",
		  .pme_udesc = "From Local node to Node 3/7",
		  .pme_ucode = 0x80,
		},
		{ .pme_uname = "ALL",
		  .pme_udesc = "All sub-events selected",
		  .pme_ucode = 0xFF,
		},
	 },
	},
/* 106 */{.pme_name = "HYPERTRANSPORT_LINK0",
	.pme_code  = 0xF6,
	.pme_desc  = "HyperTransport Link 0 Transmit Bandwidth",
	.pme_flags = PFMLIB_AMD64_UMASK_COMBO,
	.pme_numasks = 8,
	.pme_umasks  = {
		{ .pme_uname = "COMMAND_DWORD_SENT",
		  .pme_udesc = "Command DWORD sent",
		  .pme_ucode = 0x01,
		},
		{ .pme_uname = "DATA_DWORD_SENT",
		  .pme_udesc = "Data DWORD sent",
		  .pme_ucode = 0x02,
		},
		{ .pme_uname = "BUFFER_RELEASE_DWORD_SENT",
		  .pme_udesc = "Buffer release DWORD sent",
		  .pme_ucode = 0x04,
		},
		{ .pme_uname = "NOP_DWORD_SENT",
		  .pme_udesc = "Nop DW sent (idle)",
		  .pme_ucode = 0x08,
		},
		{ .pme_uname = "ADDRESS_EXT_DWORD_SENT",
		  .pme_udesc = "Address extension DWORD sent",
		  .pme_ucode = 0x10,
		},
		{ .pme_uname = "PER_PACKET_CRC_SENT",
		  .pme_udesc = "Per packet CRC sent",
		  .pme_ucode = 0x20,
		},
		{ .pme_uname = "SUBLINK_MASK",
		  .pme_udesc = "SubLink Mask",
		  .pme_ucode = 0x80,
		},
		{ .pme_uname = "ALL",
		  .pme_udesc = "All sub-events selected",
		  .pme_ucode = 0xBF,
		},
	 },
	},
/* 107 */{.pme_name = "HYPERTRANSPORT_LINK1",
	.pme_code  = 0xF7,
	.pme_desc  = "HyperTransport Link 1 Transmit Bandwidth",
	.pme_flags = PFMLIB_AMD64_UMASK_COMBO,
	.pme_numasks = 8,
	.pme_umasks  = {
		{ .pme_uname = "COMMAND_DWORD_SENT",
		  .pme_udesc = "Command DWORD sent",
		  .pme_ucode = 0x01,
		},
		{ .pme_uname = "DATA_DWORD_SENT",
		  .pme_udesc = "Data DWORD sent",
		  .pme_ucode = 0x02,
		},
		{ .pme_uname = "BUFFER_RELEASE_DWORD_SENT",
		  .pme_udesc = "Buffer release DWORD sent",
		  .pme_ucode = 0x04,
		},
		{ .pme_uname = "NOP_DWORD_SENT",
		  .pme_udesc = "Nop DW sent (idle)",
		  .pme_ucode = 0x08,
		},
		{ .pme_uname = "ADDRESS_EXT_DWORD_SENT",
		  .pme_udesc = "Address extension DWORD sent",
		  .pme_ucode = 0x10,
		},
		{ .pme_uname = "PER_PACKET_CRC_SENT",
		  .pme_udesc = "Per packet CRC sent",
		  .pme_ucode = 0x20,
		},
		{ .pme_uname = "SUBLINK_MASK",
		  .pme_udesc = "SubLink Mask",
		  .pme_ucode = 0x80,
		},
		{ .pme_uname = "ALL",
		  .pme_udesc = "All sub-events selected",
		  .pme_ucode = 0xBF,
		},
	 },
	},
/* 108 */{.pme_name = "HYPERTRANSPORT_LINK2",
	.pme_code  = 0xF8,
	.pme_desc  = "HyperTransport Link 2 Transmit Bandwidth",
	.pme_flags = PFMLIB_AMD64_UMASK_COMBO,
	.pme_numasks = 8,
	.pme_umasks  = {
		{ .pme_uname = "COMMAND_DWORD_SENT",
		  .pme_udesc = "Command DWORD sent",
		  .pme_ucode = 0x01,
		},
		{ .pme_uname = "DATA_DWORD_SENT",
		  .pme_udesc = "Data DWORD sent",
		  .pme_ucode = 0x02,
		},
		{ .pme_uname = "BUFFER_RELEASE_DWORD_SENT",
		  .pme_udesc = "Buffer release DWORD sent",
		  .pme_ucode = 0x04,
		},
		{ .pme_uname = "NOP_DWORD_SENT",
		  .pme_udesc = "Nop DW sent (idle)",
		  .pme_ucode = 0x08,
		},
		{ .pme_uname = "ADDRESS_EXT_DWORD_SENT",
		  .pme_udesc = "Address extension DWORD sent",
		  .pme_ucode = 0x10,
		},
		{ .pme_uname = "PER_PACKET_CRC_SENT",
		  .pme_udesc = "Per packet CRC sent",
		  .pme_ucode = 0x20,
		},
		{ .pme_uname = "SUBLINK_MASK",
		  .pme_udesc = "SubLink Mask",
		  .pme_ucode = 0x80,
		},
		{ .pme_uname = "ALL",
		  .pme_udesc = "All sub-events selected",
		  .pme_ucode = 0xBF,
		},
	 },
	},
/* 109 */{.pme_name = "HYPERTRANSPORT_LINK3",
	.pme_code  = 0x1F9,
	.pme_desc  = "HyperTransport Link 3 Transmit Bandwidth",
	.pme_flags = PFMLIB_AMD64_UMASK_COMBO,
	.pme_numasks = 8,
	.pme_umasks  = {
		{ .pme_uname = "COMMAND_DWORD_SENT",
		  .pme_udesc = "Command DWORD sent",
		  .pme_ucode = 0x01,
		},
		{ .pme_uname = "DATA_DWORD_SENT",
		  .pme_udesc = "Data DWORD sent",
		  .pme_ucode = 0x02,
		},
		{ .pme_uname = "BUFFER_RELEASE_DWORD_SENT",
		  .pme_udesc = "Buffer release DWORD sent",
		  .pme_ucode = 0x04,
		},
		{ .pme_uname = "NOP_DWORD_SENT",
		  .pme_udesc = "Nop DW sent (idle)",
		  .pme_ucode = 0x08,
		},
		{ .pme_uname = "ADDRESS_EXT_DWORD_SENT",
		  .pme_udesc = "Address DWORD sent",
		  .pme_ucode = 0x10,
		},
		{ .pme_uname = "PER_PACKET_CRC_SENT",
		  .pme_udesc = "Per packet CRC sent",
		  .pme_ucode = 0x20,
		},
		{ .pme_uname = "SUBLINK_MASK",
		  .pme_udesc = "SubLink Mask",
		  .pme_ucode = 0x80,
		},
		{ .pme_uname = "ALL",
		  .pme_udesc = "All sub-events selected",
		  .pme_ucode = 0xBF,
		},
	 },
	},
/* 110 */{.pme_name = "READ_REQUEST_TO_L3_CACHE",
	.pme_code  = 0x4E0,
	.pme_desc  = "Read Request to L3 Cache",
	.pme_flags = PFMLIB_AMD64_UMASK_COMBO|PFMLIB_AMD64_TILL_FAM10H_REV_C,
	.pme_numasks = 5,
	.pme_umasks  = {
		{ .pme_uname = "READ_BLOCK_EXCLUSIVE",
		  .pme_udesc = "Read Block Exclusive (Data cache read)",
		  .pme_ucode = 0x01,
		},
		{ .pme_uname = "READ_BLOCK_SHARED",
		  .pme_udesc = "Read Block Shared (Instruction cache read)",
		  .pme_ucode = 0x02,
		},
		{ .pme_uname = "READ_BLOCK_MODIFY",
		  .pme_udesc = "Read Block Modify",
		  .pme_ucode = 0x04,
		},
		{ .pme_uname = "ANY_READ",
		  .pme_udesc = "any read modes (exclusive, shared, modify)",
		  .pme_ucode = 0x07,
		},
#if 0
/*
 *    http://support.amd.com/us/Processor_TechDocs/41322.pdf
 *
 *    Issue number 437 on page 131.
 *
 */
		{ .pme_uname = "CORE_0_SELECT",
		  .pme_udesc = "Core 0 Select",
		  .pme_ucode = 0x10,
		},
		{ .pme_uname = "CORE_1_SELECT",
		  .pme_udesc = "Core 1 Select",
		  .pme_ucode = 0x20,
		},
		{ .pme_uname = "CORE_2_SELECT",
		  .pme_udesc = "Core 2 Select",
		  .pme_ucode = 0x40,
		},
		{ .pme_uname = "CORE_3_SELECT",
		  .pme_udesc = "Core 3 Select",
		  .pme_ucode = 0x80,
		},
#endif
		{ .pme_uname = "ALL_CORES",
		  .pme_udesc = "All cores",
		  .pme_ucode = 0xF0,
		},
	 },
	},
/* 111 */{.pme_name = "L3_CACHE_MISSES",
	.pme_code  = 0x4E1,
	.pme_desc  = "L3 Cache Misses",
	.pme_flags = PFMLIB_AMD64_UMASK_COMBO|PFMLIB_AMD64_TILL_FAM10H_REV_C,
	.pme_numasks = 5,
	.pme_umasks  = {
		{ .pme_uname = "READ_BLOCK_EXCLUSIVE",
		  .pme_udesc = "Read Block Exclusive (Data cache read)",
		  .pme_ucode = 0x01,
		},
		{ .pme_uname = "READ_BLOCK_SHARED",
		  .pme_udesc = "Read Block Shared (Instruction cache read)",
		  .pme_ucode = 0x02,
		},
		{ .pme_uname = "READ_BLOCK_MODIFY",
		  .pme_udesc = "Read Block Modify",
		  .pme_ucode = 0x04,
		},
		{ .pme_uname = "ANY_READ",
		  .pme_udesc = "any read modes (exclusive, shared, modify)",
		  .pme_ucode = 0x07,
		},
#if 0
/*
 *    http://support.amd.com/us/Processor_TechDocs/41322.pdf
 *
 *    Issue number 437 on page 131.
 *
 */
		{ .pme_uname = "CORE_0_SELECT",
		  .pme_udesc = "Core 0 Select",
		  .pme_ucode = 0x10,
		},
		{ .pme_uname = "CORE_1_SELECT",
		  .pme_udesc = "Core 1 Select",
		  .pme_ucode = 0x20,
		},
		{ .pme_uname = "CORE_2_SELECT",
		  .pme_udesc = "Core 2 Select",
		  .pme_ucode = 0x40,
		},
		{ .pme_uname = "CORE_3_SELECT",
		  .pme_udesc = "Core 3 Select",
		  .pme_ucode = 0x80,
		},
#endif
		{ .pme_uname = "ALL_CORES",
		  .pme_udesc = "All cores",
		  .pme_ucode = 0xF0,
		},
	 },
	},
/* 112 */{.pme_name = "L3_FILLS_CAUSED_BY_L2_EVICTIONS",
	.pme_code  = 0x4E2,
	.pme_desc  = "L3 Fills caused by L2 Evictions",
	.pme_flags = PFMLIB_AMD64_UMASK_COMBO|PFMLIB_AMD64_TILL_FAM10H_REV_C,
	.pme_numasks = 6,
	.pme_umasks  = {
		{ .pme_uname = "SHARED",
		  .pme_udesc = "Shared",
		  .pme_ucode = 0x01,
		},
		{ .pme_uname = "EXCLUSIVE",
		  .pme_udesc = "Exclusive",
		  .pme_ucode = 0x02,
		},
		{ .pme_uname = "OWNED",
		  .pme_udesc = "Owned",
		  .pme_ucode = 0x04,
		},
		{ .pme_uname = "MODIFIED",
		  .pme_udesc = "Modified",
		  .pme_ucode = 0x08,
		},
		{ .pme_uname = "ANY_STATE",
		  .pme_udesc = "any line state (shared, owned, exclusive, modified)",
		  .pme_ucode = 0x0F,
		},
#if 0
/*
 *    http://support.amd.com/us/Processor_TechDocs/41322.pdf
 *
 *    Issue number 437 on page 131.
 *
 */
		{ .pme_uname = "CORE_0_SELECT",
		  .pme_udesc = "Core 0 Select",
		  .pme_ucode = 0x10,
		},
		{ .pme_uname = "CORE_1_SELECT",
		  .pme_udesc = "Core 1 Select",
		  .pme_ucode = 0x20,
		},
		{ .pme_uname = "CORE_2_SELECT",
		  .pme_udesc = "Core 2 Select",
		  .pme_ucode = 0x40,
		},
		{ .pme_uname = "CORE_3_SELECT",
		  .pme_udesc = "Core 3 Select",
		  .pme_ucode = 0x80,
		},
#endif
		{ .pme_uname = "ALL_CORES",
		  .pme_udesc = "All cores",
		  .pme_ucode = 0xF0,
		},
	 },
	},
/* 113 */{.pme_name = "L3_EVICTIONS",
	.pme_code  = 0x4E3,
	.pme_desc  = "L3 Evictions",
	.pme_flags = PFMLIB_AMD64_UMASK_COMBO,
	.pme_numasks = 5,
	.pme_umasks  = {
		{ .pme_uname = "SHARED",
		  .pme_udesc = "Shared",
		  .pme_ucode = 0x01,
		},
		{ .pme_uname = "EXCLUSIVE",
		  .pme_udesc = "Exclusive",
		  .pme_ucode = 0x02,
		},
		{ .pme_uname = "OWNED",
		  .pme_udesc = "Owned",
		  .pme_ucode = 0x04,
		},
		{ .pme_uname = "MODIFIED",
		  .pme_udesc = "Modified",
		  .pme_ucode = 0x08,
		},
		{ .pme_uname = "ALL",
		  .pme_udesc = "All sub-events selected",
		  .pme_ucode = 0x0F,
		},
	 },
	},

/* Family 10h RevC, Shanghai */

/* 114 */{.pme_name = "PAGE_SIZE_MISMATCHES",
	.pme_code  = 0x165,
	.pme_desc  = "Page Size Mismatches",
	.pme_flags = PFMLIB_AMD64_UMASK_COMBO|PFMLIB_AMD64_FAM10H_REV_C,
	.pme_numasks = 4,
	.pme_umasks  = {
		{ .pme_uname = "GUEST_LARGER",
		  .pme_udesc = "Guest page size is larger than the host page size.",
		  .pme_ucode = 0x01,
		},
		{ .pme_uname = "MTRR_MISMATCH",
		  .pme_udesc = "MTRR mismatch.",
		  .pme_ucode = 0x02,
		},
		{ .pme_uname = "HOST_LARGER",
		  .pme_udesc = "Host page size is larger than the guest page size.",
		  .pme_ucode = 0x04,
		},
		{ .pme_uname = "ALL",
		  .pme_udesc = "All sub-events selected",
		  .pme_ucode = 0x07,
		},
	 },
	},
/* 115 */{.pme_name = "RETIRED_X87_OPS",
	.pme_code  = 0x1C0,
	.pme_desc  = "Retired x87 Floating Point Operations",
	.pme_flags = PFMLIB_AMD64_UMASK_COMBO|PFMLIB_AMD64_FAM10H_REV_C,
	.pme_numasks = 4,
	.pme_umasks  = {
		{ .pme_uname = "ADD_SUB_OPS",
		  .pme_udesc = "Add/subtract ops",
		  .pme_ucode = 0x01,
		},
		{ .pme_uname = "MUL_OPS",
		  .pme_udesc = "Multiply ops",
		  .pme_ucode = 0x02,
		},
		{ .pme_uname = "DIV_OPS",
		  .pme_udesc = "Divide ops",
		  .pme_ucode = 0x04,
		},
		{ .pme_uname = "ALL",
		  .pme_udesc = "All sub-events selected",
		  .pme_ucode = 0x07,
		},
	 },
	},
/* 116 */{.pme_name = "IBS_OPS_TAGGED",
	.pme_code  = 0x1CF,
	.pme_desc  = "IBS Ops Tagged",
	.pme_flags = PFMLIB_AMD64_FAM10H_REV_C,
	},
/* 117 */{.pme_name = "LFENCE_INST_RETIRED",
	.pme_code  = 0x1D3,
	.pme_desc  = "LFENCE Instructions Retired",
	.pme_flags = PFMLIB_AMD64_FAM10H_REV_C,
	},
/* 118 */{.pme_name = "SFENCE_INST_RETIRED",
	.pme_code  = 0x1D4,
	.pme_desc  = "SFENCE Instructions Retired",
	.pme_flags = PFMLIB_AMD64_FAM10H_REV_C,
	},
/* 119 */{.pme_name = "MFENCE_INST_RETIRED",
	.pme_code  = 0x1D5,
	.pme_desc  = "MFENCE Instructions Retired",
	.pme_flags = PFMLIB_AMD64_FAM10H_REV_C,
	},

/* Family 10h RevD, Istanbul */

/* 120 */{.pme_name = "READ_REQUEST_TO_L3_CACHE",
	.pme_code  = 0x4E0,
	.pme_desc  = "Read Request to L3 Cache",
	.pme_flags = PFMLIB_AMD64_UMASK_COMBO|PFMLIB_AMD64_FAM10H_REV_D,
	.pme_numasks = 5,
	.pme_umasks  = {
		{ .pme_uname = "READ_BLOCK_EXCLUSIVE",
		  .pme_udesc = "Read Block Exclusive (Data cache read)",
		  .pme_ucode = 0x01,
		},
		{ .pme_uname = "READ_BLOCK_SHARED",
		  .pme_udesc = "Read Block Shared (Instruction cache read)",
		  .pme_ucode = 0x02,
		},
		{ .pme_uname = "READ_BLOCK_MODIFY",
		  .pme_udesc = "Read Block Modify",
		  .pme_ucode = 0x04,
		},
		{ .pme_uname = "ANY_READ",
		  .pme_udesc = "any read modes (exclusive, shared, modify)",
		  .pme_ucode = 0x07,
		},
#if 0
/*
 *    http://support.amd.com/us/Processor_TechDocs/41322.pdf
 *
 *    Issue number 437 on page 131.
 *
 */
	
		{ .pme_uname = "CORE_0_SELECT",
		  .pme_udesc = "Core 0 Select",
		  .pme_ucode = 0x00,
		},
		{ .pme_uname = "CORE_1_SELECT",
		  .pme_udesc = "Core 1 Select",
		  .pme_ucode = 0x10,
		},
		{ .pme_uname = "CORE_2_SELECT",
		  .pme_udesc = "Core 2 Select",
		  .pme_ucode = 0x20,
		},
		{ .pme_uname = "CORE_3_SELECT",
		  .pme_udesc = "Core 3 Select",
		  .pme_ucode = 0x30,
		},
		{ .pme_uname = "CORE_4_SELECT",
		  .pme_udesc = "Core 4 Select",
		  .pme_ucode = 0x40,
		},
		{ .pme_uname = "CORE_5_SELECT",
		  .pme_udesc = "Core 5 Select",
		  .pme_ucode = 0x50,
		},
		{ .pme_uname = "ANY_CORE",
		  .pme_udesc = "Any core",
		  .pme_ucode = 0xF0,
		},
#endif
		{ .pme_uname = "ALL_CORES",
		  .pme_udesc = "All cores",
		  .pme_ucode = 0xF0,
		},
	 },
	},
/* 121 */{.pme_name = "L3_CACHE_MISSES",
	.pme_code  = 0x4E1,
	.pme_desc  = "L3 Cache Misses",
	.pme_flags = PFMLIB_AMD64_UMASK_COMBO|PFMLIB_AMD64_FAM10H_REV_D,
	.pme_numasks = 5,
	.pme_umasks  = {
		{ .pme_uname = "READ_BLOCK_EXCLUSIVE",
		  .pme_udesc = "Read Block Exclusive (Data cache read)",
		  .pme_ucode = 0x01,
		},
		{ .pme_uname = "READ_BLOCK_SHARED",
		  .pme_udesc = "Read Block Shared (Instruction cache read)",
		  .pme_ucode = 0x02,
		},
		{ .pme_uname = "READ_BLOCK_MODIFY",
		  .pme_udesc = "Read Block Modify",
		  .pme_ucode = 0x04,
		},
		{ .pme_uname = "ANY_READ",
		  .pme_udesc = "any read modes (exclusive, shared, modify)",
		  .pme_ucode = 0x07,
		},
#if 0
/*
 *    http://support.amd.com/us/Processor_TechDocs/41322.pdf
 *
 *    Issue number 437 on page 131.
 *
 */

		{ .pme_uname = "CORE_0_SELECT",
		  .pme_udesc = "Core 0 Select",
		  .pme_ucode = 0x00,
		},
		{ .pme_uname = "CORE_1_SELECT",
		  .pme_udesc = "Core 1 Select",
		  .pme_ucode = 0x10,
		},
		{ .pme_uname = "CORE_2_SELECT",
		  .pme_udesc = "Core 2 Select",
		  .pme_ucode = 0x20,
		},
		{ .pme_uname = "CORE_3_SELECT",
		  .pme_udesc = "Core 3 Select",
		  .pme_ucode = 0x30,
		},
		{ .pme_uname = "CORE_4_SELECT",
		  .pme_udesc = "Core 4 Select",
		  .pme_ucode = 0x40,
		},
		{ .pme_uname = "CORE_5_SELECT",
		  .pme_udesc = "Core 5 Select",
		  .pme_ucode = 0x50,
		},
		{ .pme_uname = "ANY_CORE",
		  .pme_udesc = "Any core",
		  .pme_ucode = 0xF0,
		},
#endif
		{ .pme_uname = "ALL_CORES",
		  .pme_udesc = "All cores",
		  .pme_ucode = 0xF0,
		},
	 },
	},
/* 122 */{.pme_name = "L3_FILLS_CAUSED_BY_L2_EVICTIONS",
	.pme_code  = 0x4E2,
	.pme_desc  = "L3 Fills caused by L2 Evictions",
	.pme_flags = PFMLIB_AMD64_UMASK_COMBO|PFMLIB_AMD64_FAM10H_REV_D,
	.pme_numasks = 6,
	.pme_umasks  = {
		{ .pme_uname = "SHARED",
		  .pme_udesc = "Shared",
		  .pme_ucode = 0x01,
		},
		{ .pme_uname = "EXCLUSIVE",
		  .pme_udesc = "Exclusive",
		  .pme_ucode = 0x02,
		},
		{ .pme_uname = "OWNED",
		  .pme_udesc = "Owned",
		  .pme_ucode = 0x04,
		},
		{ .pme_uname = "MODIFIED",
		  .pme_udesc = "Modified",
		  .pme_ucode = 0x08,
		},
		{ .pme_uname = "ANY_STATE",
		  .pme_udesc = "any line state (shared, owned, exclusive, modified)",
		  .pme_ucode = 0x0F,
		},
#if 0
/*
 *    http://support.amd.com/us/Processor_TechDocs/41322.pdf
 *
 *    Issue number 437 on page 131.
 *
 */

		{ .pme_uname = "CORE_0_SELECT",
		  .pme_udesc = "Core 0 Select",
		  .pme_ucode = 0x00,
		},
		{ .pme_uname = "CORE_1_SELECT",
		  .pme_udesc = "Core 1 Select",
		  .pme_ucode = 0x10,
		},
		{ .pme_uname = "CORE_2_SELECT",
		  .pme_udesc = "Core 2 Select",
		  .pme_ucode = 0x20,
		},
		{ .pme_uname = "CORE_3_SELECT",
		  .pme_udesc = "Core 3 Select",
		  .pme_ucode = 0x30,
		},
		{ .pme_uname = "CORE_4_SELECT",
		  .pme_udesc = "Core 4 Select",
		  .pme_ucode = 0x40,
		},
		{ .pme_uname = "CORE_5_SELECT",
		  .pme_udesc = "Core 5 Select",
		  .pme_ucode = 0x50,
		},
		{ .pme_uname = "ANY_CORE",
		  .pme_udesc = "Any core",
		  .pme_ucode = 0xF0,
		},
#endif
		{ .pme_uname = "ALL_CORES",
		  .pme_udesc = "All cores",
		  .pme_ucode = 0xF0,
		},
	 },
	},
/* 123 */{.pme_name = "IBSOP_EVENT",
	.pme_code  = 0xFF,
	.pme_desc  = "Enable IBS OP mode (pseudo event)",
	.pme_flags = 0,
	.pme_numasks = 2,
	.pme_umasks  = {
		{ .pme_uname = "CYCLES",
		  .pme_udesc = "sample cycles",
		  .pme_ucode = 0x01,
		},
		{ .pme_uname = "UOPS",
		  .pme_udesc = "sample dispatched uops (Rev C and later)",
		  .pme_ucode = 0x02,
		},
	 },
	},
/* 124 */{.pme_name = "IBSFETCH_EVENT",
	.pme_code  = 0xFF,
	.pme_desc  = "Enable IBS Fetch mode (pseudo event)",
	.pme_flags = 0,
	.pme_numasks = 2,
	.pme_umasks  = {
		{ .pme_uname = "RANDOM",
		  .pme_udesc = "randomize period",
		  .pme_ucode = 0x01,
		},
		{ .pme_uname = "NO_RANDOM",
		  .pme_udesc = "do not randomize period",
		  .pme_ucode = 0x00,
		},
	 },
	},
/* 125 */{.pme_name = "MAB_REQUESTS",
	.pme_code  = 0x68,
	.pme_desc  = "Average L1 refill latency for Icache and Dcache misses (request count for cache refills)",
	.pme_numasks = 10,
	.pme_umasks  = {
		{ .pme_uname = "BUFFER_0",
		  .pme_udesc = "Buffer 0",
		  .pme_ucode = 0x00,
		},
		{ .pme_uname = "BUFFER_1",
		  .pme_udesc = "Buffer 1",
		  .pme_ucode = 0x01,
		},
		{ .pme_uname = "BUFFER_2",
		  .pme_udesc = "Buffer 2",
		  .pme_ucode = 0x02,
		},
		{ .pme_uname = "BUFFER_3",
		  .pme_udesc = "Buffer 3",
		  .pme_ucode = 0x03,
		},
		{ .pme_uname = "BUFFER_4",
		  .pme_udesc = "Buffer 4",
		  .pme_ucode = 0x04,
		},
		{ .pme_uname = "BUFFER_5",
		  .pme_udesc = "Buffer 5",
		  .pme_ucode = 0x05,
		},
		{ .pme_uname = "BUFFER_6",
		  .pme_udesc = "Buffer 6",
		  .pme_ucode = 0x06,
		},
		{ .pme_uname = "BUFFER_7",
		  .pme_udesc = "Buffer 7",
		  .pme_ucode = 0x07,
		},
		{ .pme_uname = "BUFFER_8",
		  .pme_udesc = "Buffer 8",
		  .pme_ucode = 0x08,
		},
		{ .pme_uname = "BUFFER_9",
		  .pme_udesc = "Buffer 9",
		  .pme_ucode = 0x09,
		},
	 },
	},
/* 126 */{.pme_name = "MAB_WAIT_CYCLES",
	.pme_code  = 0x69,
	.pme_desc  = "Average L1 refill latency for Icache and Dcache misses (cycles that requests spent waiting for the refills)",
	.pme_numasks = 10,
	.pme_umasks  = {
		{ .pme_uname = "BUFFER_0",
		  .pme_udesc = "Buffer 0",
		  .pme_ucode = 0x00,
		},
		{ .pme_uname = "BUFFER_1",
		  .pme_udesc = "Buffer 1",
		  .pme_ucode = 0x01,
		},
		{ .pme_uname = "BUFFER_2",
		  .pme_udesc = "Buffer 2",
		  .pme_ucode = 0x02,
		},
		{ .pme_uname = "BUFFER_3",
		  .pme_udesc = "Buffer 3",
		  .pme_ucode = 0x03,
		},
		{ .pme_uname = "BUFFER_4",
		  .pme_udesc = "Buffer 4",
		  .pme_ucode = 0x04,
		},
		{ .pme_uname = "BUFFER_5",
		  .pme_udesc = "Buffer 5",
		  .pme_ucode = 0x05,
		},
		{ .pme_uname = "BUFFER_6",
		  .pme_udesc = "Buffer 6",
		  .pme_ucode = 0x06,
		},
		{ .pme_uname = "BUFFER_7",
		  .pme_udesc = "Buffer 7",
		  .pme_ucode = 0x07,
		},
		{ .pme_uname = "BUFFER_8",
		  .pme_udesc = "Buffer 8",
		  .pme_ucode = 0x08,
		},
		{ .pme_uname = "BUFFER_9",
		  .pme_udesc = "Buffer 9",
		  .pme_ucode = 0x09,
		},
	 },
	},
/* 127 */{.pme_name = "NON_CANCELLED_L3_READ_REQUESTS",
	.pme_code  = 0x4ED,
	.pme_desc  = "Non-cancelled L3 Read Requests",
	.pme_numasks = 5,
	.pme_umasks  = {
		{ .pme_uname = "READ_BLOCK_EXCLUSIVE",
		  .pme_udesc = "Read Block Exclusive (Data cache read)",
		  .pme_ucode = 0x01,
		},
		{ .pme_uname = "READ_BLOCK_SHARED",
		  .pme_udesc = "Read Block Shared (Instruction cache read)",
		  .pme_ucode = 0x02,
		},
		{ .pme_uname = "READ_BLOCK_MODIFY",
		  .pme_udesc = "Read Block Modify",
		  .pme_ucode = 0x04,
		},
		{ .pme_uname = "ANY_READ",
		  .pme_udesc = "any read modes (exclusive, shared, modify)",
		  .pme_ucode = 0x07,
		},
#if 0
/*
 *    http://support.amd.com/us/Processor_TechDocs/41322.pdf
 *
 *    Issue number 437 on page 131.
 *
 */
		{ .pme_uname = "CORE_0_SELECT",
		  .pme_udesc = "Core 0 Select",
		  .pme_ucode = 0x00,
		},
		{ .pme_uname = "CORE_1_SELECT",
		  .pme_udesc = "Core 1 Select",
		  .pme_ucode = 0x10,
		},
		{ .pme_uname = "CORE_2_SELECT",
		  .pme_udesc = "Core 2 Select",
		  .pme_ucode = 0x20,
		},
		{ .pme_uname = "CORE_3_SELECT",
		  .pme_udesc = "Core 3 Select",
		  .pme_ucode = 0x30,
		},
		{ .pme_uname = "CORE_4_SELECT",
		  .pme_udesc = "Core 4 Select",
		  .pme_ucode = 0x40,
		},
		{ .pme_uname = "CORE_5_SELECT",
		  .pme_udesc = "Core 5 Select",
		  .pme_ucode = 0x50,
		},
#endif
		{ .pme_uname = "ALL_CORES",
		  .pme_udesc = "All cores",
		  .pme_ucode = 0xF0,
		},
	 },
	},
};

#define PME_AMD64_FAM10H_EVENT_COUNT		(sizeof(amd64_fam10h_pe)/sizeof(pme_amd64_entry_t))
#define PME_AMD64_FAM10H_CPU_CLK_UNHALTED	36
#define PME_AMD64_FAM10H_RETIRED_INSTRUCTIONS	54
#define PME_AMD64_IBSOP				123
#define PME_AMD64_IBSFETCH			124
