# pylint: disable=line-too-long,useless-suppression
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from azure.identity import DefaultAzureCredential

from azure.mgmt.containerregistry import ContainerRegistryManagementClient

"""
# PREREQUISITES
    pip install azure-identity
    pip install azure-mgmt-containerregistry
# USAGE
    python registries_schedule_run_with_custom_credentials.py

    Before run the sample, please set the values of the client ID, tenant ID and client secret
    of the AAD application as environment variables: AZURE_CLIENT_ID, AZURE_TENANT_ID,
    AZURE_CLIENT_SECRET. For more info about how to get the value, please see:
    https://docs.microsoft.com/azure/active-directory/develop/howto-create-service-principal-portal
"""


def main():
    client = ContainerRegistryManagementClient(
        credential=DefaultAzureCredential(),
        subscription_id="4385cf00-2d3a-425a-832f-f4285b1c9dce",
    )

    response = client.registries.schedule_run(
        resource_group_name="myResourceGroup",
        registry_name="myRegistry",
        run_request={
            "agentConfiguration": {"cpu": 2},
            "arguments": [
                {"isSecret": False, "name": "mytestargument", "value": "mytestvalue"},
                {"isSecret": True, "name": "mysecrettestargument", "value": "mysecrettestvalue"},
            ],
            "credentials": {
                "customRegistries": {
                    "myregistry.azurecr.io": {
                        "password": {"type": "Opaque", "value": "***"},
                        "userName": {"type": "Opaque", "value": "reg1"},
                    },
                    "myregistry2.azurecr.io": {
                        "password": {"type": "Opaque", "value": "***"},
                        "userName": {"type": "Opaque", "value": "reg2"},
                    },
                },
                "sourceRegistry": {"loginMode": "Default"},
            },
            "dockerFilePath": "DockerFile",
            "imageNames": ["azurerest:testtag"],
            "isArchiveEnabled": True,
            "isPushEnabled": True,
            "noCache": True,
            "platform": {"architecture": "amd64", "os": "Linux"},
            "sourceLocation": "https://myaccount.blob.core.windows.net/sascontainer/source.zip?sv=2015-04-05&st=2015-04-29T22%3A18%3A26Z&se=2015-04-30T02%3A23%3A26Z&sr=b&sp=rw&sip=168.1.5.60-168.1.5.70&spr=https&sig=Z%2FRHIX5Xcg0Mq2rqI3OlWTjEg2tYkboXr1P9ZUXDtkk%3D",
            "target": "stage1",
            "type": "DockerBuildRequest",
        },
    )
    print(response)


# x-ms-original-file: specification/containerregistry/resource-manager/Microsoft.ContainerRegistry/RegistryTasks/preview/2025-03-01-preview/examples/RegistriesScheduleRun_WithCustomCredentials.json
if __name__ == "__main__":
    main()
