/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.renderer.java3d.loaders;

import com.sun.j3d.loaders.IncorrectFormatException;
import com.sun.j3d.loaders.ParsingErrorException;
import com.sun.j3d.loaders.Scene;
import com.sun.j3d.loaders.SceneBase;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.Map;
import javax.media.j3d.Appearance;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Geometry;
import javax.media.j3d.Node;
import javax.media.j3d.SceneGraphObject;
import javax.media.j3d.Shape3D;
import javax.media.j3d.TriangleStripArray;
import org.j3d.geom.GeometryData;
import org.j3d.geom.terrain.ElevationGridGenerator;
import org.j3d.loaders.dem.DEMParser;
import org.j3d.loaders.dem.DEMTypeARecord;
import org.j3d.loaders.dem.DEMTypeBRecord;
import org.j3d.loaders.dem.DEMTypeCRecord;
import org.j3d.renderer.java3d.loaders.BinaryLoader;
import org.j3d.renderer.java3d.loaders.HeightMapLoader;
import org.j3d.renderer.java3d.loaders.ManagedLoader;

public class DEMLoader
extends HeightMapLoader
implements BinaryLoader,
ManagedLoader {
    private DEMParser parser;
    private ElevationGridGenerator generator;
    private Map overrideCapBitsMap;
    private Map requiredCapBitsMap;
    private Map overrideFreqBitsMap;
    private Map requiredFreqBitsMap;
    private final boolean haveFreqBitsAPI;

    public DEMLoader() {
        this(0);
    }

    public DEMLoader(int n) {
        super(n);
        Boolean bl = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    Class<?> clazz = Class.forName("javax.media.j3d.SceneGraphObject");
                    Package package_ = clazz.getPackage();
                    return new Boolean(package_.isCompatibleWith("1.3"));
                }
                catch (ClassNotFoundException classNotFoundException) {
                    return Boolean.FALSE;
                }
            }
        });
        this.haveFreqBitsAPI = bl;
    }

    public void setCapabilityOverrideMap(Map map, Map map2) {
        this.overrideCapBitsMap = map;
        this.overrideFreqBitsMap = map2;
    }

    public void setCapabilityRequiredMap(Map map, Map map2) {
        this.requiredCapBitsMap = map;
        this.requiredFreqBitsMap = map2;
    }

    public Scene load(InputStream inputStream) throws IncorrectFormatException, ParsingErrorException {
        return this.loadInternal(inputStream);
    }

    public Scene load(Reader reader) throws IncorrectFormatException, ParsingErrorException {
        return this.loadInternal(reader);
    }

    public Scene load(String string) throws FileNotFoundException, IncorrectFormatException, ParsingErrorException {
        File file = new File(string);
        BufferedInputStream bufferedInputStream = null;
        if (!file.exists()) {
            throw new FileNotFoundException("File does not exist");
        }
        if (file.isDirectory()) {
            throw new FileNotFoundException("File is a directory");
        }
        FileInputStream fileInputStream = new FileInputStream(file);
        bufferedInputStream = new BufferedInputStream(fileInputStream);
        return this.loadInternal(bufferedInputStream);
    }

    public Scene load(URL uRL) throws FileNotFoundException, IncorrectFormatException, ParsingErrorException {
        BufferedInputStream bufferedInputStream = null;
        try {
            URLConnection uRLConnection = uRL.openConnection();
            InputStream inputStream = uRLConnection.getInputStream();
            bufferedInputStream = inputStream instanceof BufferedInputStream ? (BufferedInputStream)inputStream : new BufferedInputStream(inputStream);
        }
        catch (IOException iOException) {
            throw new FileNotFoundException(iOException.getMessage());
        }
        return this.loadInternal(bufferedInputStream);
    }

    public float[][] getHeights() {
        return this.parser.getHeights();
    }

    public float[] getGridStep() {
        return this.parser.getGridStep();
    }

    public DEMTypeARecord getTypeARecord() {
        return this.parser.getTypeARecord();
    }

    public DEMTypeBRecord[] getTypeBRecords() {
        return this.parser.getTypeBRecords();
    }

    public DEMTypeCRecord getTypeCRecord() {
        return this.parser.getTypeCRecord();
    }

    private Scene loadInternal(InputStream inputStream) throws IncorrectFormatException, ParsingErrorException {
        if (this.parser == null) {
            this.parser = new DEMParser(inputStream);
        } else {
            this.parser.reset(inputStream);
        }
        return this.load();
    }

    private Scene loadInternal(Reader reader) throws IncorrectFormatException, ParsingErrorException {
        if (this.parser == null) {
            this.parser = new DEMParser(reader);
        } else {
            this.parser.reset(reader);
        }
        return this.load();
    }

    private Scene load() throws IncorrectFormatException, ParsingErrorException {
        float[][] fArray = null;
        try {
            fArray = this.parser.parse(true);
        }
        catch (IOException iOException) {
            throw new ParsingErrorException("Error parsing stream: " + iOException);
        }
        DEMTypeARecord dEMTypeARecord = this.parser.getTypeARecord();
        float f = (float)fArray[0].length * dEMTypeARecord.spatialResolution[0];
        float f2 = (float)fArray.length * dEMTypeARecord.spatialResolution[1];
        if (this.generator == null) {
            this.generator = new ElevationGridGenerator(f, f2, fArray[0].length, fArray.length, fArray, 0.0f);
        } else {
            this.generator.setDimensions(f, f2, fArray[0].length, fArray.length);
            this.generator.setTerrainDetail(fArray, 0.0f);
        }
        GeometryData geometryData = new GeometryData();
        geometryData.geometryType = 3;
        geometryData.geometryComponents = 6;
        this.generator.generate(geometryData);
        SceneBase sceneBase = new SceneBase();
        BranchGroup branchGroup = new BranchGroup();
        this.setCapBits((SceneGraphObject)branchGroup);
        this.setFreqBits((SceneGraphObject)branchGroup);
        int n = 35;
        TriangleStripArray triangleStripArray = new TriangleStripArray(geometryData.vertexCount, n, geometryData.stripCounts);
        triangleStripArray.setCoordinates(0, geometryData.coordinates);
        triangleStripArray.setNormals(0, geometryData.normals);
        triangleStripArray.setTextureCoordinates(0, 0, geometryData.textureCoordinates);
        Appearance appearance = new Appearance();
        this.setCapBits((SceneGraphObject)appearance);
        this.setFreqBits((SceneGraphObject)appearance);
        Shape3D shape3D = new Shape3D((Geometry)triangleStripArray, appearance);
        this.setCapBits((SceneGraphObject)shape3D);
        this.setFreqBits((SceneGraphObject)shape3D);
        branchGroup.addChild((Node)shape3D);
        sceneBase.setSceneGroup(branchGroup);
        return sceneBase;
    }

    private void setCapBits(SceneGraphObject sceneGraphObject) {
        Class<?> clazz = sceneGraphObject.getClass();
        Map map = Collections.EMPTY_MAP;
        if (this.overrideCapBitsMap != null) {
            map = this.overrideCapBitsMap;
        } else if (this.requiredCapBitsMap != null) {
            map = this.requiredCapBitsMap;
        }
        int[] nArray = (int[])map.get(clazz);
        int n = nArray == null ? 0 : nArray.length;
        for (int i = 0; i < n; ++i) {
            sceneGraphObject.setCapability(nArray[i]);
        }
    }

    private void setFreqBits(SceneGraphObject sceneGraphObject) {
        if (!this.haveFreqBitsAPI) {
            return;
        }
        Class<?> clazz = sceneGraphObject.getClass();
        Map map = Collections.EMPTY_MAP;
        if (this.overrideFreqBitsMap != null) {
            map = this.overrideFreqBitsMap;
        } else if (this.requiredFreqBitsMap != null) {
            map = this.requiredFreqBitsMap;
        }
        int[] nArray = (int[])map.get(clazz);
        int n = nArray == null ? 0 : nArray.length;
        for (int i = 0; i < n; ++i) {
            sceneGraphObject.setCapabilityIsFrequent(nArray[i]);
        }
    }
}

