/*
  Copyright (C) 2000-2007

  Code contributed by Greg Collecutt, Joseph Hope and the xmds-devel team

  This file is part of xmds.

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

/*
  $Id: xmds_integrate_siip.h 1507 2007-08-15 09:47:34Z paultcochrane $
*/

/*! @file xmds_integrate_siip.h
  @brief 

  More detailed explanation...
*/

#ifndef XMDS_INTEGRATE_SIIP_H
#define XMDS_INTEGRATE_SIIP_H

#include <xmds_integrate_ip.h>
#include <xmds_integrate_si.h>

// *****************************************************************************
// *****************************************************************************
//                              xmdsIntegrateSIIP
// *****************************************************************************
// *****************************************************************************

//! Class to integrate equations using the semi-implicit method in the interaction picture
class xmdsIntegrateSIIP :       public xmdsIntegrateIP,
                                public xmdsIntegrateSI{

  public :

    //! Constructor of xmdsIntegrateSIIP object
    xmdsIntegrateSIIP(
          const xmdsSimulation *const yourSimulation,
          const bool& yourVerboseMode);

  //! Destructor
  ~xmdsIntegrateSIIP();

  //! Processes an element
  void processElement(
                      const Element *const yourElement);

  private :

    //! Write the integrate SIIP prototypes to file
    void writePrototypes(
       FILE *const outfile) const;

  //! Write the integrate SIIP x-space prototypes to file
  void writexSpacePrototype(
                            FILE *const outfile) const;

  //! Write the integrate SIIP routines to file
  void writeRoutines(
                     FILE *const outfile) const;

  //! Write the main SIIP integrate routine to file
  void writeMainIntegrateRoutine(
                                 FILE *const outfile) const;

  //! Write the integrate SIIP x-space routine to file
  void writexSpaceRoutine(
                          FILE *const outfile) const;

  //! Write the integrate SIIP single step code to file
  void writeSingleStepCode(
                           FILE *const outfile,
                           const stepCaseEnum& stepCase) const;
};


#endif // XMDS_INTEGRATE_SIIP_H
