/*
 * Decompiled with CFR 0.152.
 */
package com.projectlibre1.pm.graphic.network.rendering;

import com.projectlibre1.pm.graphic.graph.GraphParams;
import com.projectlibre1.pm.graphic.model.cache.GraphicNode;
import com.projectlibre1.pm.graphic.network.rendering.FormComponent;
import com.projectlibre1.pm.graphic.network.rendering.FormatSelector;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.List;
import javax.swing.JComponent;

public class NetworkCellEditor {
    protected GraphParams params;
    protected JComponent container;
    protected FormatSelector formatSelector;
    protected FormComponent form;
    protected GraphicNode node;

    public NetworkCellEditor(GraphParams graphParams, JComponent jComponent) {
        this.params = graphParams;
        this.container = jComponent;
        this.formatSelector = new FormatSelector(graphParams);
    }

    public void initEditorComponent(GraphicNode graphicNode, int n, Rectangle rectangle) {
        this.cancel();
        if (graphicNode == null) {
            return;
        }
        this.node = graphicNode;
        this.form = this.formatSelector.getForm(graphicNode, n, true);
        this.form.setFields(graphicNode.getNode(), this.params.getCache().getModel());
        this.container.add(this.form);
        this.form.setBounds(rectangle);
        this.form.validate();
    }

    public void resetForms() {
        this.formatSelector.resetForms();
    }

    public void paintEditor(GraphicNode graphicNode) {
        if (graphicNode == null || this.node != graphicNode) {
            return;
        }
        this.paintComponentApart(this.form, this.form.getBounds());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void paintComponentApart(Component component, Rectangle rectangle) {
        boolean bl = false;
        if (component instanceof JComponent && ((JComponent)component).isDoubleBuffered()) {
            bl = true;
            ((JComponent)component).setDoubleBuffered(false);
        }
        Graphics graphics = this.container.getGraphics().create(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        try {
            component.paint(graphics);
        }
        finally {
            graphics.dispose();
        }
        if (bl && component instanceof JComponent) {
            ((JComponent)component).setDoubleBuffered(true);
        }
    }

    public boolean isEditing(GraphicNode graphicNode) {
        return graphicNode != null && this.node == graphicNode;
    }

    public void cancel() {
        if (this.node != null) {
            Container container = this.form.getParent();
            if (container != null) {
                container.remove(this.form);
            }
            Rectangle rectangle = this.form.getBounds();
            this.form = null;
            this.node = null;
            this.container.repaint(rectangle);
        }
    }

    public List getCellEditorChange() {
        return this.form == null ? null : this.form.getChange();
    }

    public GraphicNode getNode() {
        return this.node;
    }
}

