/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.workflow.filter;

import de.rub.nds.tlsattacker.core.config.Config;
import de.rub.nds.tlsattacker.core.connection.AliasedConnection;
import de.rub.nds.tlsattacker.core.connection.InboundConnection;
import de.rub.nds.tlsattacker.core.connection.OutboundConnection;
import de.rub.nds.tlsattacker.core.exceptions.ConfigurationException;
import de.rub.nds.tlsattacker.core.workflow.WorkflowTrace;
import de.rub.nds.tlsattacker.core.workflow.WorkflowTraceNormalizer;
import de.rub.nds.tlsattacker.core.workflow.action.GeneralAction;
import de.rub.nds.tlsattacker.core.workflow.action.TlsAction;
import de.rub.nds.tlsattacker.core.workflow.filter.Filter;
import de.rub.nds.tlsattacker.core.workflow.filter.FilterType;
import de.rub.nds.tlsattacker.transport.ConnectionEndType;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DefaultFilter
extends Filter {
    protected static final Logger LOGGER = LogManager.getLogger(DefaultFilter.class);

    public DefaultFilter(Config config) {
        super(config);
    }

    @Override
    public void applyFilter(WorkflowTrace trace) {
        WorkflowTraceNormalizer normalizer = new WorkflowTraceNormalizer();
        normalizer.assertNormalizedWorkflowTrace(trace);
        List<AliasedConnection> traceConnections = trace.getConnections();
        ArrayList<AliasedConnection> strippedTraceConnections = new ArrayList<AliasedConnection>();
        InboundConnection defaultInCon = this.config.getDefaultServerConnection().getCopy();
        OutboundConnection defaultOutCon = this.config.getDefaultClientConnection().getCopy();
        AliasedConnection lastProcessedCon = null;
        block4: for (AliasedConnection traceCon : traceConnections) {
            ConnectionEndType localConEndType = traceCon.getLocalConnectionEndType();
            if (null == localConEndType) {
                throw new ConfigurationException("WorkflowTrace defines a connection with anempty localConnectionEndType. Don't know how to handle this!");
            }
            lastProcessedCon = traceCon.getCopy();
            switch (traceCon.getLocalConnectionEndType()) {
                case CLIENT: {
                    traceCon.filter(defaultOutCon);
                    continue block4;
                }
                case SERVER: {
                    traceCon.filter(defaultInCon);
                    continue block4;
                }
            }
            throw new ConfigurationException("WorkflowTrace defines a connection with anunknown localConnectionEndType (" + localConEndType + "). Don't know how to handle this!");
        }
        GeneralAction defaultAction = new GeneralAction(lastProcessedCon.getAlias());
        if (trace.getTlsActions() != null) {
            for (TlsAction action : trace.getTlsActions()) {
                action.filter(defaultAction);
            }
        }
        trace.setConnections(strippedTraceConnections);
    }

    @Override
    public void postFilter(WorkflowTrace trace, WorkflowTrace reference) {
        trace.setConnections(reference.getConnections());
    }

    @Override
    public FilterType getFilterType() {
        return FilterType.DEFAULT;
    }
}

