/*
 * Decompiled with CFR 0.152.
 */
package jde.debugger.command;

import com.sun.jdi.request.ClassPrepareRequest;
import com.sun.jdi.request.ClassUnloadRequest;
import com.sun.jdi.request.EventRequestManager;
import java.util.Iterator;
import java.util.List;
import jde.debugger.Etc;
import jde.debugger.JDEException;
import jde.debugger.command.DebugProcessCommand;

public class TraceClasses
extends DebugProcessCommand {
    public void doCommand() throws JDEException {
        if (this.m_args.size() < 1) {
            throw new JDEException("Insufficient arguments");
        }
        String type = this.m_args.remove(0).toString().toLowerCase();
        if (!type.equals("preparation") && !type.equals("unloading")) {
            throw new JDEException("Invalid type");
        }
        Long requestID = null;
        List classFilters = Etc.getClassFiltersFromArgs(this.m_args);
        List classExFilters = Etc.getClassExFiltersFromArgs(this.m_args);
        EventRequestManager em = this.m_debugger.getVM().eventRequestManager();
        if (type.equals("preparation")) {
            Iterator it;
            ClassPrepareRequest cpr = em.createClassPrepareRequest();
            cpr.setSuspendPolicy(Etc.getSuspendPolicyFromArgs(this.m_args));
            if (classFilters != null) {
                it = classFilters.iterator();
                while (it.hasNext()) {
                    cpr.addClassFilter(it.next().toString());
                }
            }
            if (classExFilters != null) {
                it = classExFilters.iterator();
                while (it.hasNext()) {
                    cpr.addClassExclusionFilter(it.next().toString());
                }
            }
            requestID = this.m_debugger.addIdentifiableRequest(cpr);
        } else if (type.equals("unloading")) {
            Iterator it;
            ClassUnloadRequest cur = em.createClassUnloadRequest();
            cur.setSuspendPolicy(Etc.getSuspendPolicyFromArgs(this.m_args));
            if (classFilters != null) {
                it = classFilters.iterator();
                while (it.hasNext()) {
                    cur.addClassFilter(it.next().toString());
                }
            }
            if (classExFilters != null) {
                it = classExFilters.iterator();
                while (it.hasNext()) {
                    cur.addClassExclusionFilter(it.next().toString());
                }
            }
            requestID = this.m_debugger.addIdentifiableRequest(cur);
        }
        this.m_debugger.signalCommandResult(this.m_cmdID, requestID.toString(), true);
    }

    public Object clone() {
        return new TraceClasses();
    }
}

