/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.logging;

import java.io.IOException;
import java.io.PipedOutputStream;
import org.apache.log4j.Appender;
import org.apache.log4j.Layout;
import org.apache.log4j.spi.ErrorHandler;
import org.apache.log4j.spi.Filter;
import org.apache.log4j.spi.LoggingEvent;
import org.pentaho.di.core.Const;

public class Log4jPipedAppender
implements Appender {
    private Layout layout;
    private Filter filter;
    private String name;
    private PipedOutputStream pipedOutputStream = new PipedOutputStream();

    public void addFilter(Filter filter) {
        this.filter = filter;
    }

    public Filter getFilter() {
        return this.filter;
    }

    public void clearFilters() {
        this.filter = null;
    }

    public void close() {
        try {
            this.pipedOutputStream.close();
        }
        catch (IOException e) {
            System.out.println("Unable to close piped output stream: " + e.getMessage());
        }
    }

    public void doAppend(LoggingEvent event) {
        String line = this.layout.format(event) + Const.CR;
        try {
            this.pipedOutputStream.write(line.getBytes());
        }
        catch (IOException e) {
            System.out.println("Unable to write to piped output stream : " + e.getMessage());
        }
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setErrorHandler(ErrorHandler arg0) {
    }

    public ErrorHandler getErrorHandler() {
        return null;
    }

    public void setLayout(Layout layout) {
        this.layout = layout;
    }

    public Layout getLayout() {
        return this.layout;
    }

    public boolean requiresLayout() {
        return true;
    }

    public PipedOutputStream getPipedOutputStream() {
        return this.pipedOutputStream;
    }

    public void setPipedOutputStream(PipedOutputStream pipedOutputStream) {
        this.pipedOutputStream = pipedOutputStream;
    }

    public void setFilter(Filter filter) {
        this.filter = filter;
    }
}

