/*
 * Decompiled with CFR 0.152.
 */
package ua.co.k.strftime.formatters;

import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.Locale;
import ua.co.k.strftime.formatters.HybridFormat;

class PatternFormat
extends HybridFormat {
    protected final String pattern;

    public PatternFormat(String pattern, boolean combination) {
        super(combination);
        this.pattern = pattern;
    }

    @Override
    protected String doFormat(Object obj, int padWidth, boolean strict, Locale locale) {
        String res;
        TemporalAccessor temporalAccessor = (TemporalAccessor)obj;
        try {
            res = DateTimeFormatter.ofPattern(this.pattern, locale).format(temporalAccessor);
        }
        catch (RuntimeException e) {
            if (strict) {
                throw e;
            }
            return "";
        }
        return res;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("PatternFormat{");
        sb.append("pattern='").append(this.pattern).append('\'');
        sb.append('}');
        return sb.toString();
    }
}

