
####### Expanded from @PACKAGE_INIT@ by configure_package_config_file() #######
####### Any changes to this file will be overwritten by the next CMake run ####
####### The input file was Config.cmake.in                            ########

get_filename_component(PACKAGE_PREFIX_DIR "${CMAKE_CURRENT_LIST_DIR}/../../../" ABSOLUTE)

macro(set_and_check _var _file)
  set(${_var} "${_file}")
  if(NOT EXISTS "${_file}")
    message(FATAL_ERROR "File or directory ${_file} referenced by variable ${_var} does not exist !")
  endif()
endmacro()

####################################################################################

include(CMakeFindDependencyMacro)

set(_LibBGCode_supported_components Core;Binarize;Convert)

set(Core_deps "")
set(Binarize_deps "")
set(Convert_deps "")
set(Boost_comps "")

set(_comps ${LibBGCode_FIND_COMPONENTS})
if (_comps)
  if ("Convert" IN_LIST _comps)
    list(PREPEND _comps Binarize)
  endif ()
  list(PREPEND _comps Core)
  list(REMOVE_DUPLICATES _comps)
else() # empty list of components, include all
  set(_comps ${_LibBGCode_supported_components})
endif ()

foreach(_comp ${_comps})
  if (NOT _comp IN_LIST _LibBGCode_supported_components)
    set(LibBGCode_FOUND False)
    set(LibBGCode_NOT_FOUND_MESSAGE "Unsupported component: ${_comp}")
  endif()
  include("${CMAKE_CURRENT_LIST_DIR}/LibBGCode${_comp}Targets.cmake")

  foreach (_pkg_ver ${${_comp}_deps})
    # Use regular expression to extract package name and version
    string(REGEX MATCH "^(.*)_([0-9]+\\.[0-9]+\\.?[0-9]*)$" extracted_parts ${_pkg_ver})

    # Access the extracted groups
    set(package_name ${CMAKE_MATCH_1})
    set(package_version ${CMAKE_MATCH_2})
    set(comps ${${package_name}_comps})

    if (comps)
      find_dependency(${package_name} ${package_version} COMPONENTS ${comps})
    else ()
      find_dependency(${package_name} ${package_version})
    endif ()
  endforeach()

endforeach()



