/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.internal.impl;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.internal.impl.checksum.DefaultChecksumAlgorithmFactorySelector;
import org.eclipse.aether.metadata.Metadata;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.spi.connector.checksum.ChecksumAlgorithmFactory;
import org.eclipse.aether.spi.connector.checksum.ChecksumAlgorithmFactorySelector;
import org.eclipse.aether.spi.connector.layout.RepositoryLayout;
import org.eclipse.aether.spi.connector.layout.RepositoryLayoutFactory;
import org.eclipse.aether.transfer.NoRepositoryLayoutException;
import org.eclipse.aether.util.ConfigUtils;

@Singleton
@Named(value="maven2")
public final class Maven2RepositoryLayoutFactory
implements RepositoryLayoutFactory {
    public static final String CONFIG_PROP_CHECKSUMS_ALGORITHMS = "aether.checksums.algorithms";
    private static final String DEFAULT_CHECKSUMS_ALGORITHMS = "SHA-1,MD5";
    public static final String CONFIG_PROP_OMIT_CHECKSUMS_FOR_EXTENSIONS = "aether.checksums.omitChecksumsForExtensions";
    private static final String DEFAULT_OMIT_CHECKSUMS_FOR_EXTENSIONS = ".asc";
    private float priority;
    private final ChecksumAlgorithmFactorySelector checksumAlgorithmFactorySelector;

    @Override
    public float getPriority() {
        return this.priority;
    }

    @Deprecated
    public Maven2RepositoryLayoutFactory() {
        this(new DefaultChecksumAlgorithmFactorySelector());
    }

    @Inject
    public Maven2RepositoryLayoutFactory(ChecksumAlgorithmFactorySelector checksumAlgorithmFactorySelector) {
        this.checksumAlgorithmFactorySelector = Objects.requireNonNull(checksumAlgorithmFactorySelector);
    }

    public Maven2RepositoryLayoutFactory setPriority(float priority) {
        this.priority = priority;
        return this;
    }

    @Override
    public RepositoryLayout newInstance(RepositorySystemSession session2, RemoteRepository repository) throws NoRepositoryLayoutException {
        Objects.requireNonNull(session2, "session cannot be null");
        Objects.requireNonNull(repository, "repository cannot be null");
        if (!"default".equals(repository.getContentType())) {
            throw new NoRepositoryLayoutException(repository);
        }
        LinkedHashSet checksumsAlgorithmNames = Arrays.stream(ConfigUtils.getString(session2, DEFAULT_CHECKSUMS_ALGORITHMS, CONFIG_PROP_CHECKSUMS_ALGORITHMS).split(",")).filter(s -> s != null && !s.trim().isEmpty()).collect(Collectors.toCollection(LinkedHashSet::new));
        ArrayList<ChecksumAlgorithmFactory> checksumsAlgorithms = new ArrayList<ChecksumAlgorithmFactory>(checksumsAlgorithmNames.size());
        for (String checksumsAlgorithmName : checksumsAlgorithmNames) {
            checksumsAlgorithms.add(this.checksumAlgorithmFactorySelector.select(checksumsAlgorithmName));
        }
        Set omitChecksumsForExtensions = Arrays.stream(ConfigUtils.getString(session2, DEFAULT_OMIT_CHECKSUMS_FOR_EXTENSIONS, CONFIG_PROP_OMIT_CHECKSUMS_FOR_EXTENSIONS).split(",")).filter(s -> s != null && !s.trim().isEmpty()).collect(Collectors.toSet());
        if (omitChecksumsForExtensions.stream().anyMatch(s -> !s.startsWith("."))) {
            throw new IllegalArgumentException(String.format("The configuration %s contains illegal values: %s (all entries must start with '.' (dot))", CONFIG_PROP_OMIT_CHECKSUMS_FOR_EXTENSIONS, omitChecksumsForExtensions));
        }
        return new Maven2RepositoryLayout(new ArrayList<ChecksumAlgorithmFactory>(this.checksumAlgorithmFactorySelector.getChecksumAlgorithmFactories()), checksumsAlgorithms, omitChecksumsForExtensions);
    }

    private static class Maven2RepositoryLayout
    implements RepositoryLayout {
        private final List<ChecksumAlgorithmFactory> allChecksumAlgorithms;
        private final List<ChecksumAlgorithmFactory> configuredChecksumAlgorithms;
        private final Set<String> extensionsWithoutChecksums;

        private Maven2RepositoryLayout(List<ChecksumAlgorithmFactory> allChecksumAlgorithms, List<ChecksumAlgorithmFactory> configuredChecksumAlgorithms, Set<String> extensionsWithoutChecksums) {
            this.allChecksumAlgorithms = Collections.unmodifiableList(allChecksumAlgorithms);
            this.configuredChecksumAlgorithms = Collections.unmodifiableList(configuredChecksumAlgorithms);
            this.extensionsWithoutChecksums = Objects.requireNonNull(extensionsWithoutChecksums);
        }

        private URI toUri(String path2) {
            try {
                return new URI(null, null, path2, null);
            }
            catch (URISyntaxException e2) {
                throw new IllegalStateException(e2);
            }
        }

        @Override
        public List<ChecksumAlgorithmFactory> getChecksumAlgorithmFactories() {
            return this.configuredChecksumAlgorithms;
        }

        @Override
        public boolean hasChecksums(Artifact artifact) {
            String artifactExtension = artifact.getExtension();
            for (String extensionWithoutChecksums : this.extensionsWithoutChecksums) {
                if (!artifactExtension.endsWith(extensionWithoutChecksums)) continue;
                return false;
            }
            return true;
        }

        @Override
        public URI getLocation(Artifact artifact, boolean upload) {
            StringBuilder path2 = new StringBuilder(128);
            path2.append(artifact.getGroupId().replace('.', '/')).append('/');
            path2.append(artifact.getArtifactId()).append('/');
            path2.append(artifact.getBaseVersion()).append('/');
            path2.append(artifact.getArtifactId()).append('-').append(artifact.getVersion());
            if (artifact.getClassifier().length() > 0) {
                path2.append('-').append(artifact.getClassifier());
            }
            if (artifact.getExtension().length() > 0) {
                path2.append('.').append(artifact.getExtension());
            }
            return this.toUri(path2.toString());
        }

        @Override
        public URI getLocation(Metadata metadata, boolean upload) {
            StringBuilder path2 = new StringBuilder(128);
            if (metadata.getGroupId().length() > 0) {
                path2.append(metadata.getGroupId().replace('.', '/')).append('/');
                if (metadata.getArtifactId().length() > 0) {
                    path2.append(metadata.getArtifactId()).append('/');
                    if (metadata.getVersion().length() > 0) {
                        path2.append(metadata.getVersion()).append('/');
                    }
                }
            }
            path2.append(metadata.getType());
            return this.toUri(path2.toString());
        }

        @Override
        public List<RepositoryLayout.ChecksumLocation> getChecksumLocations(Artifact artifact, boolean upload, URI location) {
            if (!this.hasChecksums(artifact) || this.isChecksum(artifact.getExtension())) {
                return Collections.emptyList();
            }
            return this.getChecksumLocations(location);
        }

        @Override
        public List<RepositoryLayout.ChecksumLocation> getChecksumLocations(Metadata metadata, boolean upload, URI location) {
            return this.getChecksumLocations(location);
        }

        private List<RepositoryLayout.ChecksumLocation> getChecksumLocations(URI location) {
            ArrayList<RepositoryLayout.ChecksumLocation> checksumLocations = new ArrayList<RepositoryLayout.ChecksumLocation>(this.configuredChecksumAlgorithms.size());
            for (ChecksumAlgorithmFactory checksumAlgorithmFactory : this.configuredChecksumAlgorithms) {
                checksumLocations.add(RepositoryLayout.ChecksumLocation.forLocation(location, checksumAlgorithmFactory));
            }
            return checksumLocations;
        }

        private boolean isChecksum(String extension) {
            return this.allChecksumAlgorithms.stream().anyMatch(a -> extension.endsWith("." + a.getFileExtension()));
        }
    }
}

