/*
 * Decompiled with CFR 0.152.
 */
package twitter4j;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import twitter4j.internal.http.HttpParameter;
import twitter4j.internal.util.z_T4JInternalStringUtil;

public final class FilterQuery
implements Serializable {
    private static final long serialVersionUID = 430966623248982833L;
    private int count;
    private long[] follow;
    private String[] track;
    private double[][] locations;
    private boolean includeEntities;

    public FilterQuery() {
        this.count = 0;
        this.follow = null;
        this.track = null;
        this.locations = null;
    }

    public FilterQuery(long[] follow) {
        this();
        this.count = 0;
        this.follow = follow;
    }

    public FilterQuery(int count, long[] follow) {
        this();
        this.count = count;
        this.follow = follow;
    }

    public FilterQuery(int count, long[] follow, String[] track) {
        this();
        this.count = count;
        this.follow = follow;
        this.track = track;
    }

    public FilterQuery(int count, long[] follow, String[] track, double[][] locations) {
        this.count = count;
        this.follow = follow;
        this.track = track;
        this.locations = locations;
    }

    public FilterQuery count(int count) {
        this.count = count;
        return this;
    }

    public FilterQuery follow(long[] follow) {
        this.follow = follow;
        return this;
    }

    public FilterQuery track(String[] track) {
        this.track = track;
        return this;
    }

    public FilterQuery locations(double[][] locations) {
        this.locations = locations;
        return this;
    }

    public FilterQuery setIncludeEntities(boolean include) {
        this.includeEntities = include;
        return this;
    }

    HttpParameter[] asHttpParameterArray() {
        ArrayList<HttpParameter> params = new ArrayList<HttpParameter>();
        params.add(new HttpParameter("count", this.count));
        if (this.follow != null && this.follow.length > 0) {
            params.add(new HttpParameter("follow", z_T4JInternalStringUtil.join(this.follow)));
        }
        if (this.track != null && this.track.length > 0) {
            params.add(new HttpParameter("track", z_T4JInternalStringUtil.join(this.track)));
        }
        if (this.locations != null && this.locations.length > 0) {
            params.add(new HttpParameter("locations", this.toLocationsString(this.locations)));
        }
        if (this.includeEntities) {
            params.add(new HttpParameter("include_entities", true));
        }
        HttpParameter[] paramArray = new HttpParameter[params.size()];
        return params.toArray(paramArray);
    }

    private String toLocationsString(double[][] keywords) {
        StringBuffer buf = new StringBuffer(20 * keywords.length * 2);
        double[][] arr$ = keywords;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            double[] keyword = arr$[i$];
            if (0 != buf.length()) {
                buf.append(",");
            }
            buf.append(keyword[0]);
            buf.append(",");
            buf.append(keyword[1]);
        }
        return buf.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FilterQuery that = (FilterQuery)o;
        if (this.count != that.count) {
            return false;
        }
        if (!Arrays.equals(this.follow, that.follow)) {
            return false;
        }
        return Arrays.equals(this.track, that.track);
    }

    public int hashCode() {
        int result = this.count;
        result = 31 * result + (this.follow != null ? Arrays.hashCode(this.follow) : 0);
        result = 31 * result + (this.track != null ? Arrays.hashCode(this.track) : 0);
        return result;
    }

    public String toString() {
        return "FilterQuery{count=" + this.count + ", follow=" + Arrays.toString(this.follow) + ", track=" + (this.track == null ? null : Arrays.asList(this.track)) + ", locations=" + (this.locations == null ? null : Arrays.asList(this.locations)) + ", includeEntities=" + this.includeEntities + '}';
    }
}

