/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.util.Arrays;
import org.mozilla.javascript.Callable;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.IdFunctionObject;
import org.mozilla.javascript.IdScriptableObject;
import org.mozilla.javascript.Kit;
import org.mozilla.javascript.NativeString;
import org.mozilla.javascript.ObjToIntMap;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NativeArray
extends IdScriptableObject {
    static final long serialVersionUID = 7331366857676127338L;
    private static final Object ARRAY_TAG = "Array";
    private static final Integer NEGATIVE_ONE = new Integer(-1);
    private static final int Id_length = 1;
    private static final int MAX_INSTANCE_ID = 1;
    private static final int Id_constructor = 1;
    private static final int Id_toString = 2;
    private static final int Id_toLocaleString = 3;
    private static final int Id_toSource = 4;
    private static final int Id_join = 5;
    private static final int Id_reverse = 6;
    private static final int Id_sort = 7;
    private static final int Id_push = 8;
    private static final int Id_pop = 9;
    private static final int Id_shift = 10;
    private static final int Id_unshift = 11;
    private static final int Id_splice = 12;
    private static final int Id_concat = 13;
    private static final int Id_slice = 14;
    private static final int Id_indexOf = 15;
    private static final int Id_lastIndexOf = 16;
    private static final int Id_every = 17;
    private static final int Id_filter = 18;
    private static final int Id_forEach = 19;
    private static final int Id_map = 20;
    private static final int Id_some = 21;
    private static final int MAX_PROTOTYPE_ID = 21;
    private static final int ConstructorId_join = -5;
    private static final int ConstructorId_reverse = -6;
    private static final int ConstructorId_sort = -7;
    private static final int ConstructorId_push = -8;
    private static final int ConstructorId_pop = -9;
    private static final int ConstructorId_shift = -10;
    private static final int ConstructorId_unshift = -11;
    private static final int ConstructorId_splice = -12;
    private static final int ConstructorId_concat = -13;
    private static final int ConstructorId_slice = -14;
    private static final int ConstructorId_indexOf = -15;
    private static final int ConstructorId_lastIndexOf = -16;
    private static final int ConstructorId_every = -17;
    private static final int ConstructorId_filter = -18;
    private static final int ConstructorId_forEach = -19;
    private static final int ConstructorId_map = -20;
    private static final int ConstructorId_some = -21;
    private long length;
    private Object[] dense;
    private boolean denseOnly;
    private static int maximumInitialCapacity = 10000;
    private static final int DEFAULT_INITIAL_CAPACITY = 10;
    private static final double GROW_FACTOR = 1.5;
    private static final int MAX_PRE_GROW_SIZE = 0x55555554;

    static void init(Scriptable scriptable, boolean bl) {
        NativeArray nativeArray = new NativeArray(0L);
        nativeArray.exportAsJSClass(21, scriptable, bl);
    }

    static int getMaximumInitialCapacity() {
        return maximumInitialCapacity;
    }

    static void setMaximumInitialCapacity(int n) {
        maximumInitialCapacity = n;
    }

    public NativeArray(long l) {
        boolean bl = this.denseOnly = l <= (long)maximumInitialCapacity;
        if (this.denseOnly) {
            int n = (int)l;
            if (n < 10) {
                n = 10;
            }
            this.dense = new Object[n];
            Arrays.fill(this.dense, Scriptable.NOT_FOUND);
        }
        this.length = l;
    }

    public NativeArray(Object[] objectArray) {
        this.denseOnly = true;
        this.dense = objectArray;
        this.length = objectArray.length;
    }

    @Override
    public String getClassName() {
        return "Array";
    }

    @Override
    protected int getMaxInstanceId() {
        return 1;
    }

    @Override
    protected int findInstanceIdInfo(String string) {
        if (string.equals("length")) {
            return NativeArray.instanceIdInfo(6, 1);
        }
        return super.findInstanceIdInfo(string);
    }

    @Override
    protected String getInstanceIdName(int n) {
        if (n == 1) {
            return "length";
        }
        return super.getInstanceIdName(n);
    }

    @Override
    protected Object getInstanceIdValue(int n) {
        if (n == 1) {
            return ScriptRuntime.wrapNumber(this.length);
        }
        return super.getInstanceIdValue(n);
    }

    @Override
    protected void setInstanceIdValue(int n, Object object) {
        if (n == 1) {
            this.setLength(object);
            return;
        }
        super.setInstanceIdValue(n, object);
    }

    @Override
    protected void fillConstructorProperties(IdFunctionObject idFunctionObject) {
        this.addIdFunctionProperty(idFunctionObject, ARRAY_TAG, -5, "join", 2);
        this.addIdFunctionProperty(idFunctionObject, ARRAY_TAG, -6, "reverse", 1);
        this.addIdFunctionProperty(idFunctionObject, ARRAY_TAG, -7, "sort", 2);
        this.addIdFunctionProperty(idFunctionObject, ARRAY_TAG, -8, "push", 2);
        this.addIdFunctionProperty(idFunctionObject, ARRAY_TAG, -9, "pop", 2);
        this.addIdFunctionProperty(idFunctionObject, ARRAY_TAG, -10, "shift", 2);
        this.addIdFunctionProperty(idFunctionObject, ARRAY_TAG, -11, "unshift", 2);
        this.addIdFunctionProperty(idFunctionObject, ARRAY_TAG, -12, "splice", 2);
        this.addIdFunctionProperty(idFunctionObject, ARRAY_TAG, -13, "concat", 2);
        this.addIdFunctionProperty(idFunctionObject, ARRAY_TAG, -14, "slice", 2);
        this.addIdFunctionProperty(idFunctionObject, ARRAY_TAG, -15, "indexOf", 2);
        this.addIdFunctionProperty(idFunctionObject, ARRAY_TAG, -16, "lastIndexOf", 2);
        this.addIdFunctionProperty(idFunctionObject, ARRAY_TAG, -17, "every", 2);
        this.addIdFunctionProperty(idFunctionObject, ARRAY_TAG, -18, "filter", 2);
        this.addIdFunctionProperty(idFunctionObject, ARRAY_TAG, -19, "forEach", 2);
        this.addIdFunctionProperty(idFunctionObject, ARRAY_TAG, -20, "map", 2);
        this.addIdFunctionProperty(idFunctionObject, ARRAY_TAG, -21, "some", 2);
        super.fillConstructorProperties(idFunctionObject);
    }

    @Override
    protected void initPrototypeId(int n) {
        String string;
        int n2;
        switch (n) {
            case 1: {
                n2 = 1;
                string = "constructor";
                break;
            }
            case 2: {
                n2 = 0;
                string = "toString";
                break;
            }
            case 3: {
                n2 = 1;
                string = "toLocaleString";
                break;
            }
            case 4: {
                n2 = 0;
                string = "toSource";
                break;
            }
            case 5: {
                n2 = 1;
                string = "join";
                break;
            }
            case 6: {
                n2 = 0;
                string = "reverse";
                break;
            }
            case 7: {
                n2 = 1;
                string = "sort";
                break;
            }
            case 8: {
                n2 = 1;
                string = "push";
                break;
            }
            case 9: {
                n2 = 1;
                string = "pop";
                break;
            }
            case 10: {
                n2 = 1;
                string = "shift";
                break;
            }
            case 11: {
                n2 = 1;
                string = "unshift";
                break;
            }
            case 12: {
                n2 = 1;
                string = "splice";
                break;
            }
            case 13: {
                n2 = 1;
                string = "concat";
                break;
            }
            case 14: {
                n2 = 1;
                string = "slice";
                break;
            }
            case 15: {
                n2 = 1;
                string = "indexOf";
                break;
            }
            case 16: {
                n2 = 1;
                string = "lastIndexOf";
                break;
            }
            case 17: {
                n2 = 1;
                string = "every";
                break;
            }
            case 18: {
                n2 = 1;
                string = "filter";
                break;
            }
            case 19: {
                n2 = 1;
                string = "forEach";
                break;
            }
            case 20: {
                n2 = 1;
                string = "map";
                break;
            }
            case 21: {
                n2 = 1;
                string = "some";
                break;
            }
            default: {
                throw new IllegalArgumentException(String.valueOf(n));
            }
        }
        this.initPrototypeMethod(ARRAY_TAG, n, string, n2);
    }

    @Override
    public Object execIdCall(IdFunctionObject idFunctionObject, Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        if (!idFunctionObject.hasTag(ARRAY_TAG)) {
            return super.execIdCall(idFunctionObject, context, scriptable, scriptable2, objectArray);
        }
        int n = idFunctionObject.methodId();
        block20: while (true) {
            switch (n) {
                case -21: 
                case -20: 
                case -19: 
                case -18: 
                case -17: 
                case -16: 
                case -15: 
                case -14: 
                case -13: 
                case -12: 
                case -11: 
                case -10: 
                case -9: 
                case -8: 
                case -7: 
                case -6: 
                case -5: {
                    scriptable2 = ScriptRuntime.toObject(scriptable, objectArray[0]);
                    Object[] objectArray2 = new Object[objectArray.length - 1];
                    int n2 = 0;
                    while (n2 < objectArray2.length) {
                        objectArray2[n2] = objectArray[n2 + 1];
                        ++n2;
                    }
                    objectArray = objectArray2;
                    n = -n;
                    continue block20;
                }
                case 1: {
                    boolean bl;
                    boolean bl2 = bl = scriptable2 == null;
                    if (!bl) {
                        return idFunctionObject.construct(context, scriptable, objectArray);
                    }
                    return NativeArray.jsConstructor(context, scriptable, objectArray);
                }
                case 2: {
                    return NativeArray.toStringHelper(context, scriptable, scriptable2, context.hasFeature(4), false);
                }
                case 3: {
                    return NativeArray.toStringHelper(context, scriptable, scriptable2, false, true);
                }
                case 4: {
                    return NativeArray.toStringHelper(context, scriptable, scriptable2, true, false);
                }
                case 5: {
                    return NativeArray.js_join(context, scriptable2, objectArray);
                }
                case 6: {
                    return NativeArray.js_reverse(context, scriptable2, objectArray);
                }
                case 7: {
                    return NativeArray.js_sort(context, scriptable, scriptable2, objectArray);
                }
                case 8: {
                    return NativeArray.js_push(context, scriptable2, objectArray);
                }
                case 9: {
                    return NativeArray.js_pop(context, scriptable2, objectArray);
                }
                case 10: {
                    return NativeArray.js_shift(context, scriptable2, objectArray);
                }
                case 11: {
                    return NativeArray.js_unshift(context, scriptable2, objectArray);
                }
                case 12: {
                    return NativeArray.js_splice(context, scriptable, scriptable2, objectArray);
                }
                case 13: {
                    return NativeArray.js_concat(context, scriptable, scriptable2, objectArray);
                }
                case 14: {
                    return this.js_slice(context, scriptable2, objectArray);
                }
                case 15: {
                    return this.indexOfHelper(context, scriptable2, objectArray, false);
                }
                case 16: {
                    return this.indexOfHelper(context, scriptable2, objectArray, true);
                }
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: {
                    return this.iterativeMethod(context, n, scriptable, scriptable2, objectArray);
                }
            }
            break;
        }
        throw new IllegalArgumentException(String.valueOf(n));
    }

    @Override
    public Object get(int n, Scriptable scriptable) {
        if (!this.denseOnly && this.isGetterOrSetter(null, n, false)) {
            return super.get(n, scriptable);
        }
        if (this.dense != null && n >= 0 && n < this.dense.length) {
            return this.dense[n];
        }
        return super.get(n, scriptable);
    }

    @Override
    public boolean has(int n, Scriptable scriptable) {
        if (!this.denseOnly && this.isGetterOrSetter(null, n, false)) {
            return super.has(n, scriptable);
        }
        if (this.dense != null && n >= 0 && n < this.dense.length) {
            return this.dense[n] != NOT_FOUND;
        }
        return super.has(n, scriptable);
    }

    private static long toArrayIndex(String string) {
        long l;
        double d = ScriptRuntime.toNumber(string);
        if (d == d && (double)(l = ScriptRuntime.toUint32(d)) == d && l != 0xFFFFFFFFL && Long.toString(l).equals(string)) {
            return l;
        }
        return -1L;
    }

    @Override
    public void put(String string, Scriptable scriptable, Object object) {
        long l;
        super.put(string, scriptable, object);
        if (scriptable == this && (l = NativeArray.toArrayIndex(string)) >= this.length) {
            this.length = l + 1L;
            this.denseOnly = false;
        }
    }

    private boolean ensureCapacity(int n) {
        if (n > this.dense.length) {
            if (n > 0x55555554) {
                this.denseOnly = false;
                return false;
            }
            n = Math.max(n, (int)((double)this.dense.length * 1.5));
            Object[] objectArray = new Object[n];
            System.arraycopy(this.dense, 0, objectArray, 0, this.dense.length);
            Arrays.fill(objectArray, this.dense.length, objectArray.length, Scriptable.NOT_FOUND);
            this.dense = objectArray;
        }
        return true;
    }

    @Override
    public void put(int n, Scriptable scriptable, Object object) {
        if (!(scriptable != this || this.isSealed() || this.dense == null || n < 0 || !this.denseOnly && this.isGetterOrSetter(null, n, true))) {
            if (n < this.dense.length) {
                this.dense[n] = object;
                if (this.length <= (long)n) {
                    this.length = (long)n + 1L;
                }
                return;
            }
            if (this.denseOnly && (double)n < (double)this.dense.length * 1.5 && this.ensureCapacity(n + 1)) {
                this.dense[n] = object;
                this.length = (long)n + 1L;
                return;
            }
            this.denseOnly = false;
        }
        super.put(n, scriptable, object);
        if (scriptable == this && this.length <= (long)n) {
            this.length = (long)n + 1L;
        }
    }

    @Override
    public void delete(int n) {
        if (!(this.dense == null || n < 0 || n >= this.dense.length || this.isSealed() || !this.denseOnly && this.isGetterOrSetter(null, n, true))) {
            this.dense[n] = NOT_FOUND;
        } else {
            super.delete(n);
        }
    }

    @Override
    public Object[] getIds() {
        Object[] objectArray = super.getIds();
        if (this.dense == null) {
            return objectArray;
        }
        int n = this.dense.length;
        long l = this.length;
        if ((long)n > l) {
            n = (int)l;
        }
        if (n == 0) {
            return objectArray;
        }
        int n2 = objectArray.length;
        Object[] objectArray2 = new Object[n + n2];
        int n3 = 0;
        int n4 = 0;
        while (n4 != n) {
            if (this.dense[n4] != NOT_FOUND) {
                objectArray2[n3] = new Integer(n4);
                ++n3;
            }
            ++n4;
        }
        if (n3 != n) {
            Object[] objectArray3 = new Object[n3 + n2];
            System.arraycopy(objectArray2, 0, objectArray3, 0, n3);
            objectArray2 = objectArray3;
        }
        System.arraycopy(objectArray, 0, objectArray2, n3, n2);
        return objectArray2;
    }

    @Override
    public Object getDefaultValue(Class<?> clazz) {
        Context context;
        if (clazz == ScriptRuntime.NumberClass && (context = Context.getContext()).getLanguageVersion() == 120) {
            return new Long(this.length);
        }
        return super.getDefaultValue(clazz);
    }

    private static Object jsConstructor(Context context, Scriptable scriptable, Object[] objectArray) {
        if (objectArray.length == 0) {
            return new NativeArray(0L);
        }
        if (context.getLanguageVersion() == 120) {
            return new NativeArray(objectArray);
        }
        Object object = objectArray[0];
        if (objectArray.length > 1 || !(object instanceof Number)) {
            return new NativeArray(objectArray);
        }
        long l = ScriptRuntime.toUint32(object);
        if ((double)l != ((Number)object).doubleValue()) {
            throw Context.reportRuntimeError0("msg.arraylength.bad");
        }
        return new NativeArray(l);
    }

    public long getLength() {
        return this.length;
    }

    public long jsGet_length() {
        return this.getLength();
    }

    void setDenseOnly(boolean bl) {
        if (bl && !this.denseOnly) {
            throw new IllegalArgumentException();
        }
        this.denseOnly = bl;
    }

    private void setLength(Object object) {
        double d = ScriptRuntime.toNumber(object);
        long l = ScriptRuntime.toUint32(d);
        if ((double)l != d) {
            throw Context.reportRuntimeError0("msg.arraylength.bad");
        }
        if (this.denseOnly) {
            if (l < this.length) {
                Arrays.fill(this.dense, (int)l, this.dense.length, NOT_FOUND);
                this.length = l;
                return;
            }
            if (l < 0x55555554L && (double)l < (double)this.length * 1.5 && this.ensureCapacity((int)l)) {
                this.length = l;
                return;
            }
            this.denseOnly = false;
        }
        if (l < this.length) {
            if (this.length - l > 4096L) {
                Object[] objectArray = this.getIds();
                int n = 0;
                while (n < objectArray.length) {
                    Object object2 = objectArray[n];
                    if (object2 instanceof String) {
                        String string = (String)object2;
                        long l2 = NativeArray.toArrayIndex(string);
                        if (l2 >= l) {
                            this.delete(string);
                        }
                    } else {
                        int n2 = (Integer)object2;
                        if ((long)n2 >= l) {
                            this.delete(n2);
                        }
                    }
                    ++n;
                }
            } else {
                long l3 = l;
                while (l3 < this.length) {
                    NativeArray.deleteElem(this, l3);
                    ++l3;
                }
            }
        }
        this.length = l;
    }

    static long getLengthProperty(Context context, Scriptable scriptable) {
        if (scriptable instanceof NativeString) {
            return ((NativeString)scriptable).getLength();
        }
        if (scriptable instanceof NativeArray) {
            return ((NativeArray)scriptable).getLength();
        }
        return ScriptRuntime.toUint32(ScriptRuntime.getObjectProp(scriptable, "length", context));
    }

    private static Object setLengthProperty(Context context, Scriptable scriptable, long l) {
        return ScriptRuntime.setObjectProp(scriptable, "length", (Object)ScriptRuntime.wrapNumber(l), context);
    }

    private static void deleteElem(Scriptable scriptable, long l) {
        int n = (int)l;
        if ((long)n == l) {
            scriptable.delete(n);
        } else {
            scriptable.delete(Long.toString(l));
        }
    }

    private static Object getElem(Context context, Scriptable scriptable, long l) {
        if (l > Integer.MAX_VALUE) {
            String string = Long.toString(l);
            return ScriptRuntime.getObjectProp(scriptable, string, context);
        }
        return ScriptRuntime.getObjectIndex(scriptable, (int)l, context);
    }

    private static void setElem(Context context, Scriptable scriptable, long l, Object object) {
        if (l > Integer.MAX_VALUE) {
            String string = Long.toString(l);
            ScriptRuntime.setObjectProp(scriptable, string, object, context);
        } else {
            ScriptRuntime.setObjectIndex(scriptable, (int)l, object, context);
        }
    }

    private static String toStringHelper(Context context, Scriptable scriptable, Scriptable scriptable2, boolean bl, boolean bl2) {
        boolean bl3;
        boolean bl4;
        String string;
        long l = NativeArray.getLengthProperty(context, scriptable2);
        StringBuilder stringBuilder = new StringBuilder(256);
        if (bl) {
            stringBuilder.append('[');
            string = ", ";
        } else {
            string = ",";
        }
        boolean bl5 = false;
        long l2 = 0L;
        if (context.iterating == null) {
            bl4 = true;
            bl3 = false;
            context.iterating = new ObjToIntMap(31);
        } else {
            bl4 = false;
            bl3 = context.iterating.has(scriptable2);
        }
        try {
            if (!bl3) {
                context.iterating.put(scriptable2, 0);
                l2 = 0L;
                while (l2 < l) {
                    Object object;
                    if (l2 > 0L) {
                        stringBuilder.append(string);
                    }
                    if ((object = NativeArray.getElem(context, scriptable2, l2)) == null || object == Undefined.instance) {
                        bl5 = false;
                    } else {
                        Object object2;
                        bl5 = true;
                        if (bl) {
                            stringBuilder.append(ScriptRuntime.uneval(context, scriptable, object));
                        } else if (object instanceof String) {
                            object2 = (String)object;
                            if (bl) {
                                stringBuilder.append('\"');
                                stringBuilder.append(ScriptRuntime.escapeString((String)object2));
                                stringBuilder.append('\"');
                            } else {
                                stringBuilder.append((String)object2);
                            }
                        } else {
                            if (bl2) {
                                object2 = ScriptRuntime.getPropFunctionAndThis(object, "toLocaleString", context);
                                Scriptable scriptable3 = ScriptRuntime.lastStoredScriptable(context);
                                object = object2.call(context, scriptable, scriptable3, ScriptRuntime.emptyArgs);
                            }
                            stringBuilder.append(ScriptRuntime.toString(object));
                        }
                    }
                    ++l2;
                }
            }
        }
        finally {
            if (bl4) {
                context.iterating = null;
            }
        }
        if (bl) {
            if (!bl5 && l2 > 0L) {
                stringBuilder.append(", ]");
            } else {
                stringBuilder.append(']');
            }
        }
        return stringBuilder.toString();
    }

    private static String js_join(Context context, Scriptable scriptable, Object[] objectArray) {
        String string;
        String[] stringArray;
        String string2;
        int n;
        long l = NativeArray.getLengthProperty(context, scriptable);
        if (l != (long)(n = (int)l)) {
            throw Context.reportRuntimeError1("msg.arraylength.too.big", String.valueOf(l));
        }
        String string3 = string2 = objectArray.length < 1 || objectArray[0] == Undefined.instance ? "," : ScriptRuntime.toString(objectArray[0]);
        if (scriptable instanceof NativeArray) {
            stringArray = (String[])scriptable;
            if (stringArray.denseOnly) {
                StringBuilder stringBuilder = new StringBuilder();
                int n2 = 0;
                while (n2 < n) {
                    Object object;
                    if (n2 != 0) {
                        stringBuilder.append(string2);
                    }
                    if (n2 < stringArray.dense.length && (object = stringArray.dense[n2]) != null && object != Undefined.instance && object != Scriptable.NOT_FOUND) {
                        stringBuilder.append(ScriptRuntime.toString(object));
                    }
                    ++n2;
                }
                return stringBuilder.toString();
            }
        }
        if (n == 0) {
            return "";
        }
        stringArray = new String[n];
        int n3 = 0;
        int n4 = 0;
        while (n4 != n) {
            Object object = NativeArray.getElem(context, scriptable, n4);
            if (object != null && object != Undefined.instance) {
                string = ScriptRuntime.toString(object);
                n3 += string.length();
                stringArray[n4] = string;
            }
            ++n4;
        }
        StringBuilder stringBuilder = new StringBuilder(n3 += (n - 1) * string2.length());
        int n5 = 0;
        while (n5 != n) {
            if (n5 != 0) {
                stringBuilder.append(string2);
            }
            if ((string = stringArray[n5]) != null) {
                stringBuilder.append(string);
            }
            ++n5;
        }
        return stringBuilder.toString();
    }

    private static Scriptable js_reverse(Context context, Scriptable scriptable, Object[] objectArray) {
        if (scriptable instanceof NativeArray) {
            NativeArray nativeArray = (NativeArray)scriptable;
            if (nativeArray.denseOnly) {
                int n = 0;
                int n2 = (int)nativeArray.length - 1;
                while (n < n2) {
                    Object object = nativeArray.dense[n];
                    nativeArray.dense[n] = nativeArray.dense[n2];
                    nativeArray.dense[n2] = object;
                    ++n;
                    --n2;
                }
                return scriptable;
            }
        }
        long l = NativeArray.getLengthProperty(context, scriptable);
        long l2 = l / 2L;
        long l3 = 0L;
        while (l3 < l2) {
            long l4 = l - l3 - 1L;
            Object object = NativeArray.getElem(context, scriptable, l3);
            Object object2 = NativeArray.getElem(context, scriptable, l4);
            NativeArray.setElem(context, scriptable, l3, object2);
            NativeArray.setElem(context, scriptable, l4, object);
            ++l3;
        }
        return scriptable;
    }

    private static Scriptable js_sort(Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        Object[] objectArray2;
        Object object;
        long l = NativeArray.getLengthProperty(context, scriptable2);
        if (l <= 1L) {
            return scriptable2;
        }
        if (objectArray.length > 0 && Undefined.instance != objectArray[0]) {
            object = objectArray[0];
            objectArray2 = new Object[2];
        } else {
            object = null;
            objectArray2 = null;
        }
        if (scriptable2 instanceof NativeArray) {
            NativeArray nativeArray = (NativeArray)scriptable2;
            if (nativeArray.denseOnly) {
                int n = (int)l;
                NativeArray.heapsort(context, scriptable, nativeArray.dense, n, object, objectArray2);
                return scriptable2;
            }
        }
        if (l >= Integer.MAX_VALUE) {
            NativeArray.heapsort_extended(context, scriptable, scriptable2, l, object, objectArray2);
        } else {
            int n = (int)l;
            Object[] objectArray3 = new Object[n];
            int n2 = 0;
            while (n2 != n) {
                objectArray3[n2] = NativeArray.getElem(context, scriptable2, n2);
                ++n2;
            }
            NativeArray.heapsort(context, scriptable, objectArray3, n, object, objectArray2);
            n2 = 0;
            while (n2 != n) {
                NativeArray.setElem(context, scriptable2, n2, objectArray3[n2]);
                ++n2;
            }
        }
        return scriptable2;
    }

    private static boolean isBigger(Context context, Scriptable scriptable, Object object, Object object2, Object object3, Object[] objectArray) {
        Scriptable scriptable2;
        if (object3 == null) {
            if (objectArray != null) {
                Kit.codeBug();
            }
        } else if (objectArray == null || objectArray.length != 2) {
            Kit.codeBug();
        }
        Object object4 = Undefined.instance;
        Object object5 = Scriptable.NOT_FOUND;
        if (object2 == object4 || object2 == object5) {
            return false;
        }
        if (object == object4 || object == object5) {
            return true;
        }
        if (object3 == null) {
            String string;
            String string2 = ScriptRuntime.toString(object);
            return string2.compareTo(string = ScriptRuntime.toString(object2)) > 0;
        }
        objectArray[0] = object;
        objectArray[1] = object2;
        Callable callable = ScriptRuntime.getValueFunctionAndThis(object3, context);
        Object object6 = callable.call(context, scriptable, scriptable2 = ScriptRuntime.lastStoredScriptable(context), objectArray);
        double d = ScriptRuntime.toNumber(object6);
        return d > 0.0;
    }

    private static void heapsort(Context context, Scriptable scriptable, Object[] objectArray, int n, Object object, Object[] objectArray2) {
        Object object2;
        if (n <= 1) {
            Kit.codeBug();
        }
        int n2 = n / 2;
        while (n2 != 0) {
            object2 = objectArray[--n2];
            NativeArray.heapify(context, scriptable, object2, objectArray, n2, n, object, objectArray2);
        }
        n2 = n;
        while (n2 != 1) {
            object2 = objectArray[--n2];
            objectArray[n2] = objectArray[0];
            NativeArray.heapify(context, scriptable, object2, objectArray, 0, n2, object, objectArray2);
        }
    }

    private static void heapify(Context context, Scriptable scriptable, Object object, Object[] objectArray, int n, int n2, Object object2, Object[] objectArray2) {
        int n3;
        while ((n3 = n * 2 + 1) < n2) {
            Object object3;
            Object object4 = objectArray[n3];
            if (n3 + 1 < n2 && NativeArray.isBigger(context, scriptable, object3 = objectArray[n3 + 1], object4, object2, objectArray2)) {
                ++n3;
                object4 = object3;
            }
            if (!NativeArray.isBigger(context, scriptable, object4, object, object2, objectArray2)) break;
            objectArray[n] = object4;
            n = n3;
        }
        objectArray[n] = object;
    }

    private static void heapsort_extended(Context context, Scriptable scriptable, Scriptable scriptable2, long l, Object object, Object[] objectArray) {
        Object object2;
        if (l <= 1L) {
            Kit.codeBug();
        }
        long l2 = l / 2L;
        while (l2 != 0L) {
            object2 = NativeArray.getElem(context, scriptable2, --l2);
            NativeArray.heapify_extended(context, scriptable, object2, scriptable2, l2, l, object, objectArray);
        }
        l2 = l;
        while (l2 != 1L) {
            object2 = NativeArray.getElem(context, scriptable2, --l2);
            NativeArray.setElem(context, scriptable2, l2, NativeArray.getElem(context, scriptable2, 0L));
            NativeArray.heapify_extended(context, scriptable, object2, scriptable2, 0L, l2, object, objectArray);
        }
    }

    private static void heapify_extended(Context context, Scriptable scriptable, Object object, Scriptable scriptable2, long l, long l2, Object object2, Object[] objectArray) {
        long l3;
        while ((l3 = l * 2L + 1L) < l2) {
            Object object3;
            Object object4 = NativeArray.getElem(context, scriptable2, l3);
            if (l3 + 1L < l2 && NativeArray.isBigger(context, scriptable, object3 = NativeArray.getElem(context, scriptable2, l3 + 1L), object4, object2, objectArray)) {
                ++l3;
                object4 = object3;
            }
            if (!NativeArray.isBigger(context, scriptable, object4, object, object2, objectArray)) break;
            NativeArray.setElem(context, scriptable2, l, object4);
            l = l3;
        }
        NativeArray.setElem(context, scriptable2, l, object);
    }

    private static Object js_push(Context context, Scriptable scriptable, Object[] objectArray) {
        if (scriptable instanceof NativeArray) {
            NativeArray nativeArray = (NativeArray)scriptable;
            if (nativeArray.denseOnly && nativeArray.ensureCapacity((int)nativeArray.length + objectArray.length)) {
                int n = 0;
                while (n < objectArray.length) {
                    nativeArray.dense[(int)nativeArray.length++] = objectArray[n];
                    ++n;
                }
                return ScriptRuntime.wrapNumber(nativeArray.length);
            }
        }
        long l = NativeArray.getLengthProperty(context, scriptable);
        int n = 0;
        while (n < objectArray.length) {
            NativeArray.setElem(context, scriptable, l + (long)n, objectArray[n]);
            ++n;
        }
        Object object = NativeArray.setLengthProperty(context, scriptable, l += (long)objectArray.length);
        if (context.getLanguageVersion() == 120) {
            return objectArray.length == 0 ? Undefined.instance : objectArray[objectArray.length - 1];
        }
        return object;
    }

    private static Object js_pop(Context context, Scriptable scriptable, Object[] objectArray) {
        long l;
        if (scriptable instanceof NativeArray) {
            NativeArray nativeArray = (NativeArray)scriptable;
            if (nativeArray.denseOnly && nativeArray.length > 0L) {
                --nativeArray.length;
                Object object = nativeArray.dense[(int)nativeArray.length];
                nativeArray.dense[(int)nativeArray.length] = NOT_FOUND;
                return object;
            }
        }
        Object object = (l = NativeArray.getLengthProperty(context, scriptable)) > 0L ? NativeArray.getElem(context, scriptable, --l) : Undefined.instance;
        NativeArray.setLengthProperty(context, scriptable, l);
        return object;
    }

    private static Object js_shift(Context context, Scriptable scriptable, Object[] objectArray) {
        long l;
        Object object;
        if (scriptable instanceof NativeArray) {
            object = (NativeArray)scriptable;
            if (((NativeArray)object).denseOnly && ((NativeArray)object).length > 0L) {
                --((NativeArray)object).length;
                Object object2 = ((NativeArray)object).dense[0];
                System.arraycopy(((NativeArray)object).dense, 1, ((NativeArray)object).dense, 0, (int)((NativeArray)object).length);
                ((NativeArray)object).dense[(int)((NativeArray)object).length] = NOT_FOUND;
                return object2;
            }
        }
        if ((l = NativeArray.getLengthProperty(context, scriptable)) > 0L) {
            long l2 = 0L;
            object = NativeArray.getElem(context, scriptable, l2);
            if (--l > 0L) {
                l2 = 1L;
                while (l2 <= l) {
                    Object object3 = NativeArray.getElem(context, scriptable, l2);
                    NativeArray.setElem(context, scriptable, l2 - 1L, object3);
                    ++l2;
                }
            }
        } else {
            object = Undefined.instance;
        }
        NativeArray.setLengthProperty(context, scriptable, l);
        return object;
    }

    private static Object js_unshift(Context context, Scriptable scriptable, Object[] objectArray) {
        if (scriptable instanceof NativeArray) {
            NativeArray nativeArray = (NativeArray)scriptable;
            if (nativeArray.denseOnly && nativeArray.ensureCapacity((int)nativeArray.length + objectArray.length)) {
                System.arraycopy(nativeArray.dense, 0, nativeArray.dense, objectArray.length, (int)nativeArray.length);
                int n = 0;
                while (n < objectArray.length) {
                    nativeArray.dense[n] = objectArray[n];
                    ++n;
                }
                nativeArray.length += (long)objectArray.length;
                return ScriptRuntime.wrapNumber(nativeArray.length);
            }
        }
        long l = NativeArray.getLengthProperty(context, scriptable);
        int n = objectArray.length;
        if (objectArray.length > 0) {
            if (l > 0L) {
                long l2 = l - 1L;
                while (l2 >= 0L) {
                    Object object = NativeArray.getElem(context, scriptable, l2);
                    NativeArray.setElem(context, scriptable, l2 + (long)n, object);
                    --l2;
                }
            }
            int n2 = 0;
            while (n2 < objectArray.length) {
                NativeArray.setElem(context, scriptable, n2, objectArray[n2]);
                ++n2;
            }
            return NativeArray.setLengthProperty(context, scriptable, l += (long)objectArray.length);
        }
        return ScriptRuntime.wrapNumber(l);
    }

    private static Object js_splice(Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        Object object;
        long l;
        Object object2;
        long l2;
        NativeArray nativeArray = null;
        boolean bl = false;
        if (scriptable2 instanceof NativeArray) {
            nativeArray = (NativeArray)scriptable2;
            bl = nativeArray.denseOnly;
        }
        scriptable = NativeArray.getTopLevelScope(scriptable);
        int n = objectArray.length;
        if (n == 0) {
            return ScriptRuntime.newObject(context, scriptable, "Array", null);
        }
        long l3 = NativeArray.getLengthProperty(context, scriptable2);
        long l4 = NativeArray.toSliceIndex(ScriptRuntime.toInteger(objectArray[0]), l3);
        --n;
        if (objectArray.length == 1) {
            l2 = l3 - l4;
        } else {
            double d = ScriptRuntime.toInteger(objectArray[1]);
            l2 = d < 0.0 ? 0L : (d > (double)(l3 - l4) ? l3 - l4 : (long)d);
            --n;
        }
        long l5 = l4 + l2;
        if (l2 != 0L) {
            if (l2 == 1L && context.getLanguageVersion() == 120) {
                object2 = NativeArray.getElem(context, scriptable2, l4);
            } else if (bl) {
                int n2 = (int)(l5 - l4);
                Object[] objectArray2 = new Object[n2];
                System.arraycopy(nativeArray.dense, (int)l4, objectArray2, 0, n2);
                object2 = context.newArray(scriptable, objectArray2);
            } else {
                Scriptable scriptable3 = ScriptRuntime.newObject(context, scriptable, "Array", null);
                long l6 = l4;
                while (l6 != l5) {
                    Object object3 = NativeArray.getElem(context, scriptable2, l6);
                    NativeArray.setElem(context, scriptable3, l6 - l4, object3);
                    ++l6;
                }
                object2 = scriptable3;
            }
        } else {
            object2 = context.getLanguageVersion() == 120 ? Undefined.instance : ScriptRuntime.newObject(context, scriptable, "Array", null);
        }
        long l7 = (long)n - l2;
        if (bl && l3 + l7 < Integer.MAX_VALUE && nativeArray.ensureCapacity((int)(l3 + l7))) {
            System.arraycopy(nativeArray.dense, (int)l5, nativeArray.dense, (int)(l4 + (long)n), (int)(l3 - l5));
            if (n > 0) {
                System.arraycopy(objectArray, 2, nativeArray.dense, (int)l4, n);
            }
            if (l7 < 0L) {
                Arrays.fill(nativeArray.dense, (int)(l3 + l7), (int)l3, NOT_FOUND);
            }
            nativeArray.length = l3 + l7;
            return object2;
        }
        if (l7 > 0L) {
            l = l3 - 1L;
            while (l >= l5) {
                object = NativeArray.getElem(context, scriptable2, l);
                NativeArray.setElem(context, scriptable2, l + l7, object);
                --l;
            }
        } else if (l7 < 0L) {
            l = l5;
            while (l < l3) {
                object = NativeArray.getElem(context, scriptable2, l);
                NativeArray.setElem(context, scriptable2, l + l7, object);
                ++l;
            }
        }
        int n3 = objectArray.length - n;
        int n4 = 0;
        while (n4 < n) {
            NativeArray.setElem(context, scriptable2, l4 + (long)n4, objectArray[n4 + n3]);
            ++n4;
        }
        NativeArray.setLengthProperty(context, scriptable2, l3 + l7);
        return object2;
    }

    private static Scriptable js_concat(Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        Scriptable scriptable3;
        scriptable = NativeArray.getTopLevelScope(scriptable);
        Function function = ScriptRuntime.getExistingCtor(context, scriptable, "Array");
        Scriptable scriptable4 = function.construct(context, scriptable, ScriptRuntime.emptyArgs);
        if (scriptable2 instanceof NativeArray && scriptable4 instanceof NativeArray) {
            NativeArray nativeArray = (NativeArray)scriptable2;
            NativeArray nativeArray2 = (NativeArray)scriptable4;
            if (nativeArray.denseOnly && nativeArray2.denseOnly) {
                boolean bl = true;
                int n = (int)nativeArray.length;
                int n2 = 0;
                while (n2 < objectArray.length && bl) {
                    if (objectArray[n2] instanceof NativeArray) {
                        scriptable3 = (NativeArray)objectArray[n2];
                        bl = ((NativeArray)scriptable3).denseOnly;
                        n = (int)((long)n + ((NativeArray)scriptable3).length);
                    } else {
                        ++n;
                    }
                    ++n2;
                }
                if (bl && nativeArray2.ensureCapacity(n)) {
                    System.arraycopy(nativeArray.dense, 0, nativeArray2.dense, 0, (int)nativeArray.length);
                    n2 = (int)nativeArray.length;
                    int n3 = 0;
                    while (n3 < objectArray.length && bl) {
                        if (objectArray[n3] instanceof NativeArray) {
                            NativeArray nativeArray3 = (NativeArray)objectArray[n3];
                            System.arraycopy(nativeArray3.dense, 0, nativeArray2.dense, n2, (int)nativeArray3.length);
                            n2 += (int)nativeArray3.length;
                        } else {
                            nativeArray2.dense[n2++] = objectArray[n3];
                        }
                        ++n3;
                    }
                    nativeArray2.length = n;
                    return scriptable4;
                }
            }
        }
        long l = 0L;
        if (ScriptRuntime.instanceOf(scriptable2, function, context)) {
            long l2 = NativeArray.getLengthProperty(context, scriptable2);
            l = 0L;
            while (l < l2) {
                Object object = NativeArray.getElem(context, scriptable2, l);
                NativeArray.setElem(context, scriptable4, l, object);
                ++l;
            }
        } else {
            NativeArray.setElem(context, scriptable4, l++, scriptable2);
        }
        int n = 0;
        while (n < objectArray.length) {
            if (ScriptRuntime.instanceOf(objectArray[n], function, context)) {
                scriptable3 = (Scriptable)objectArray[n];
                long l3 = NativeArray.getLengthProperty(context, scriptable3);
                long l4 = 0L;
                while (l4 < l3) {
                    Object object = NativeArray.getElem(context, scriptable3, l4);
                    NativeArray.setElem(context, scriptable4, l, object);
                    ++l4;
                    ++l;
                }
            } else {
                NativeArray.setElem(context, scriptable4, l++, objectArray[n]);
            }
            ++n;
        }
        return scriptable4;
    }

    private Scriptable js_slice(Context context, Scriptable scriptable, Object[] objectArray) {
        long l;
        long l2;
        Scriptable scriptable2 = NativeArray.getTopLevelScope(this);
        Scriptable scriptable3 = ScriptRuntime.newObject(context, scriptable2, "Array", null);
        long l3 = NativeArray.getLengthProperty(context, scriptable);
        if (objectArray.length == 0) {
            l2 = 0L;
            l = l3;
        } else {
            l2 = NativeArray.toSliceIndex(ScriptRuntime.toInteger(objectArray[0]), l3);
            l = objectArray.length == 1 ? l3 : NativeArray.toSliceIndex(ScriptRuntime.toInteger(objectArray[1]), l3);
        }
        long l4 = l2;
        while (l4 < l) {
            Object object = NativeArray.getElem(context, scriptable, l4);
            NativeArray.setElem(context, scriptable3, l4 - l2, object);
            ++l4;
        }
        return scriptable3;
    }

    private static long toSliceIndex(double d, long l) {
        long l2 = d < 0.0 ? (d + (double)l < 0.0 ? 0L : (long)(d + (double)l)) : (d > (double)l ? l : (long)d);
        return l2;
    }

    private Object indexOfHelper(Context context, Scriptable scriptable, Object[] objectArray, boolean bl) {
        long l;
        Object object = objectArray.length > 0 ? objectArray[0] : Undefined.instance;
        long l2 = NativeArray.getLengthProperty(context, scriptable);
        if (bl) {
            if (objectArray.length < 2) {
                l = l2 - 1L;
            } else {
                l = ScriptRuntime.toInt32(ScriptRuntime.toNumber(objectArray[1]));
                if (l >= l2) {
                    l = l2 - 1L;
                } else if (l < 0L) {
                    l += l2;
                }
            }
        } else if (objectArray.length < 2) {
            l = 0L;
        } else {
            l = ScriptRuntime.toInt32(ScriptRuntime.toNumber(objectArray[1]));
            if (l < 0L && (l += l2) < 0L) {
                l = 0L;
            }
        }
        if (scriptable instanceof NativeArray) {
            NativeArray nativeArray = (NativeArray)scriptable;
            if (nativeArray.denseOnly) {
                if (bl) {
                    int n = (int)l;
                    while (n >= 0) {
                        if (nativeArray.dense[n] != Scriptable.NOT_FOUND && ScriptRuntime.shallowEq(nativeArray.dense[n], object)) {
                            return new Long(n);
                        }
                        --n;
                    }
                } else {
                    int n = (int)l;
                    while ((long)n < l2) {
                        if (nativeArray.dense[n] != Scriptable.NOT_FOUND && ScriptRuntime.shallowEq(nativeArray.dense[n], object)) {
                            return new Long(n);
                        }
                        ++n;
                    }
                }
                return NEGATIVE_ONE;
            }
        }
        if (bl) {
            long l3 = l;
            while (l3 >= 0L) {
                if (ScriptRuntime.shallowEq(NativeArray.getElem(context, scriptable, l3), object)) {
                    return new Long(l3);
                }
                --l3;
            }
        } else {
            long l4 = l;
            while (l4 < l2) {
                if (ScriptRuntime.shallowEq(NativeArray.getElem(context, scriptable, l4), object)) {
                    return new Long(l4);
                }
                ++l4;
            }
        }
        return NEGATIVE_ONE;
    }

    private Object iterativeMethod(Context context, int n, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        Object object;
        Object object2 = object = objectArray.length > 0 ? objectArray[0] : Undefined.instance;
        if (object == null || !(object instanceof Function)) {
            throw ScriptRuntime.notFunctionError(ScriptRuntime.toString(object));
        }
        Function function = (Function)object;
        Scriptable scriptable3 = ScriptableObject.getTopLevelScope(function);
        Scriptable scriptable4 = objectArray.length < 2 || objectArray[1] == null || objectArray[1] == Undefined.instance ? scriptable3 : ScriptRuntime.toObject(context, scriptable, objectArray[1]);
        long l = NativeArray.getLengthProperty(context, scriptable2);
        Scriptable scriptable5 = ScriptRuntime.newObject(context, scriptable, "Array", null);
        long l2 = 0L;
        long l3 = 0L;
        while (l3 < l) {
            Object object3;
            Object[] objectArray2 = new Object[3];
            Object object4 = object3 = l3 > Integer.MAX_VALUE ? ScriptableObject.getProperty(scriptable2, Long.toString(l3)) : ScriptableObject.getProperty(scriptable2, (int)l3);
            if (object3 != Scriptable.NOT_FOUND) {
                objectArray2[0] = object3;
                objectArray2[1] = new Long(l3);
                objectArray2[2] = scriptable2;
                Object object5 = function.call(context, scriptable3, scriptable4, objectArray2);
                switch (n) {
                    case 17: {
                        if (ScriptRuntime.toBoolean(object5)) break;
                        return Boolean.FALSE;
                    }
                    case 18: {
                        if (!ScriptRuntime.toBoolean(object5)) break;
                        NativeArray.setElem(context, scriptable5, l2++, objectArray2[0]);
                        break;
                    }
                    case 19: {
                        break;
                    }
                    case 20: {
                        NativeArray.setElem(context, scriptable5, l3, object5);
                        break;
                    }
                    case 21: {
                        if (!ScriptRuntime.toBoolean(object5)) break;
                        return Boolean.TRUE;
                    }
                }
            }
            ++l3;
        }
        switch (n) {
            case 17: {
                return Boolean.TRUE;
            }
            case 18: 
            case 20: {
                return scriptable5;
            }
            case 21: {
                return Boolean.FALSE;
            }
        }
        return Undefined.instance;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected int findPrototypeId(String string) {
        int n = 0;
        String string2 = null;
        block0 : switch (string.length()) {
            case 3: {
                char c = string.charAt(0);
                if (c == 'm') {
                    if (string.charAt(2) != 'p' || string.charAt(1) != 'a') break;
                    return 20;
                }
                if (c != 'p' || string.charAt(2) != 'p' || string.charAt(1) != 'o') break;
                return 9;
            }
            case 4: {
                switch (string.charAt(2)) {
                    case 'i': {
                        string2 = "join";
                        n = 5;
                        break block0;
                    }
                    case 'm': {
                        string2 = "some";
                        n = 21;
                        break block0;
                    }
                    case 'r': {
                        string2 = "sort";
                        n = 7;
                        break block0;
                    }
                    case 's': {
                        string2 = "push";
                        n = 8;
                        break block0;
                    }
                }
                break;
            }
            case 5: {
                char c = string.charAt(1);
                if (c == 'h') {
                    string2 = "shift";
                    n = 10;
                    break;
                }
                if (c == 'l') {
                    string2 = "slice";
                    n = 14;
                    break;
                }
                if (c != 'v') break;
                string2 = "every";
                n = 17;
                break;
            }
            case 6: {
                char c = string.charAt(0);
                if (c == 'c') {
                    string2 = "concat";
                    n = 13;
                    break;
                }
                if (c == 'f') {
                    string2 = "filter";
                    n = 18;
                    break;
                }
                if (c != 's') break;
                string2 = "splice";
                n = 12;
                break;
            }
            case 7: {
                switch (string.charAt(0)) {
                    case 'f': {
                        string2 = "forEach";
                        n = 19;
                        break block0;
                    }
                    case 'i': {
                        string2 = "indexOf";
                        n = 15;
                        break block0;
                    }
                    case 'r': {
                        string2 = "reverse";
                        n = 6;
                        break block0;
                    }
                    case 'u': {
                        string2 = "unshift";
                        n = 11;
                        break block0;
                    }
                }
                break;
            }
            case 8: {
                char c = string.charAt(3);
                if (c == 'o') {
                    string2 = "toSource";
                    n = 4;
                    break;
                }
                if (c != 't') break;
                string2 = "toString";
                n = 2;
                break;
            }
            case 11: {
                char c = string.charAt(0);
                if (c == 'c') {
                    string2 = "constructor";
                    n = 1;
                    break;
                }
                if (c != 'l') break;
                string2 = "lastIndexOf";
                n = 16;
                break;
            }
            case 14: {
                string2 = "toLocaleString";
                n = 3;
            }
        }
        if (string2 == null) return n;
        if (string2 == string) return n;
        if (string2.equals(string)) return n;
        return 0;
    }
}

