/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.ast.internal;

import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.loader.ast.internal.AbstractNaturalIdLoader;
import org.hibernate.loader.ast.internal.LoaderSqlAstCreationState;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.SingularAttributeMapping;
import org.hibernate.metamodel.mapping.internal.CompoundNaturalIdMapping;
import org.hibernate.sql.ast.spi.SqlExpressionResolver;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.JdbcParameter;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.predicate.NullnessPredicate;
import org.hibernate.sql.ast.tree.predicate.Predicate;
import org.hibernate.sql.exec.spi.JdbcParameterBinding;

public class CompoundNaturalIdLoader<T>
extends AbstractNaturalIdLoader<T> {
    public CompoundNaturalIdLoader(CompoundNaturalIdMapping naturalIdMapping, EntityMappingType entityDescriptor) {
        super(naturalIdMapping, entityDescriptor);
    }

    @Override
    protected void applyNaturalIdRestriction(Object bindValue, TableGroup rootTableGroup, Consumer<Predicate> predicateConsumer, BiConsumer<JdbcParameter, JdbcParameterBinding> jdbcParameterConsumer, LoaderSqlAstCreationState sqlAstCreationState, SharedSessionContractImplementor session) {
        SqlExpressionResolver expressionResolver = sqlAstCreationState.getSqlExpressionResolver();
        if (bindValue == null) {
            for (SingularAttributeMapping naturalIdAttribute : this.naturalIdMapping().getNaturalIdAttributes()) {
                naturalIdAttribute.forEachSelectable((index, selectable) -> {
                    Expression columnReference = this.resolveColumnReference(rootTableGroup, selectable, expressionResolver);
                    predicateConsumer.accept(new NullnessPredicate(columnReference));
                });
            }
        } else {
            this.naturalIdMapping().breakDownJdbcValues(bindValue, (valueIndex, jdbcValue, jdbcValueMapping) -> this.applyRestriction(rootTableGroup, predicateConsumer, jdbcParameterConsumer, jdbcValue, jdbcValueMapping, expressionResolver), session);
        }
    }
}

