/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.property.access.spi;

import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.property.access.internal.PropertyAccessStrategyBasicImpl;
import org.hibernate.property.access.internal.PropertyAccessStrategyEmbeddedImpl;
import org.hibernate.property.access.internal.PropertyAccessStrategyFieldImpl;
import org.hibernate.property.access.internal.PropertyAccessStrategyMapImpl;
import org.hibernate.property.access.internal.PropertyAccessStrategyMixedImpl;
import org.hibernate.property.access.internal.PropertyAccessStrategyNoopImpl;
import org.hibernate.property.access.spi.PropertyAccessStrategy;

public enum BuiltInPropertyAccessStrategies {
    BASIC,
    FIELD,
    MIXED,
    MAP,
    EMBEDDED,
    NOOP;


    public String getExternalName() {
        return switch (this.ordinal()) {
            default -> throw new IncompatibleClassChangeError();
            case 0 -> "property";
            case 1 -> "field";
            case 2 -> "mixed";
            case 3 -> "map";
            case 4 -> "embedded";
            case 5 -> "noop";
        };
    }

    public PropertyAccessStrategy getStrategy() {
        return switch (this.ordinal()) {
            default -> throw new IncompatibleClassChangeError();
            case 0 -> PropertyAccessStrategyBasicImpl.INSTANCE;
            case 1 -> PropertyAccessStrategyFieldImpl.INSTANCE;
            case 2 -> PropertyAccessStrategyMixedImpl.INSTANCE;
            case 3 -> PropertyAccessStrategyMapImpl.INSTANCE;
            case 4 -> PropertyAccessStrategyEmbeddedImpl.INSTANCE;
            case 5 -> PropertyAccessStrategyNoopImpl.INSTANCE;
        };
    }

    public static @Nullable BuiltInPropertyAccessStrategies interpret(String name) {
        for (BuiltInPropertyAccessStrategies strategy : BuiltInPropertyAccessStrategies.values()) {
            if (!strategy.getExternalName().equals(name)) continue;
            return strategy;
        }
        return null;
    }
}

