/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gizmo;

import io.quarkus.gizmo.AnnotationCreatorImpl;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public interface AnnotationCreator {
    public static AnnotationCreator of(String annotationType) {
        return AnnotationCreator.of(annotationType, RetentionPolicy.RUNTIME);
    }

    public static AnnotationCreator of(Class<?> annotationType) {
        Retention retention = annotationType.getAnnotation(Retention.class);
        return AnnotationCreator.of(annotationType.getName(), retention == null ? RetentionPolicy.SOURCE : retention.value());
    }

    public static AnnotationCreator of(String annotationType, RetentionPolicy retentionPolicy) {
        return new AnnotationCreatorImpl(annotationType, retentionPolicy);
    }

    default public AnnotationCreator add(String name, Object value) {
        this.addValue(name, value);
        return this;
    }

    public void addValue(String var1, Object var2);
}

