/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.context;

import io.smallrye.context.SmallRyeContextManager;
import io.smallrye.context.SmallRyeContextManagerProvider;
import io.smallrye.context.SmallRyeThreadContext;
import io.smallrye.context.impl.DefaultValues;
import io.smallrye.context.impl.ThreadContextProviderPlan;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import org.eclipse.microprofile.context.ManagedExecutor;
import org.jboss.threads.ViewExecutor;

public class SmallRyeManagedExecutor
implements ManagedExecutor {
    private static final String UNI_APPLY = "java.util.concurrent.CompletableFuture$UniApply";
    private final SmallRyeThreadContext threadContext;
    private final int maxAsync;
    private final int maxQueued;
    private final String injectionPointName;
    private final ExecutorService executor;
    private final Executor noPropagationExecutor = new NoPropagationExecutor();

    public static ExecutorService newThreadPoolExecutor(int maxAsync, int maxQueued) {
        ThreadPoolExecutor exec = new ThreadPoolExecutor(maxAsync == -1 ? Runtime.getRuntime().availableProcessors() : maxAsync, maxAsync == -1 ? Runtime.getRuntime().availableProcessors() : maxAsync, 5000L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(maxQueued == -1 ? Integer.MAX_VALUE : maxQueued), new ThreadPoolExecutor.AbortPolicy());
        exec.allowCoreThreadTimeOut(true);
        return exec;
    }

    public SmallRyeManagedExecutor(int maxAsync, int maxQueued, SmallRyeThreadContext threadContext, ExecutorService executor, String injectionPointName) {
        this.threadContext = threadContext;
        this.maxAsync = maxAsync;
        this.maxQueued = maxQueued;
        this.injectionPointName = injectionPointName;
        this.executor = executor;
    }

    public void shutdown() {
        this.executor.shutdown();
    }

    public List<Runnable> shutdownNow() {
        return this.executor.shutdownNow();
    }

    public boolean isShutdown() {
        return this.executor.isShutdown();
    }

    public boolean isTerminated() {
        return this.executor.isTerminated();
    }

    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.executor.awaitTermination(timeout, unit);
    }

    public <T> Future<T> submit(Callable<T> task) {
        return this.executor.submit(this.threadContext.contextualCallableUnlessContextualized(task));
    }

    public <T> Future<T> submit(Runnable task, T result) {
        return this.executor.submit(this.threadContext.contextualRunnableUnlessContextualized(task), result);
    }

    public Future<?> submit(Runnable task) {
        return this.executor.submit(this.threadContext.contextualRunnableUnlessContextualized(task));
    }

    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        ArrayList<Callable<T>> wrappedTasks = new ArrayList<Callable<T>>(tasks.size());
        for (Callable<T> task : tasks) {
            wrappedTasks.add(this.threadContext.contextualCallableUnlessContextualized(task));
        }
        return this.executor.invokeAll(wrappedTasks);
    }

    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        ArrayList<Callable<T>> wrappedTasks = new ArrayList<Callable<T>>(tasks.size());
        for (Callable<T> task : tasks) {
            wrappedTasks.add(this.threadContext.contextualCallableUnlessContextualized(task));
        }
        return this.executor.invokeAll(wrappedTasks, timeout, unit);
    }

    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        ArrayList<Callable<T>> wrappedTasks = new ArrayList<Callable<T>>(tasks.size());
        for (Callable<T> task : tasks) {
            wrappedTasks.add(this.threadContext.contextualCallableUnlessContextualized(task));
        }
        return this.executor.invokeAny(wrappedTasks);
    }

    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        ArrayList<Callable<T>> wrappedTasks = new ArrayList<Callable<T>>(tasks.size());
        for (Callable<T> task : tasks) {
            wrappedTasks.add(this.threadContext.contextualCallableUnlessContextualized(task));
        }
        return this.executor.invokeAny(wrappedTasks, timeout, unit);
    }

    public void execute(Runnable command) {
        if (UNI_APPLY.equals(command.getClass().getName())) {
            this.executeWithoutPropagation(command);
            return;
        }
        this.executor.execute(this.threadContext.contextualRunnableUnlessContextualized(command));
    }

    private void executeWithoutPropagation(Runnable command) {
        this.executor.execute(command);
    }

    public <U> CompletableFuture<U> completedFuture(U value) {
        return this.threadContext.withContextCapture(CompletableFuture.completedFuture(value), (Executor)((Object)this), 0);
    }

    public <U> CompletionStage<U> completedStage(U value) {
        return this.completedFuture(value);
    }

    public <U> CompletableFuture<U> failedFuture(Throwable ex) {
        CompletableFuture ret = new CompletableFuture();
        ret.completeExceptionally(ex);
        return this.threadContext.withContextCapture(ret, (Executor)((Object)this), 0);
    }

    public <U> CompletionStage<U> failedStage(Throwable ex) {
        return this.failedFuture(ex);
    }

    public CompletableFuture<Void> runAsync(Runnable runnable) {
        return this.threadContext.withContextCapture(CompletableFuture.runAsync(this.threadContext.contextualRunnableUnlessContextualized(runnable), this.noPropagationExecutor), (Executor)((Object)this), 0);
    }

    public <U> CompletableFuture<U> supplyAsync(Supplier<U> supplier) {
        return this.threadContext.withContextCapture(CompletableFuture.supplyAsync(this.threadContext.contextualSupplierUnlessContextualized(supplier), this.noPropagationExecutor), (Executor)((Object)this), 0);
    }

    public <U> CompletableFuture<U> newIncompleteFuture() {
        CompletableFuture ret = new CompletableFuture();
        return this.threadContext.withContextCapture(ret, (Executor)((Object)this), 0);
    }

    public String toString() {
        String DELIMITER = ", ";
        StringBuilder builder = new StringBuilder();
        builder.append(SmallRyeManagedExecutor.class.getName()).append(", ");
        builder.append("with maxAsync: ").append(this.maxAsync).append(", ");
        builder.append("with maxQueued: ").append(this.maxQueued).append(", ");
        builder.append("with cleared contexts: ").append(this.threadContext.getPlan().clearedProviders).append(", ");
        builder.append("with propagated contexts: ").append(this.threadContext.getPlan().propagatedProviders).append(", ");
        builder.append("with unchanged contexts: ").append(this.threadContext.getPlan().unchangedProviders);
        if (this.injectionPointName != null) {
            builder.append(", ").append(" with injection point name: ").append(this.injectionPointName);
        }
        return builder.toString();
    }

    public ThreadContextProviderPlan getThreadContextProviderPlan() {
        return this.threadContext.getPlan();
    }

    public int getMaxAsync() {
        return this.maxAsync;
    }

    public int getMaxQueued() {
        return this.maxQueued;
    }

    public String getInjectionPointName() {
        return this.injectionPointName;
    }

    public static Builder builder() {
        return SmallRyeContextManagerProvider.instance().getContextManager().newManagedExecutorBuilder();
    }

    public <T> CompletableFuture<T> copy(CompletableFuture<T> stage) {
        return this.threadContext.withContextCapture(stage, (Executor)((Object)this), 0);
    }

    public <T> CompletionStage<T> copy(CompletionStage<T> stage) {
        return this.threadContext.withContextCapture(stage, (Executor)((Object)this));
    }

    public SmallRyeThreadContext getThreadContext() {
        return this.threadContext;
    }

    private class NoPropagationExecutor
    implements Executor {
        private NoPropagationExecutor() {
        }

        @Override
        public void execute(Runnable command) {
            SmallRyeManagedExecutor.this.executeWithoutPropagation(command);
        }
    }

    public static class Builder
    implements ManagedExecutor.Builder {
        private SmallRyeContextManager manager;
        private int maxAsync;
        private int maxQueued;
        private String[] propagated;
        private String[] cleared;
        private String injectionPointName = null;
        private ExecutorService executorService;

        public Builder(SmallRyeContextManager manager) {
            this.manager = manager;
            DefaultValues defaultValues = manager.getDefaultValues();
            this.propagated = defaultValues.getExecutorPropagated();
            this.cleared = defaultValues.getExecutorCleared();
            this.maxAsync = defaultValues.getExecutorAsync();
            this.maxQueued = defaultValues.getExecutorQueue();
            this.executorService = manager.getDefaultExecutorService();
        }

        public SmallRyeManagedExecutor build() {
            ExecutorService executor = this.executorService != null ? ViewExecutor.builder((Executor)this.executorService).setMaxSize(this.maxAsync == -1 ? Short.MAX_VALUE : this.maxAsync).setQueueLimit(this.maxQueued == -1 ? Integer.MAX_VALUE : this.maxQueued).build() : SmallRyeManagedExecutor.newThreadPoolExecutor(this.maxAsync, this.maxQueued);
            return new SmallRyeManagedExecutor(this.maxAsync, this.maxQueued, new SmallRyeThreadContext(this.manager, this.propagated, SmallRyeContextManager.NO_STRING, this.cleared, null, executor), executor, this.injectionPointName);
        }

        public Builder propagated(String ... types) {
            this.propagated = types;
            return this;
        }

        public Builder maxAsync(int max) {
            if (max == 0 || max < -1) {
                throw new IllegalArgumentException("ManagedExecutor parameter maxAsync cannot be 0 or lower then -1.");
            }
            this.maxAsync = max;
            return this;
        }

        public Builder maxQueued(int max) {
            if (max == 0 || max < -1) {
                throw new IllegalArgumentException("ManagedExecutor parameter maxQueued cannot be 0 or lower than -1.");
            }
            this.maxQueued = max;
            return this;
        }

        public Builder cleared(String ... types) {
            this.cleared = types;
            return this;
        }

        public Builder injectionPointName(String name) {
            this.injectionPointName = name;
            return this;
        }

        public Builder withExecutorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        public Builder withNewExecutorService() {
            this.executorService = null;
            return this;
        }
    }
}

