/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrPosef;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrMarkerSpaceCreateInfoVARJO
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int MARKERID;
    public static final int POSEINMARKERSPACE;

    public XrMarkerSpaceCreateInfoVARJO(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), XrMarkerSpaceCreateInfoVARJO.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrMarkerSpaceCreateInfoVARJO.ntype(this.address());
    }

    @NativeType(value="void const *")
    public long next() {
        return XrMarkerSpaceCreateInfoVARJO.nnext(this.address());
    }

    @NativeType(value="uint64_t")
    public long markerId() {
        return XrMarkerSpaceCreateInfoVARJO.nmarkerId(this.address());
    }

    public XrPosef poseInMarkerSpace() {
        return XrMarkerSpaceCreateInfoVARJO.nposeInMarkerSpace(this.address());
    }

    public XrMarkerSpaceCreateInfoVARJO type(@NativeType(value="XrStructureType") int value) {
        XrMarkerSpaceCreateInfoVARJO.ntype(this.address(), value);
        return this;
    }

    public XrMarkerSpaceCreateInfoVARJO type$Default() {
        return this.type(1000124002);
    }

    public XrMarkerSpaceCreateInfoVARJO next(@NativeType(value="void const *") long value) {
        XrMarkerSpaceCreateInfoVARJO.nnext(this.address(), value);
        return this;
    }

    public XrMarkerSpaceCreateInfoVARJO markerId(@NativeType(value="uint64_t") long value) {
        XrMarkerSpaceCreateInfoVARJO.nmarkerId(this.address(), value);
        return this;
    }

    public XrMarkerSpaceCreateInfoVARJO poseInMarkerSpace(XrPosef value) {
        XrMarkerSpaceCreateInfoVARJO.nposeInMarkerSpace(this.address(), value);
        return this;
    }

    public XrMarkerSpaceCreateInfoVARJO poseInMarkerSpace(Consumer<XrPosef> consumer) {
        consumer.accept(this.poseInMarkerSpace());
        return this;
    }

    public XrMarkerSpaceCreateInfoVARJO set(int type, long next, long markerId, XrPosef poseInMarkerSpace) {
        this.type(type);
        this.next(next);
        this.markerId(markerId);
        this.poseInMarkerSpace(poseInMarkerSpace);
        return this;
    }

    public XrMarkerSpaceCreateInfoVARJO set(XrMarkerSpaceCreateInfoVARJO src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static XrMarkerSpaceCreateInfoVARJO malloc() {
        return (XrMarkerSpaceCreateInfoVARJO)XrMarkerSpaceCreateInfoVARJO.wrap(XrMarkerSpaceCreateInfoVARJO.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static XrMarkerSpaceCreateInfoVARJO calloc() {
        return (XrMarkerSpaceCreateInfoVARJO)XrMarkerSpaceCreateInfoVARJO.wrap(XrMarkerSpaceCreateInfoVARJO.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static XrMarkerSpaceCreateInfoVARJO create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (XrMarkerSpaceCreateInfoVARJO)XrMarkerSpaceCreateInfoVARJO.wrap(XrMarkerSpaceCreateInfoVARJO.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static XrMarkerSpaceCreateInfoVARJO create(long address) {
        return (XrMarkerSpaceCreateInfoVARJO)XrMarkerSpaceCreateInfoVARJO.wrap(XrMarkerSpaceCreateInfoVARJO.class, (long)address);
    }

    @Nullable
    public static XrMarkerSpaceCreateInfoVARJO createSafe(long address) {
        return address == 0L ? null : (XrMarkerSpaceCreateInfoVARJO)XrMarkerSpaceCreateInfoVARJO.wrap(XrMarkerSpaceCreateInfoVARJO.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)XrMarkerSpaceCreateInfoVARJO.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)XrMarkerSpaceCreateInfoVARJO.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)XrMarkerSpaceCreateInfoVARJO.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrMarkerSpaceCreateInfoVARJO.__create((int)capacity, (int)SIZEOF);
        return (Buffer)XrMarkerSpaceCreateInfoVARJO.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)XrMarkerSpaceCreateInfoVARJO.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)XrMarkerSpaceCreateInfoVARJO.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static XrMarkerSpaceCreateInfoVARJO malloc(MemoryStack stack) {
        return (XrMarkerSpaceCreateInfoVARJO)XrMarkerSpaceCreateInfoVARJO.wrap(XrMarkerSpaceCreateInfoVARJO.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static XrMarkerSpaceCreateInfoVARJO calloc(MemoryStack stack) {
        return (XrMarkerSpaceCreateInfoVARJO)XrMarkerSpaceCreateInfoVARJO.wrap(XrMarkerSpaceCreateInfoVARJO.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)XrMarkerSpaceCreateInfoVARJO.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)XrMarkerSpaceCreateInfoVARJO.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int ntype(long struct) {
        return UNSAFE.getInt(null, struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)NEXT));
    }

    public static long nmarkerId(long struct) {
        return UNSAFE.getLong(null, struct + (long)MARKERID);
    }

    public static XrPosef nposeInMarkerSpace(long struct) {
        return XrPosef.create(struct + (long)POSEINMARKERSPACE);
    }

    public static void ntype(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)NEXT), (long)value);
    }

    public static void nmarkerId(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)MARKERID, value);
    }

    public static void nposeInMarkerSpace(long struct, XrPosef value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)POSEINMARKERSPACE), (long)XrPosef.SIZEOF);
    }

    static {
        Struct.Layout layout = XrMarkerSpaceCreateInfoVARJO.__struct((Struct.Member[])new Struct.Member[]{XrMarkerSpaceCreateInfoVARJO.__member((int)4), XrMarkerSpaceCreateInfoVARJO.__member((int)POINTER_SIZE), XrMarkerSpaceCreateInfoVARJO.__member((int)8), XrMarkerSpaceCreateInfoVARJO.__member((int)XrPosef.SIZEOF, (int)XrPosef.ALIGNOF)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        MARKERID = layout.offsetof(2);
        POSEINMARKERSPACE = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<XrMarkerSpaceCreateInfoVARJO, Buffer>
    implements NativeResource {
        private static final XrMarkerSpaceCreateInfoVARJO ELEMENT_FACTORY = XrMarkerSpaceCreateInfoVARJO.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected XrMarkerSpaceCreateInfoVARJO getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrMarkerSpaceCreateInfoVARJO.ntype(this.address());
        }

        @NativeType(value="void const *")
        public long next() {
            return XrMarkerSpaceCreateInfoVARJO.nnext(this.address());
        }

        @NativeType(value="uint64_t")
        public long markerId() {
            return XrMarkerSpaceCreateInfoVARJO.nmarkerId(this.address());
        }

        public XrPosef poseInMarkerSpace() {
            return XrMarkerSpaceCreateInfoVARJO.nposeInMarkerSpace(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrMarkerSpaceCreateInfoVARJO.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000124002);
        }

        public Buffer next(@NativeType(value="void const *") long value) {
            XrMarkerSpaceCreateInfoVARJO.nnext(this.address(), value);
            return this;
        }

        public Buffer markerId(@NativeType(value="uint64_t") long value) {
            XrMarkerSpaceCreateInfoVARJO.nmarkerId(this.address(), value);
            return this;
        }

        public Buffer poseInMarkerSpace(XrPosef value) {
            XrMarkerSpaceCreateInfoVARJO.nposeInMarkerSpace(this.address(), value);
            return this;
        }

        public Buffer poseInMarkerSpace(Consumer<XrPosef> consumer) {
            consumer.accept(this.poseInMarkerSpace());
            return this;
        }
    }
}

