/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.binding.xml;

import java.io.StringReader;
import java.util.ArrayList;
import java.util.Locale;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.jupnp.binding.staging.MutableAction;
import org.jupnp.binding.staging.MutableActionArgument;
import org.jupnp.binding.staging.MutableAllowedValueRange;
import org.jupnp.binding.staging.MutableService;
import org.jupnp.binding.staging.MutableStateVariable;
import org.jupnp.binding.xml.Descriptor;
import org.jupnp.binding.xml.DescriptorBindingException;
import org.jupnp.binding.xml.ServiceDescriptorBinder;
import org.jupnp.model.ValidationException;
import org.jupnp.model.XMLUtil;
import org.jupnp.model.meta.Action;
import org.jupnp.model.meta.ActionArgument;
import org.jupnp.model.meta.Device;
import org.jupnp.model.meta.RemoteService;
import org.jupnp.model.meta.Service;
import org.jupnp.model.meta.StateVariable;
import org.jupnp.model.meta.StateVariableEventDetails;
import org.jupnp.model.types.CustomDatatype;
import org.jupnp.model.types.Datatype;
import org.jupnp.util.SpecificationViolationReporter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class UDA10ServiceDescriptorBinderImpl
implements ServiceDescriptorBinder,
ErrorHandler {
    private final Logger logger = LoggerFactory.getLogger(ServiceDescriptorBinder.class);

    public <S extends Service> S describe(S undescribedService, String descriptorXml) throws DescriptorBindingException, ValidationException {
        if (descriptorXml == null || descriptorXml.isEmpty()) {
            throw new DescriptorBindingException("Null or empty descriptor");
        }
        try {
            this.logger.trace("Populating service from XML descriptor: {}", undescribedService);
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = factory.newDocumentBuilder();
            documentBuilder.setErrorHandler(this);
            Document d = documentBuilder.parse(new InputSource(new StringReader(descriptorXml.trim())));
            return this.describe(undescribedService, d);
        }
        catch (ValidationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DescriptorBindingException("Could not parse service descriptor", e);
        }
    }

    public <S extends Service> S describe(S undescribedService, Document dom) throws DescriptorBindingException, ValidationException {
        try {
            this.logger.trace("Populating service from DOM: {}", undescribedService);
            MutableService descriptor = new MutableService();
            this.hydrateBasic(descriptor, undescribedService);
            Element rootElement = dom.getDocumentElement();
            this.hydrateRoot(descriptor, rootElement);
            return this.buildInstance(undescribedService, descriptor);
        }
        catch (ValidationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DescriptorBindingException("Could not parse service DOM", e);
        }
    }

    protected <S extends Service> S buildInstance(S undescribedService, MutableService descriptor) throws ValidationException {
        return (S)descriptor.build((Device)undescribedService.getDevice());
    }

    protected void hydrateBasic(MutableService descriptor, Service undescribedService) {
        descriptor.serviceId = undescribedService.getServiceId();
        descriptor.serviceType = undescribedService.getServiceType();
        if (undescribedService instanceof RemoteService) {
            RemoteService rs = (RemoteService)undescribedService;
            descriptor.controlURI = rs.getControlURI();
            descriptor.eventSubscriptionURI = rs.getEventSubscriptionURI();
            descriptor.descriptorURI = rs.getDescriptorURI();
        }
    }

    protected void hydrateRoot(MutableService descriptor, Element rootElement) throws DescriptorBindingException {
        if (!Descriptor.Service.ELEMENT.scpd.equals(rootElement)) {
            throw new DescriptorBindingException("Root element name is not <scpd>: " + rootElement.getNodeName());
        }
        NodeList rootChildren = rootElement.getChildNodes();
        for (int i = 0; i < rootChildren.getLength(); ++i) {
            Node rootChild = rootChildren.item(i);
            if (rootChild.getNodeType() != 1) continue;
            if (Descriptor.Service.ELEMENT.specVersion.equals(rootChild)) {
                this.logger.trace("Ignoring UDA major/minor specVersion");
                continue;
            }
            if (Descriptor.Service.ELEMENT.actionList.equals(rootChild)) {
                this.hydrateActionList(descriptor, rootChild);
                continue;
            }
            if (Descriptor.Service.ELEMENT.serviceStateTable.equals(rootChild)) {
                this.hydrateServiceStateTableList(descriptor, rootChild);
                continue;
            }
            this.logger.trace("Ignoring unknown element: {}", (Object)rootChild.getNodeName());
        }
    }

    public void hydrateActionList(MutableService descriptor, Node actionListNode) throws DescriptorBindingException {
        NodeList actionListChildren = actionListNode.getChildNodes();
        for (int i = 0; i < actionListChildren.getLength(); ++i) {
            Node actionListChild = actionListChildren.item(i);
            if (actionListChild.getNodeType() != 1 || !Descriptor.Service.ELEMENT.action.equals(actionListChild)) continue;
            MutableAction action = new MutableAction();
            this.hydrateAction(action, actionListChild);
            descriptor.actions.add(action);
        }
    }

    public void hydrateAction(MutableAction action, Node actionNode) {
        NodeList actionNodeChildren = actionNode.getChildNodes();
        for (int i = 0; i < actionNodeChildren.getLength(); ++i) {
            Node actionNodeChild = actionNodeChildren.item(i);
            if (actionNodeChild.getNodeType() != 1) continue;
            if (Descriptor.Service.ELEMENT.name.equals(actionNodeChild)) {
                action.name = XMLUtil.getTextContent(actionNodeChild);
                continue;
            }
            if (!Descriptor.Service.ELEMENT.argumentList.equals(actionNodeChild)) continue;
            NodeList argumentChildren = actionNodeChild.getChildNodes();
            for (int j = 0; j < argumentChildren.getLength(); ++j) {
                Node argumentChild = argumentChildren.item(j);
                if (argumentChild.getNodeType() != 1) continue;
                MutableActionArgument actionArgument = new MutableActionArgument();
                this.hydrateActionArgument(actionArgument, argumentChild);
                action.arguments.add(actionArgument);
            }
        }
    }

    public void hydrateActionArgument(MutableActionArgument actionArgument, Node actionArgumentNode) {
        NodeList argumentNodeChildren = actionArgumentNode.getChildNodes();
        for (int i = 0; i < argumentNodeChildren.getLength(); ++i) {
            Node argumentNodeChild = argumentNodeChildren.item(i);
            if (argumentNodeChild.getNodeType() != 1) continue;
            if (Descriptor.Service.ELEMENT.name.equals(argumentNodeChild)) {
                actionArgument.name = XMLUtil.getTextContent(argumentNodeChild);
                continue;
            }
            if (Descriptor.Service.ELEMENT.direction.equals(argumentNodeChild)) {
                String directionString = XMLUtil.getTextContent(argumentNodeChild);
                try {
                    actionArgument.direction = ActionArgument.Direction.valueOf(directionString.toUpperCase(Locale.ENGLISH));
                }
                catch (IllegalArgumentException e) {
                    SpecificationViolationReporter.report("Invalid action argument direction, assuming 'IN': {}", directionString);
                    actionArgument.direction = ActionArgument.Direction.IN;
                }
                continue;
            }
            if (Descriptor.Service.ELEMENT.relatedStateVariable.equals(argumentNodeChild)) {
                actionArgument.relatedStateVariable = XMLUtil.getTextContent(argumentNodeChild);
                continue;
            }
            if (!Descriptor.Service.ELEMENT.retval.equals(argumentNodeChild)) continue;
            actionArgument.retval = true;
        }
    }

    public void hydrateServiceStateTableList(MutableService descriptor, Node serviceStateTableNode) {
        NodeList serviceStateTableChildren = serviceStateTableNode.getChildNodes();
        for (int i = 0; i < serviceStateTableChildren.getLength(); ++i) {
            Node serviceStateTableChild = serviceStateTableChildren.item(i);
            if (serviceStateTableChild.getNodeType() != 1 || !Descriptor.Service.ELEMENT.stateVariable.equals(serviceStateTableChild)) continue;
            MutableStateVariable stateVariable = new MutableStateVariable();
            this.hydrateStateVariable(stateVariable, (Element)serviceStateTableChild);
            descriptor.stateVariables.add(stateVariable);
        }
    }

    public void hydrateStateVariable(MutableStateVariable stateVariable, Element stateVariableElement) {
        stateVariable.eventDetails = new StateVariableEventDetails(stateVariableElement.getAttribute("sendEvents") != null && stateVariableElement.getAttribute(Descriptor.Service.ATTRIBUTE.sendEvents.toString()).toUpperCase(Locale.ENGLISH).equals("YES"));
        NodeList stateVariableChildren = stateVariableElement.getChildNodes();
        for (int i = 0; i < stateVariableChildren.getLength(); ++i) {
            int j;
            Node stateVariableChild = stateVariableChildren.item(i);
            if (stateVariableChild.getNodeType() != 1) continue;
            if (Descriptor.Service.ELEMENT.name.equals(stateVariableChild)) {
                stateVariable.name = XMLUtil.getTextContent(stateVariableChild);
                continue;
            }
            if (Descriptor.Service.ELEMENT.dataType.equals(stateVariableChild)) {
                String dtName = XMLUtil.getTextContent(stateVariableChild);
                Datatype.Builtin builtin = Datatype.Builtin.getByDescriptorName(dtName);
                stateVariable.dataType = builtin != null ? builtin.getDatatype() : new CustomDatatype(dtName);
                continue;
            }
            if (Descriptor.Service.ELEMENT.defaultValue.equals(stateVariableChild)) {
                stateVariable.defaultValue = XMLUtil.getTextContent(stateVariableChild);
                continue;
            }
            if (Descriptor.Service.ELEMENT.allowedValueList.equals(stateVariableChild)) {
                ArrayList<String> allowedValues = new ArrayList<String>();
                NodeList allowedValueListChildren = stateVariableChild.getChildNodes();
                for (j = 0; j < allowedValueListChildren.getLength(); ++j) {
                    Node allowedValueListChild = allowedValueListChildren.item(j);
                    if (allowedValueListChild.getNodeType() != 1 || !Descriptor.Service.ELEMENT.allowedValue.equals(allowedValueListChild)) continue;
                    allowedValues.add(XMLUtil.getTextContent(allowedValueListChild));
                }
                stateVariable.allowedValues = allowedValues;
                continue;
            }
            if (!Descriptor.Service.ELEMENT.allowedValueRange.equals(stateVariableChild)) continue;
            MutableAllowedValueRange range = new MutableAllowedValueRange();
            NodeList allowedValueRangeChildren = stateVariableChild.getChildNodes();
            for (j = 0; j < allowedValueRangeChildren.getLength(); ++j) {
                Node allowedValueRangeChild = allowedValueRangeChildren.item(j);
                if (allowedValueRangeChild.getNodeType() != 1) continue;
                if (Descriptor.Service.ELEMENT.minimum.equals(allowedValueRangeChild)) {
                    try {
                        range.minimum = Long.valueOf(XMLUtil.getTextContent(allowedValueRangeChild));
                    }
                    catch (Exception exception) {}
                    continue;
                }
                if (Descriptor.Service.ELEMENT.maximum.equals(allowedValueRangeChild)) {
                    try {
                        range.maximum = Long.valueOf(XMLUtil.getTextContent(allowedValueRangeChild));
                    }
                    catch (Exception exception) {}
                    continue;
                }
                if (!Descriptor.Service.ELEMENT.step.equals(allowedValueRangeChild)) continue;
                try {
                    range.step = Long.valueOf(XMLUtil.getTextContent(allowedValueRangeChild));
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            stateVariable.allowedValueRange = range;
        }
    }

    @Override
    public String generate(Service service) throws DescriptorBindingException {
        try {
            this.logger.trace("Generating XML descriptor from service model: {}", (Object)service);
            return XMLUtil.documentToString(this.buildDOM(service));
        }
        catch (Exception e) {
            throw new DescriptorBindingException("Could not build DOM: " + e.getMessage(), e);
        }
    }

    @Override
    public Document buildDOM(Service service) throws DescriptorBindingException {
        try {
            this.logger.trace("Generting XML descriptor from service model: {}", (Object)service);
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            Document d = factory.newDocumentBuilder().newDocument();
            this.generateScpd(service, d);
            return d;
        }
        catch (Exception e) {
            throw new DescriptorBindingException("Could not generate service descriptor: " + e.getMessage(), e);
        }
    }

    private void generateScpd(Service serviceModel, Document descriptor) {
        Element scpdElement = descriptor.createElementNS("urn:schemas-upnp-org:service-1-0", Descriptor.Service.ELEMENT.scpd.toString());
        descriptor.appendChild(scpdElement);
        this.generateSpecVersion(serviceModel, descriptor, scpdElement);
        if (serviceModel.hasActions()) {
            this.generateActionList(serviceModel, descriptor, scpdElement);
        }
        this.generateServiceStateTable(serviceModel, descriptor, scpdElement);
    }

    private void generateSpecVersion(Service serviceModel, Document descriptor, Element rootElement) {
        Element specVersionElement = XMLUtil.appendNewElement(descriptor, rootElement, Descriptor.Service.ELEMENT.specVersion);
        XMLUtil.appendNewElementIfNotNull(descriptor, specVersionElement, Descriptor.Service.ELEMENT.major, (Object)((Device)serviceModel.getDevice()).getVersion().getMajor());
        XMLUtil.appendNewElementIfNotNull(descriptor, specVersionElement, Descriptor.Service.ELEMENT.minor, (Object)((Device)serviceModel.getDevice()).getVersion().getMinor());
    }

    private void generateActionList(Service serviceModel, Document descriptor, Element scpdElement) {
        Element actionListElement = XMLUtil.appendNewElement(descriptor, scpdElement, Descriptor.Service.ELEMENT.actionList);
        for (Action action : serviceModel.getActions()) {
            if (action.getName().equals("QueryStateVariable")) continue;
            this.generateAction(action, descriptor, actionListElement);
        }
    }

    private void generateAction(Action action, Document descriptor, Element actionListElement) {
        Element actionElement = XMLUtil.appendNewElement(descriptor, actionListElement, Descriptor.Service.ELEMENT.action);
        XMLUtil.appendNewElementIfNotNull(descriptor, actionElement, Descriptor.Service.ELEMENT.name, (Object)action.getName());
        if (action.hasArguments()) {
            Element argumentListElement = XMLUtil.appendNewElement(descriptor, actionElement, Descriptor.Service.ELEMENT.argumentList);
            for (ActionArgument actionArgument : action.getArguments()) {
                this.generateActionArgument(actionArgument, descriptor, argumentListElement);
            }
        }
    }

    private void generateActionArgument(ActionArgument actionArgument, Document descriptor, Element actionElement) {
        Element actionArgumentElement = XMLUtil.appendNewElement(descriptor, actionElement, Descriptor.Service.ELEMENT.argument);
        XMLUtil.appendNewElementIfNotNull(descriptor, actionArgumentElement, Descriptor.Service.ELEMENT.name, (Object)actionArgument.getName());
        XMLUtil.appendNewElementIfNotNull(descriptor, actionArgumentElement, Descriptor.Service.ELEMENT.direction, (Object)actionArgument.getDirection().toString().toLowerCase(Locale.ENGLISH));
        if (actionArgument.isReturnValue()) {
            SpecificationViolationReporter.report("Not producing <retval> element to be compatible with WMP12: {}", actionArgument);
        }
        XMLUtil.appendNewElementIfNotNull(descriptor, actionArgumentElement, Descriptor.Service.ELEMENT.relatedStateVariable, (Object)actionArgument.getRelatedStateVariableName());
    }

    private void generateServiceStateTable(Service serviceModel, Document descriptor, Element scpdElement) {
        Element serviceStateTableElement = XMLUtil.appendNewElement(descriptor, scpdElement, Descriptor.Service.ELEMENT.serviceStateTable);
        for (StateVariable stateVariable : serviceModel.getStateVariables()) {
            this.generateStateVariable(stateVariable, descriptor, serviceStateTableElement);
        }
    }

    private void generateStateVariable(StateVariable stateVariable, Document descriptor, Element serviveStateTableElement) {
        Element stateVariableElement = XMLUtil.appendNewElement(descriptor, serviveStateTableElement, Descriptor.Service.ELEMENT.stateVariable);
        XMLUtil.appendNewElementIfNotNull(descriptor, stateVariableElement, Descriptor.Service.ELEMENT.name, (Object)stateVariable.getName());
        if (stateVariable.getTypeDetails().getDatatype() instanceof CustomDatatype) {
            XMLUtil.appendNewElementIfNotNull(descriptor, stateVariableElement, Descriptor.Service.ELEMENT.dataType, (Object)((CustomDatatype)stateVariable.getTypeDetails().getDatatype()).getName());
        } else {
            XMLUtil.appendNewElementIfNotNull(descriptor, stateVariableElement, Descriptor.Service.ELEMENT.dataType, (Object)stateVariable.getTypeDetails().getDatatype().getBuiltin().getDescriptorName());
        }
        XMLUtil.appendNewElementIfNotNull(descriptor, stateVariableElement, Descriptor.Service.ELEMENT.defaultValue, (Object)stateVariable.getTypeDetails().getDefaultValue());
        if (stateVariable.getEventDetails().isSendEvents()) {
            stateVariableElement.setAttribute(Descriptor.Service.ATTRIBUTE.sendEvents.toString(), "yes");
        } else {
            stateVariableElement.setAttribute(Descriptor.Service.ATTRIBUTE.sendEvents.toString(), "no");
        }
        if (stateVariable.getTypeDetails().getAllowedValues() != null) {
            Element allowedValueListElement = XMLUtil.appendNewElement(descriptor, stateVariableElement, Descriptor.Service.ELEMENT.allowedValueList);
            for (String allowedValue : stateVariable.getTypeDetails().getAllowedValues()) {
                XMLUtil.appendNewElementIfNotNull(descriptor, allowedValueListElement, Descriptor.Service.ELEMENT.allowedValue, (Object)allowedValue);
            }
        }
        if (stateVariable.getTypeDetails().getAllowedValueRange() != null) {
            Element allowedValueRangeElement = XMLUtil.appendNewElement(descriptor, stateVariableElement, Descriptor.Service.ELEMENT.allowedValueRange);
            XMLUtil.appendNewElementIfNotNull(descriptor, allowedValueRangeElement, Descriptor.Service.ELEMENT.minimum, (Object)stateVariable.getTypeDetails().getAllowedValueRange().getMinimum());
            XMLUtil.appendNewElementIfNotNull(descriptor, allowedValueRangeElement, Descriptor.Service.ELEMENT.maximum, (Object)stateVariable.getTypeDetails().getAllowedValueRange().getMaximum());
            if (stateVariable.getTypeDetails().getAllowedValueRange().getStep() >= 1L) {
                XMLUtil.appendNewElementIfNotNull(descriptor, allowedValueRangeElement, Descriptor.Service.ELEMENT.step, (Object)stateVariable.getTypeDetails().getAllowedValueRange().getStep());
            }
        }
    }

    @Override
    public void warning(SAXParseException e) throws SAXException {
        this.logger.warn(e.toString());
    }

    @Override
    public void error(SAXParseException e) throws SAXException {
        throw e;
    }

    @Override
    public void fatalError(SAXParseException e) throws SAXException {
        throw e;
    }
}

