/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.transport.udp;

import net.i2p.router.RouterContext;
import net.i2p.router.transport.udp.MessageReceiver;
import net.i2p.router.transport.udp.OutboundMessageFragments;
import net.i2p.router.transport.udp.UDPTransport;
import net.i2p.router.util.DecayingBloomFilter;
import net.i2p.router.util.DecayingHashSet;
import net.i2p.util.Log;

class InboundMessageFragments {
    private final RouterContext _context;
    private final Log _log;
    private DecayingBloomFilter _recentlyCompletedMessages;
    private final OutboundMessageFragments _outbound;
    private final UDPTransport _transport;
    private final MessageReceiver _messageReceiver;
    private volatile boolean _alive;
    private static final int DECAY_PERIOD = 10000;

    public InboundMessageFragments(RouterContext ctx, OutboundMessageFragments outbound, UDPTransport transport) {
        this._context = ctx;
        this._log = ctx.logManager().getLog(InboundMessageFragments.class);
        this._outbound = outbound;
        this._transport = transport;
        this._messageReceiver = new MessageReceiver(this._context, this._transport);
        this._context.statManager().createRateStat("udp.receivedCompleteTime", "How long it takes to receive a full message", "udp", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.receivedCompleteFragments", "How many fragments go in a fully received message", "udp", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.ignoreRecentDuplicate", "Take note that we received a packet for a recently completed message", "udp", UDPTransport.RATES);
    }

    public synchronized void startup() {
        this._alive = true;
        this._recentlyCompletedMessages = new DecayingHashSet(this._context, 10000, 4, "UDPIMF");
        this._messageReceiver.startup();
    }

    public synchronized void shutdown() {
        this._alive = false;
        if (this._recentlyCompletedMessages != null) {
            this._recentlyCompletedMessages.stopDecaying();
        }
        this._recentlyCompletedMessages = null;
        this._messageReceiver.shutdown();
    }

    public boolean isAlive() {
        return this._alive;
    }

    public boolean messageReceived(long messageID) {
        return this._recentlyCompletedMessages.add(messageID);
    }

    public boolean wasRecentlyReceived(long messageID) {
        return this._recentlyCompletedMessages.isKnown(messageID);
    }

    public static class ModifiableLong {
        public long value;

        public ModifiableLong(long val) {
            this.value = val;
        }
    }
}

