/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.jdi;

import com.sun.jdi.ArrayReference;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.Value;
import com.sun.jdi.VirtualMachine;
import java.util.ArrayList;
import java.util.List;
import sun.jvm.hotspot.jdi.ArrayTypeImpl;
import sun.jvm.hotspot.jdi.BooleanValueImpl;
import sun.jvm.hotspot.jdi.ByteValueImpl;
import sun.jvm.hotspot.jdi.CharValueImpl;
import sun.jvm.hotspot.jdi.DoubleValueImpl;
import sun.jvm.hotspot.jdi.FloatValueImpl;
import sun.jvm.hotspot.jdi.IntegerValueImpl;
import sun.jvm.hotspot.jdi.LongValueImpl;
import sun.jvm.hotspot.jdi.ObjectReferenceImpl;
import sun.jvm.hotspot.jdi.ShortValueImpl;
import sun.jvm.hotspot.jdi.ValueImpl;
import sun.jvm.hotspot.oops.Array;
import sun.jvm.hotspot.oops.ObjArray;
import sun.jvm.hotspot.oops.TypeArray;
import sun.jvm.hotspot.runtime.BasicType;

public class ArrayReferenceImpl
extends ObjectReferenceImpl
implements ArrayReference {
    private int length;

    ArrayReferenceImpl(VirtualMachine aVm, Array aRef) {
        super(aVm, aRef);
        this.length = (int)aRef.getLength();
    }

    ArrayTypeImpl arrayType() {
        return (ArrayTypeImpl)this.type();
    }

    @Override
    public int length() {
        return this.length;
    }

    @Override
    public Value getValue(int index) {
        List list = this.getValues(index, 1);
        return (Value)list.get(0);
    }

    public List getValues() {
        return this.getValues(0, -1);
    }

    private void validateArrayAccess(int index, int len) {
        if (index < 0 || index > this.length()) {
            throw new IndexOutOfBoundsException("Invalid array index: " + index);
        }
        if (len < 0) {
            throw new IndexOutOfBoundsException("Invalid array range length: " + len);
        }
        if (index + len > this.length()) {
            throw new IndexOutOfBoundsException("Invalid array range: " + index + " to " + (index + len - 1));
        }
    }

    public List getValues(int index, int len) {
        if (len == -1) {
            len = this.length() - index;
        }
        this.validateArrayAccess(index, len);
        ArrayList<BooleanValueImpl> vals = new ArrayList<BooleanValueImpl>();
        if (len == 0) {
            return vals;
        }
        TypeArray typeArray = null;
        ObjArray objArray = null;
        if (this.ref() instanceof TypeArray) {
            typeArray = (TypeArray)this.ref();
        } else if (this.ref() instanceof ObjArray) {
            objArray = (ObjArray)this.ref();
        } else {
            throw new RuntimeException("should not reach here");
        }
        char c = this.arrayType().componentSignature().charAt(0);
        BasicType variableType = BasicType.charToBasicType(c);
        int limit = index + len;
        for (int ii = index; ii < limit; ++ii) {
            ValueImpl valueImpl;
            if (variableType == BasicType.T_BOOLEAN) {
                valueImpl = (BooleanValueImpl)this.vm.mirrorOf(typeArray.getBooleanAt(ii));
            } else if (variableType == BasicType.T_CHAR) {
                valueImpl = (CharValueImpl)this.vm.mirrorOf(typeArray.getCharAt(ii));
            } else if (variableType == BasicType.T_FLOAT) {
                valueImpl = (FloatValueImpl)this.vm.mirrorOf(typeArray.getFloatAt(ii));
            } else if (variableType == BasicType.T_DOUBLE) {
                valueImpl = (DoubleValueImpl)this.vm.mirrorOf(typeArray.getDoubleAt(ii));
            } else if (variableType == BasicType.T_BYTE) {
                valueImpl = (ByteValueImpl)this.vm.mirrorOf(typeArray.getByteAt(ii));
            } else if (variableType == BasicType.T_SHORT) {
                valueImpl = (ShortValueImpl)this.vm.mirrorOf(typeArray.getShortAt(ii));
            } else if (variableType == BasicType.T_INT) {
                valueImpl = (IntegerValueImpl)this.vm.mirrorOf(typeArray.getIntAt(ii));
            } else if (variableType == BasicType.T_LONG) {
                valueImpl = (LongValueImpl)this.vm.mirrorOf(typeArray.getLongAt(ii));
            } else if (variableType == BasicType.T_OBJECT) {
                valueImpl = this.vm.objectMirror(objArray.getObjAt(ii));
            } else if (variableType == BasicType.T_ARRAY) {
                valueImpl = this.vm.arrayMirror((Array)objArray.getObjAt(ii));
            } else {
                throw new RuntimeException("should not reach here");
            }
            vals.add((BooleanValueImpl)valueImpl);
        }
        return vals;
    }

    @Override
    public void setValue(int index, Value value) throws InvalidTypeException, ClassNotLoadedException {
        this.vm.throwNotReadOnlyException("ArrayReference.setValue(...)");
    }

    public void setValues(List values) throws InvalidTypeException, ClassNotLoadedException {
        this.setValues(0, values, 0, -1);
    }

    public void setValues(int index, List values, int srcIndex, int length) throws InvalidTypeException, ClassNotLoadedException {
        this.vm.throwNotReadOnlyException("ArrayReference.setValue(...)");
    }

    @Override
    public String toString() {
        return "instance of " + this.arrayType().componentTypeName() + "[" + this.length() + "] (id=" + this.uniqueID() + ")";
    }
}

