/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.normalizer.generator;

import java.util.logging.Logger;
import org.jfree.layouting.LayoutProcess;
import org.jfree.layouting.State;
import org.jfree.layouting.StateException;
import org.jfree.layouting.StatefullComponent;
import org.jfree.layouting.layouter.content.ContentToken;
import org.jfree.layouting.layouter.context.LayoutContext;
import org.jfree.layouting.layouter.context.PageContext;
import org.jfree.layouting.normalizer.content.NormalizationException;
import org.jfree.layouting.normalizer.generator.ContentGenerator;
import org.jfree.layouting.renderer.Renderer;

public class PrintContentGenerator
implements ContentGenerator {
    private static final Logger logger = Logger.getLogger(PrintContentGenerator.class.getName());
    private Renderer renderer;

    public PrintContentGenerator(LayoutProcess layoutProcess) {
        this.renderer = layoutProcess.getOutputProcessor().createRenderer(layoutProcess);
    }

    public PrintContentGenerator(Renderer renderer) {
        this.renderer = renderer;
    }

    @Override
    public void startedDocument(PageContext pageContext) {
        logger.config("<document>");
        this.renderer.startedDocument(pageContext);
    }

    @Override
    public void startedFlow(LayoutContext layoutContext) throws NormalizationException {
        logger.config("<flow tag='" + layoutContext.getTagName() + "'>");
        this.renderer.startedFlow(layoutContext);
    }

    @Override
    public void startedTable(LayoutContext layoutContext) throws NormalizationException {
        logger.config("<table>");
        this.renderer.startedTable(layoutContext);
    }

    @Override
    public void startedTableColumnGroup(LayoutContext layoutContext) throws NormalizationException {
        logger.config("<table-col-group>");
        this.renderer.startedTableColumnGroup(layoutContext);
    }

    @Override
    public void startedTableColumn(LayoutContext layoutContext) throws NormalizationException {
        logger.config("<table-col>");
        this.renderer.startedTableColumn(layoutContext);
    }

    @Override
    public void startedTableSection(LayoutContext layoutContext) throws NormalizationException {
        logger.config("<table-section>");
        this.renderer.startedTableSection(layoutContext);
    }

    @Override
    public void startedTableRow(LayoutContext layoutContext) throws NormalizationException {
        logger.config("<table-row>");
        this.renderer.startedTableRow(layoutContext);
    }

    @Override
    public void startedTableCell(LayoutContext layoutContext) throws NormalizationException {
        logger.config("<table-cell>");
        this.renderer.startedTableCell(layoutContext);
    }

    @Override
    public void startedBlock(LayoutContext layoutContext) throws NormalizationException {
        String string = layoutContext.getTagName();
        logger.config("<block tag='" + string + "'>");
        this.renderer.startedBlock(layoutContext);
    }

    @Override
    public void startedRootInline(LayoutContext layoutContext) throws NormalizationException {
        String string = layoutContext.getTagName();
        logger.config("<paragraph tag='" + string + "'>");
        this.renderer.startedRootInline(layoutContext);
    }

    @Override
    public void startedMarker(LayoutContext layoutContext) throws NormalizationException {
        logger.config("<marker>");
        this.renderer.startedMarker(layoutContext);
    }

    @Override
    public void startedInline(LayoutContext layoutContext) throws NormalizationException {
        String string = layoutContext.getTagName();
        logger.config("<inline tag='" + string + "'>");
        this.renderer.startedInline(layoutContext);
    }

    @Override
    public void addContent(LayoutContext layoutContext, ContentToken contentToken) throws NormalizationException {
        logger.config("<content>" + contentToken + "</content>");
        this.renderer.addContent(layoutContext, contentToken);
    }

    @Override
    public void finishedInline() throws NormalizationException {
        logger.config("</inline>");
        this.renderer.finishedInline();
    }

    @Override
    public void finishedMarker() throws NormalizationException {
        logger.config("</marker>");
        this.renderer.finishedMarker();
    }

    @Override
    public void finishedRootInline() throws NormalizationException {
        logger.config("</paragraph>");
        this.renderer.finishedRootInline();
    }

    @Override
    public void finishedBlock() throws NormalizationException {
        logger.config("</block>");
        this.renderer.finishedBlock();
    }

    @Override
    public void finishedTableCell() throws NormalizationException {
        logger.config("</table-cell>");
        this.renderer.finishedTableCell();
    }

    @Override
    public void finishedTableRow() throws NormalizationException {
        logger.config("</table-row>");
        this.renderer.finishedTableRow();
    }

    @Override
    public void finishedTableSection() throws NormalizationException {
        logger.config("</table-section>");
        this.renderer.finishedTableSection();
    }

    @Override
    public void finishedTableColumn() throws NormalizationException {
        logger.config("</table-col>");
        this.renderer.finishedTableColumn();
    }

    @Override
    public void finishedTableColumnGroup() throws NormalizationException {
        logger.config("</table-col-group>");
        this.renderer.finishedTableColumnGroup();
    }

    @Override
    public void finishedTable() throws NormalizationException {
        logger.config("</table>");
        this.renderer.finishedTable();
    }

    @Override
    public void finishedFlow() throws NormalizationException {
        logger.config("</flow>");
        this.renderer.finishedFlow();
    }

    @Override
    public void finishedDocument() throws NormalizationException {
        logger.config("</document>");
        this.renderer.finishedDocument();
    }

    @Override
    public State saveState() throws StateException {
        return new PrintContentGeneratorState(this.renderer.saveState());
    }

    @Override
    public void handlePageBreak(PageContext pageContext) {
        this.renderer.handlePageBreak(pageContext);
    }

    @Override
    public void startedPassThrough(LayoutContext layoutContext) throws NormalizationException {
        logger.config("<pass-through>");
        this.renderer.startedPassThrough(layoutContext);
    }

    @Override
    public void addPassThroughContent(LayoutContext layoutContext, ContentToken contentToken) throws NormalizationException {
        logger.config("<pass-through-content>" + contentToken + "</pass-through-content>");
        this.renderer.addPassThroughContent(layoutContext, contentToken);
    }

    @Override
    public void finishedPassThrough() throws NormalizationException {
        logger.config("</pass-through>");
        this.renderer.finishedPassThrough();
    }

    @Override
    public void startedTableCaption(LayoutContext layoutContext) throws NormalizationException {
        logger.config("<table-caption>");
        this.renderer.startedTableCaption(layoutContext);
    }

    @Override
    public void finishedTableCaption() throws NormalizationException {
        logger.config("</table-caption>");
        this.renderer.finishedTableCaption();
    }

    @Override
    public Renderer getRenderer() {
        return this.renderer;
    }

    private static class PrintContentGeneratorState
    implements State {
        private State renderer;

        private PrintContentGeneratorState(State state) {
            this.renderer = state;
        }

        @Override
        public StatefullComponent restore(LayoutProcess layoutProcess) throws StateException {
            Renderer renderer = (Renderer)this.renderer.restore(layoutProcess);
            return new PrintContentGenerator(renderer);
        }
    }
}

