/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.api.resource;

import com.nimbusds.oauth2.sdk.ParseException;
import jakarta.annotation.Nullable;
import jakarta.annotation.security.PermitAll;
import jakarta.inject.Inject;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.FormParam;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.net.URI;
import java.security.GeneralSecurityException;
import java.util.Date;
import org.traccar.api.BaseResource;
import org.traccar.api.security.CodeRequiredException;
import org.traccar.api.security.LoginResult;
import org.traccar.api.security.LoginService;
import org.traccar.api.signature.TokenManager;
import org.traccar.database.OpenIdProvider;
import org.traccar.helper.LogAction;
import org.traccar.helper.SessionHelper;
import org.traccar.model.RevokedToken;
import org.traccar.model.User;
import org.traccar.storage.StorageException;
import org.traccar.storage.query.Columns;
import org.traccar.storage.query.Condition;
import org.traccar.storage.query.Request;

@Path(value="session")
@Produces(value={"application/json"})
@Consumes(value={"application/x-www-form-urlencoded"})
public class SessionResource
extends BaseResource {
    @Inject
    private LoginService loginService;
    @Inject
    @Nullable
    private OpenIdProvider openIdProvider;
    @Inject
    private TokenManager tokenManager;
    @Inject
    private LogAction actionLogger;
    @Context
    private HttpServletRequest request;

    @PermitAll
    @GET
    public User get(@QueryParam(value="token") String token) throws StorageException, IOException, GeneralSecurityException {
        User user;
        LoginResult loginResult;
        if (token != null && (loginResult = this.loginService.login(token)) != null) {
            User user2 = loginResult.getUser();
            SessionHelper.userLogin(this.actionLogger, this.request, user2, loginResult.getExpiration());
            return user2;
        }
        Long userId = (Long)this.request.getSession().getAttribute("userId");
        if (userId != null && (user = this.permissionsService.getUser(userId)) != null) {
            return user;
        }
        throw new WebApplicationException(Response.status((Response.Status)Response.Status.NOT_FOUND).build());
    }

    @Path(value="{id}")
    @GET
    public User get(@PathParam(value="id") long userId) throws StorageException {
        this.permissionsService.checkUser(this.getUserId(), userId);
        User user = this.storage.getObject(User.class, new Request((Columns)new Columns.All(), new Condition.Equals("id", userId)));
        SessionHelper.userLogin(this.actionLogger, this.request, user, null);
        return user;
    }

    @PermitAll
    @POST
    public User add(@FormParam(value="email") String email, @FormParam(value="password") String password, @FormParam(value="code") Integer code) throws StorageException {
        LoginResult loginResult;
        try {
            loginResult = this.loginService.login(email, password, code);
        }
        catch (CodeRequiredException e) {
            Response response = Response.status((Response.Status)Response.Status.UNAUTHORIZED).header("WWW-Authenticate", (Object)"TOTP").build();
            throw new WebApplicationException(response);
        }
        if (loginResult != null) {
            User user = loginResult.getUser();
            SessionHelper.userLogin(this.actionLogger, this.request, user, null);
            return user;
        }
        this.actionLogger.failedLogin(this.request);
        throw new WebApplicationException(Response.status((Response.Status)Response.Status.UNAUTHORIZED).build());
    }

    @DELETE
    public Response remove() {
        this.actionLogger.logout(this.request, this.getUserId());
        this.request.getSession().removeAttribute("userId");
        return Response.noContent().build();
    }

    @Path(value="token")
    @POST
    public String requestToken(@FormParam(value="expiration") Date expiration) throws StorageException, GeneralSecurityException, IOException {
        Date currentExpiration = (Date)this.request.getSession().getAttribute("expiration");
        if (currentExpiration != null && currentExpiration.before(expiration)) {
            expiration = currentExpiration;
        }
        String token = this.tokenManager.generateToken(this.getUserId(), expiration);
        TokenManager.TokenData data = this.tokenManager.decodeToken(token);
        this.actionLogger.token(this.request, this.getUserId(), data.getId());
        return token;
    }

    @Path(value="token/revoke")
    @POST
    public Response revokeToken(@FormParam(value="token") String token) throws StorageException, GeneralSecurityException, IOException {
        TokenManager.TokenData data = this.tokenManager.decodeToken(token);
        RevokedToken revokedToken = new RevokedToken();
        revokedToken.setId(data.getId());
        this.storage.addObject(revokedToken, new Request(new Columns.Include("id")));
        return Response.noContent().build();
    }

    @PermitAll
    @Path(value="openid/auth")
    @GET
    public Response openIdAuth() {
        if (this.openIdProvider == null) {
            throw new UnsupportedOperationException("OpenID not enabled");
        }
        return Response.seeOther((URI)this.openIdProvider.createAuthUri()).build();
    }

    @PermitAll
    @Path(value="openid/callback")
    @GET
    public Response requestToken() throws IOException, StorageException, ParseException, GeneralSecurityException {
        if (this.openIdProvider == null) {
            throw new UnsupportedOperationException("OpenID not enabled");
        }
        return Response.seeOther((URI)this.openIdProvider.handleCallback(this.request.getQueryString(), this.request)).build();
    }
}

