/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.client.impl;

import net.i2p.I2PAppContext;
import net.i2p.client.impl.I2PSessionImpl;
import net.i2p.client.impl.RequestLeaseSetMessageHandler;
import net.i2p.data.DataHelper;
import net.i2p.data.EncryptedLeaseSet;
import net.i2p.data.Lease;
import net.i2p.data.Lease2;
import net.i2p.data.LeaseSet;
import net.i2p.data.LeaseSet2;
import net.i2p.data.MetaLease;
import net.i2p.data.MetaLeaseSet;
import net.i2p.data.i2cp.I2CPMessage;
import net.i2p.data.i2cp.RequestVariableLeaseSetMessage;
import net.i2p.util.OrderedProperties;

class RequestVariableLeaseSetMessageHandler
extends RequestLeaseSetMessageHandler {
    public RequestVariableLeaseSetMessageHandler(I2PAppContext context) {
        super(context, 37);
    }

    @Override
    public void handleMessage(I2CPMessage message, I2PSessionImpl session) {
        LeaseSet leaseSet;
        if (this._log.shouldLog(10)) {
            this._log.debug("Handle message " + message);
        }
        RequestVariableLeaseSetMessage msg = (RequestVariableLeaseSetMessage)message;
        boolean isLS2 = this.requiresLS2(session);
        if (isLS2) {
            String v;
            LeaseSet2 ls2;
            if (this._ls2Type == 3) {
                ls2 = new LeaseSet2();
            } else if (this._ls2Type == 5) {
                ls2 = new EncryptedLeaseSet();
            } else if (this._ls2Type == 7) {
                ls2 = new MetaLeaseSet();
            } else {
                session.propogateError("Unsupported LS2 type", new Exception());
                session.destroySession();
                return;
            }
            if (Boolean.parseBoolean(session.getOptions().getProperty("i2cp.dontPublishLeaseSet"))) {
                ls2.setUnpublished();
            }
            String k = "i2cp.leaseSetOption.0";
            OrderedProperties props = null;
            for (int i = 0; i < 10 && (v = session.getOptions().getProperty(k)) != null; ++i) {
                String[] vs = DataHelper.split(v, "=", 2);
                if (vs.length < 2) continue;
                if (props == null) {
                    props = new OrderedProperties();
                }
                props.setProperty(vs[0], vs[1]);
                k = "i2cp.leaseSetOption." + (i + 1);
            }
            if (props != null) {
                ls2.setOptions(props);
            }
            long now = Math.max(this._context.clock().now(), session.getLastLS2SignTime() + 1000L);
            ls2.setPublished(now);
            session.setLastLS2SignTime(now);
            leaseSet = ls2;
        } else {
            leaseSet = new LeaseSet();
        }
        for (int i = 0; i < msg.getEndpoints(); ++i) {
            Lease lease;
            if (isLS2) {
                Lease old = msg.getEndpoint(i);
                if (this._ls2Type == 7) {
                    lease = new MetaLease();
                } else {
                    lease = new Lease2();
                    lease.setTunnelId(old.getTunnelId());
                }
                lease.setGateway(old.getGateway());
                lease.setEndDate(old.getEndTime());
            } else {
                lease = msg.getEndpoint(i);
            }
            leaseSet.addLease(lease);
        }
        this.signLeaseSet(leaseSet, isLS2, session);
    }
}

