/*
 * Decompiled with CFR 0.152.
 */
package jdk.jfr.internal;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.annotation.Repeatable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import jdk.jfr.AnnotationElement;
import jdk.jfr.Description;
import jdk.jfr.Event;
import jdk.jfr.Label;
import jdk.jfr.MetadataDefinition;
import jdk.jfr.Name;
import jdk.jfr.SettingDescriptor;
import jdk.jfr.Timespan;
import jdk.jfr.Timestamp;
import jdk.jfr.ValueDescriptor;
import jdk.jfr.internal.Control;
import jdk.jfr.internal.LogLevel;
import jdk.jfr.internal.LogTag;
import jdk.jfr.internal.Logger;
import jdk.jfr.internal.MetadataHandler;
import jdk.jfr.internal.PlatformEventType;
import jdk.jfr.internal.PrivateAccess;
import jdk.jfr.internal.SecuritySupport;
import jdk.jfr.internal.Type;
import jdk.jfr.internal.Utils;

public final class TypeLibrary {
    private static TypeLibrary instance;
    private static final Map<Long, Type> types;
    static final ValueDescriptor DURATION_FIELD;
    static final ValueDescriptor THREAD_FIELD;
    static final ValueDescriptor STACK_TRACE_FIELD;
    static final ValueDescriptor START_TIME_FIELD;

    private TypeLibrary(List<Type> list) {
        TypeLibrary.visitReachable(list, type -> !types.containsKey(type.getId()), type -> types.put(type.getId(), (Type)type));
        if (Logger.shouldLog(LogTag.JFR_SYSTEM_METADATA, LogLevel.INFO)) {
            Stream<Type> stream = types.values().stream().sorted((type, type2) -> Long.compare(type.getId(), type2.getId()));
            stream.forEach(type -> type.log("Added", LogTag.JFR_SYSTEM_METADATA, LogLevel.INFO));
        }
    }

    private static ValueDescriptor createStartTimeField() {
        List<AnnotationElement> list = TypeLibrary.createStandardAnnotations("Start Time", null);
        list.add(new AnnotationElement(Timestamp.class, "TICKS"));
        return PrivateAccess.getInstance().newValueDescriptor("startTime", Type.LONG, list, 0, false, "startTime");
    }

    private static ValueDescriptor createStackTraceField() {
        ArrayList<AnnotationElement> arrayList = new ArrayList();
        arrayList = TypeLibrary.createStandardAnnotations("Stack Trace", "Stack Trace starting from the method the event was committed in");
        return PrivateAccess.getInstance().newValueDescriptor("stackTrace", Type.STACK_TRACE, arrayList, 0, true, "stackTrace");
    }

    private static ValueDescriptor createThreadField() {
        ArrayList<AnnotationElement> arrayList = new ArrayList();
        arrayList = TypeLibrary.createStandardAnnotations("Event Thread", "Thread in which event was committed in");
        return PrivateAccess.getInstance().newValueDescriptor("eventThread", Type.THREAD, arrayList, 0, true, "eventThread");
    }

    private static ValueDescriptor createDurationField() {
        List<Object> list = new ArrayList();
        list = TypeLibrary.createStandardAnnotations("Duration", null);
        list.add(new AnnotationElement(Timespan.class, "TICKS"));
        return PrivateAccess.getInstance().newValueDescriptor("duration", Type.LONG, list, 0, false, "duration");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TypeLibrary getInstance() {
        Class<TypeLibrary> clazz = TypeLibrary.class;
        synchronized (TypeLibrary.class) {
            if (instance == null) {
                List<Type> list;
                try {
                    list = MetadataHandler.createTypes();
                    Collections.sort(list, (type, type2) -> Long.compare(type.getId(), type2.getId()));
                }
                catch (IOException iOException) {
                    throw new Error("JFR: Could not read metadata");
                }
                instance = new TypeLibrary(list);
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public List<Type> getTypes() {
        return new ArrayList<Type>(types.values());
    }

    public static Type createAnnotationType(Class<? extends Annotation> clazz) {
        if (TypeLibrary.shouldPersist(clazz)) {
            Type type = TypeLibrary.defineType(clazz, Type.SUPER_TYPE_ANNOTATION, false);
            if (type != null) {
                SecuritySupport.makeVisibleToJFR(clazz);
                for (Method object : clazz.getDeclaredMethods()) {
                    type.add(PrivateAccess.getInstance().newValueDescriptor(object.getReturnType(), object.getName()));
                }
                ArrayList arrayList = new ArrayList();
                for (Annotation annotation : TypeLibrary.resolveRepeatedAnnotations(clazz.getAnnotations())) {
                    AnnotationElement annotationElement = TypeLibrary.createAnnotation(annotation);
                    if (annotationElement == null) continue;
                    arrayList.add(annotationElement);
                }
                arrayList.trimToSize();
                type.setAnnotations(arrayList);
            }
            return TypeLibrary.getType(clazz);
        }
        return null;
    }

    static AnnotationElement createAnnotation(Annotation annotation) {
        Class<? extends Annotation> clazz = annotation.annotationType();
        Type type = TypeLibrary.createAnnotationType(clazz);
        if (type != null) {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            for (ValueDescriptor valueDescriptor : type.getFields()) {
                arrayList.add(TypeLibrary.invokeAnnotation(annotation, valueDescriptor.getName()));
            }
            return PrivateAccess.getInstance().newAnnotation(type, arrayList, annotation.annotationType().getClassLoader() == null);
        }
        return null;
    }

    private static Object invokeAnnotation(Annotation annotation, String string) {
        Method method;
        try {
            method = annotation.getClass().getMethod(string, new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new InternalError("Could not loacate method " + string + " in annotation " + annotation.getClass().getName());
        }
        SecuritySupport.setAccessible(method);
        try {
            return method.invoke((Object)annotation, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exception) {
            throw new InternalError("Could not get value for method " + string + " in annotation " + annotation.getClass().getName());
        }
    }

    private static boolean shouldPersist(Class<? extends Annotation> clazz) {
        return clazz != MetadataDefinition.class && clazz.getAnnotation(MetadataDefinition.class) != null;
    }

    private static boolean isDefined(Class<?> clazz) {
        return types.containsKey(Type.getTypeId(clazz));
    }

    private static Type getType(Class<?> clazz) {
        return types.get(Type.getTypeId(clazz));
    }

    private static Type defineType(Class<?> clazz, String string, boolean bl) {
        if (!TypeLibrary.isDefined(clazz)) {
            Name name = clazz.getAnnotation(Name.class);
            String string2 = name != null ? name.value() : clazz.getName();
            long l = Type.getTypeId(clazz);
            Type type = bl ? new PlatformEventType(string2, l, clazz.getClassLoader() == null, true) : new Type(string2, string, l);
            types.put(type.getId(), type);
            return type;
        }
        return null;
    }

    public static Type createType(Class<?> clazz) {
        return TypeLibrary.createType(clazz, Collections.emptyList(), Collections.emptyList());
    }

    public static Type createType(Class<?> clazz, List<AnnotationElement> list, List<ValueDescriptor> list2) {
        if (Thread.class == clazz) {
            return Type.THREAD;
        }
        if (Class.class.isAssignableFrom(clazz)) {
            return Type.CLASS;
        }
        if (String.class.equals(clazz)) {
            return Type.STRING;
        }
        if (TypeLibrary.isDefined(clazz)) {
            return TypeLibrary.getType(clazz);
        }
        if (clazz.isPrimitive()) {
            return TypeLibrary.defineType(clazz, null, false);
        }
        if (clazz.isArray()) {
            throw new InternalError("Arrays not supported");
        }
        String string = null;
        boolean bl = false;
        if (Event.class.isAssignableFrom(clazz)) {
            string = Type.SUPER_TYPE_EVENT;
            bl = true;
        }
        if (Control.class.isAssignableFrom(clazz)) {
            string = Type.SUPER_TYPE_SETTING;
        }
        TypeLibrary.defineType(clazz, string, bl);
        Type type = TypeLibrary.getType(clazz);
        if (bl) {
            TypeLibrary.addImplicitFields(type, true, true, true, true, false);
            TypeLibrary.addUserFields(clazz, type, list2);
            type.trimFields();
        }
        TypeLibrary.addAnnotations(clazz, type, list);
        if (clazz.getClassLoader() == null) {
            type.log("Added", LogTag.JFR_SYSTEM_METADATA, LogLevel.INFO);
        } else {
            type.log("Added", LogTag.JFR_METADATA, LogLevel.INFO);
        }
        return type;
    }

    private static void addAnnotations(Class<?> clazz, Type type, List<AnnotationElement> list) {
        ArrayList<AnnotationElement> arrayList = new ArrayList<AnnotationElement>();
        if (list.isEmpty()) {
            for (Annotation annotation : Utils.getAnnotations(clazz)) {
                AnnotationElement annotationElement = TypeLibrary.createAnnotation(annotation);
                if (annotationElement == null) continue;
                arrayList.add(annotationElement);
            }
        } else {
            ArrayList<Type> arrayList2 = new ArrayList<Type>();
            arrayList.addAll(list);
            for (AnnotationElement annotationElement : list) {
                arrayList2.add(PrivateAccess.getInstance().getType(annotationElement));
            }
            TypeLibrary.addTypes(arrayList2);
        }
        type.setAnnotations(arrayList);
        arrayList.trimToSize();
    }

    private static void addUserFields(Class<?> clazz, Type type, List<ValueDescriptor> list) {
        HashMap<String, ValueDescriptor> hashMap = new HashMap<String, ValueDescriptor>();
        for (ValueDescriptor object : list) {
            hashMap.put(object.getName(), object);
        }
        ArrayList arrayList = new ArrayList();
        for (Field field : Utils.getVisibleEventFields(clazz)) {
            ValueDescriptor valueDescriptor = (ValueDescriptor)hashMap.get(field.getName());
            if (valueDescriptor != null) {
                if (!valueDescriptor.getTypeName().equals(field.getType().getName())) {
                    throw new InternalError("Type expected to match for field " + valueDescriptor.getName() + " expected " + field.getName() + " but got " + valueDescriptor.getName());
                }
                for (AnnotationElement annotationElement : valueDescriptor.getAnnotationElements()) {
                    arrayList.add(PrivateAccess.getInstance().getType(annotationElement));
                }
                arrayList.add(PrivateAccess.getInstance().getType(valueDescriptor));
            } else {
                valueDescriptor = TypeLibrary.createField(field);
            }
            if (valueDescriptor == null) continue;
            type.add(valueDescriptor);
        }
        TypeLibrary.addTypes(arrayList);
    }

    static void addImplicitFields(Type type, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        TypeLibrary.createAnnotationType(Timespan.class);
        TypeLibrary.createAnnotationType(Timestamp.class);
        TypeLibrary.createAnnotationType(Label.class);
        TypeLibrary.defineType(Long.TYPE, null, false);
        TypeLibrary.addFields(type, bl, bl2, bl3, bl4, bl5);
    }

    private static void addFields(Type type, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        type.add(START_TIME_FIELD);
        if (bl2 || bl5) {
            type.add(DURATION_FIELD);
        }
        if (bl3) {
            type.add(THREAD_FIELD);
        }
        if (bl4) {
            type.add(STACK_TRACE_FIELD);
        }
    }

    private static List<AnnotationElement> createStandardAnnotations(String string, String string2) {
        ArrayList<AnnotationElement> arrayList = new ArrayList<AnnotationElement>(2);
        arrayList.add(new AnnotationElement(Label.class, string));
        if (string2 != null) {
            arrayList.add(new AnnotationElement(Description.class, string2));
        }
        return arrayList;
    }

    private static ValueDescriptor createField(Field field) {
        int n = field.getModifiers();
        if (Modifier.isTransient(n)) {
            return null;
        }
        if (Modifier.isStatic(n)) {
            return null;
        }
        Class<?> clazz = field.getType();
        if (!Type.isKnownType(clazz)) {
            return null;
        }
        boolean bl = Thread.class == clazz || clazz == Class.class;
        Type type = TypeLibrary.createType(clazz);
        String string = field.getName();
        Name name = field.getAnnotation(Name.class);
        String string2 = string;
        if (name != null) {
            string2 = name.value();
        }
        ArrayList<AnnotationElement> arrayList = new ArrayList<AnnotationElement>();
        for (Annotation annotation : TypeLibrary.resolveRepeatedAnnotations(field.getAnnotations())) {
            AnnotationElement annotationElement = TypeLibrary.createAnnotation(annotation);
            if (annotationElement == null) continue;
            arrayList.add(annotationElement);
        }
        return PrivateAccess.getInstance().newValueDescriptor(string2, type, arrayList, 0, bl, string);
    }

    private static List<Annotation> resolveRepeatedAnnotations(Annotation[] annotationArray) {
        ArrayList<Annotation> arrayList = new ArrayList<Annotation>(annotationArray.length);
        for (Annotation annotation : annotationArray) {
            boolean bl = false;
            try {
                Object object;
                Class<?> clazz;
                Method method = annotation.annotationType().getMethod("value", new Class[0]);
                Class<?> clazz2 = method.getReturnType();
                if (clazz2.isArray() && Annotation.class.isAssignableFrom(clazz = clazz2.getComponentType()) && clazz.getAnnotation(Repeatable.class) != null && (object = method.invoke((Object)annotation, new Object[0])) != null && Annotation[].class.isAssignableFrom(object.getClass())) {
                    for (Annotation annotation2 : (Annotation[])method.invoke((Object)annotation, new Object[0])) {
                        arrayList.add(annotation2);
                    }
                    bl = true;
                }
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
                // empty catch block
            }
            if (bl) continue;
            arrayList.add(annotation);
        }
        return arrayList;
    }

    public boolean clearUnregistered() {
        Logger.log(LogTag.JFR_METADATA, LogLevel.TRACE, "Cleaning out obsolete metadata");
        ArrayList<Type> arrayList = new ArrayList<Type>();
        for (Type object2 : types.values()) {
            if (!(object2 instanceof PlatformEventType) || !((PlatformEventType)object2).isRegistered()) continue;
            arrayList.add(object2);
        }
        TypeLibrary.visitReachable(arrayList, type -> type.getRemove(), type -> type.setRemove(false));
        ArrayList arrayList2 = new ArrayList();
        for (Type type2 : types.values()) {
            if (type2.getRemove() && !Type.isDefinedByJVM(type2.getId())) {
                arrayList2.add(type2.getId());
                if (Logger.shouldLog(LogTag.JFR_METADATA, LogLevel.TRACE)) {
                    Logger.log(LogTag.JFR_METADATA, LogLevel.TRACE, "Removed obsolete metadata " + type2.getName());
                }
            }
            type2.setRemove(true);
        }
        Iterator iterator = arrayList2.iterator();
        while (iterator.hasNext()) {
            Long l = (Long)iterator.next();
            types.remove(l);
        }
        return !arrayList2.isEmpty();
    }

    public void addType(Type type) {
        TypeLibrary.addTypes(Collections.singletonList(type));
    }

    public static void addTypes(List<Type> list) {
        if (!list.isEmpty()) {
            TypeLibrary.visitReachable(list, type -> !types.containsKey(type.getId()), type -> types.put(type.getId(), (Type)type));
        }
    }

    private static void visitReachable(Collection<Type> collection, Predicate<Type> predicate, Consumer<Type> consumer) {
        ArrayDeque<Type> arrayDeque = new ArrayDeque<Type>(collection);
        while (!arrayDeque.isEmpty()) {
            Type type = (Type)arrayDeque.poll();
            if (!predicate.test(type)) continue;
            consumer.accept(type);
            TypeLibrary.visitAnnotations(arrayDeque, type.getAnnotationElements());
            for (ValueDescriptor valueDescriptor : type.getFields()) {
                arrayDeque.add(PrivateAccess.getInstance().getType(valueDescriptor));
                TypeLibrary.visitAnnotations(arrayDeque, valueDescriptor.getAnnotationElements());
            }
            if (!(type instanceof PlatformEventType)) continue;
            PlatformEventType platformEventType = (PlatformEventType)type;
            for (SettingDescriptor settingDescriptor : platformEventType.getAllSettings()) {
                arrayDeque.add(PrivateAccess.getInstance().getType(settingDescriptor));
                TypeLibrary.visitAnnotations(arrayDeque, settingDescriptor.getAnnotationElements());
            }
        }
    }

    private static void visitAnnotations(Queue<Type> queue, List<AnnotationElement> list) {
        ArrayDeque<AnnotationElement> arrayDeque = new ArrayDeque<AnnotationElement>(list);
        HashSet<AnnotationElement> hashSet = new HashSet<AnnotationElement>();
        while (!arrayDeque.isEmpty()) {
            AnnotationElement annotationElement = (AnnotationElement)arrayDeque.poll();
            if (!hashSet.contains(annotationElement)) {
                Type type = PrivateAccess.getInstance().getType(annotationElement);
                queue.add(type);
                hashSet.add(annotationElement);
            }
            arrayDeque.addAll(annotationElement.getAnnotationElements());
        }
    }

    static {
        types = new LinkedHashMap<Long, Type>(100);
        DURATION_FIELD = TypeLibrary.createDurationField();
        THREAD_FIELD = TypeLibrary.createThreadField();
        STACK_TRACE_FIELD = TypeLibrary.createStackTraceField();
        START_TIME_FIELD = TypeLibrary.createStartTimeField();
    }
}

