/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.build;

import aQute.bnd.build.Project;
import aQute.bnd.build.Workspace;
import aQute.bnd.exceptions.Exceptions;
import aQute.lib.io.IO;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

class ProjectTracker
implements AutoCloseable {
    private final Workspace workspace;
    private final Map<String, Project> models;
    private Collection<Project> lastUpdate = new ArrayList<Project>();
    private boolean changed = true;

    ProjectTracker(Workspace workspace) {
        this.workspace = workspace;
        this.models = new HashMap<String, Project>();
    }

    @Override
    public synchronized void close() {
        this.models.values().forEach(IO::close);
    }

    synchronized void refresh() {
        this.changed = true;
    }

    synchronized Set<Project> getAllProjects() {
        this.update();
        return new HashSet<Project>(this.models.values());
    }

    synchronized Optional<Project> getProject(String name) {
        this.update();
        if (!this.models.containsKey(name) && this.workspace.getFile(name + "/" + "bnd.bnd").isFile()) {
            this.changed = true;
            this.update();
        }
        return Optional.ofNullable(this.models.get(name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void update() {
        if (!this.changed) {
            return;
        }
        this.changed = false;
        try {
            Path base = this.workspace.getBase().toPath();
            HashSet<String> older = new HashSet<String>(this.models.keySet());
            try (DirectoryStream<Path> directories = Files.newDirectoryStream(base, x$0 -> Files.isDirectory(x$0, new LinkOption[0]));){
                for (Path directory : directories) {
                    this.models.compute(directory.getFileName().toString(), (name, project) -> {
                        if (project != null) {
                            older.remove(name);
                            if (directory.equals(project.getBase().toPath()) && project.isValid()) {
                                return project;
                            }
                            IO.close(project);
                        }
                        if (Files.isRegularFile(directory.resolve(Project.BNDPATH), new LinkOption[0])) {
                            project = new Project(this.workspace, directory.toFile());
                            if (project.isValid()) {
                                return project;
                            }
                            IO.close(project);
                        }
                        return null;
                    });
                }
            }
            catch (IOException e) {
                throw Exceptions.duck(e);
            }
            older.stream().map(this.models::remove).forEach(IO::close);
        }
        finally {
            Collection<Project> newSet = this.models.values();
            this.lastUpdate = newSet;
            this.workspace.notifier.projects(this.lastUpdate);
        }
    }

    public String toString() {
        return this.models.keySet().toString();
    }

    synchronized void forceRefresh() {
        this.changed = true;
        this.update();
    }
}

