/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.util.regex.Pattern;
import org.traccar.BaseProtocolDecoder;
import org.traccar.Protocol;
import org.traccar.helper.Parser;
import org.traccar.helper.PatternBuilder;
import org.traccar.helper.UnitsConverter;
import org.traccar.model.Position;
import org.traccar.session.DeviceSession;

public class JidoProtocolDecoder
extends BaseProtocolDecoder {
    private static final Pattern PATTERN = new PatternBuilder().text("*").number("(d+),").number("(d+),").expression("([AV]),").optional().number("(dd)(dd)(dd),").number("(dd)(dd)(dd),").number("(d+)(dd.d+),").expression("([NS]),").number("(d+)(dd.d+),").expression("([EW]),").groupBegin().number("(d+),").number("(d+),").number("(d+),").number("(-?d+),").number("(d+),").number("d+,").number("d+,").number("([01]),").number("(d+),").expression("([YKN]),").number("([01]),").number("[^,]+,").number("[^,]+,").number("[^,]+,").or().expression("[^,]*,").groupEnd().number("xx").compile();

    public JidoProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    private String decodeAlarm(int type) {
        return switch (type) {
            case 3 -> "lowBattery";
            case 4 -> "tampering";
            default -> null;
        };
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        Parser parser = new Parser(PATTERN, (String)msg);
        if (!parser.matches()) {
            return null;
        }
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, parser.next());
        if (deviceSession == null) {
            return null;
        }
        Position position = new Position(this.getProtocolName());
        position.setDeviceId(deviceSession.getDeviceId());
        position.addAlarm(this.decodeAlarm(parser.nextInt()));
        if (parser.hasNext()) {
            position.setValid(parser.next().equals("A"));
        } else {
            position.setValid(true);
        }
        position.setTime(parser.nextDateTime(Parser.DateTimeFormat.DMY_HMS));
        position.setLatitude(parser.nextCoordinate());
        position.setLongitude(parser.nextCoordinate());
        if (parser.hasNext(9)) {
            position.setSpeed(UnitsConverter.knotsFromKph(parser.nextInt().intValue()));
            position.set("odometer", parser.nextInt());
            position.setCourse(parser.nextInt().intValue());
            position.setAltitude(parser.nextInt().intValue());
            position.set("sat", parser.nextInt());
            position.set("charge", parser.nextInt() > 0);
            position.set("batteryLevel", parser.nextInt());
            position.set("mode", parser.next());
            position.set("blocked", parser.nextInt() > 0);
        }
        return position;
    }
}

