/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.web;

import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.Writer;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.traccar.api.security.OidcSessionManager;
import org.traccar.config.Config;
import org.traccar.helper.WebHelper;

@Singleton
public class WellKnownServlet
extends HttpServlet {
    private final Config config;
    private final ObjectMapper objectMapper;

    @Inject
    public WellKnownServlet(Config config, ObjectMapper objectMapper) {
        this.config = config;
        this.objectMapper = objectMapper;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        Map<String, Object> payload;
        String path;
        switch (path = req.getPathInfo()) {
            case "/openid-configuration": {
                Map<String, Object> map = this.openIdConfiguration();
                break;
            }
            case "/oauth-authorization-server": {
                Map<String, Object> map = this.authorizationServerConfiguration();
                break;
            }
            case "/oauth-protected-resource": {
                Map<String, Object> map = this.protectedResourceConfiguration();
                break;
            }
            default: {
                Map<String, Object> map = payload = null;
            }
        }
        if (payload != null) {
            resp.setContentType("application/json");
            this.objectMapper.writeValue((Writer)resp.getWriter(), payload);
        } else {
            resp.sendError(404);
        }
    }

    private String issuer() {
        return WebHelper.retrieveWebUrl(this.config) + "/api/oidc";
    }

    private String mcpResource() {
        return WebHelper.retrieveWebUrl(this.config) + "/api/mcp";
    }

    private Map<String, Object> openIdConfiguration() {
        String issuer = this.issuer();
        LinkedHashMap<String, Object> payload = new LinkedHashMap<String, Object>();
        payload.put("issuer", issuer);
        payload.put("authorization_endpoint", issuer + "/authorize");
        payload.put("token_endpoint", issuer + "/token");
        payload.put("userinfo_endpoint", issuer + "/userinfo");
        payload.put("jwks_uri", issuer + "/jwks");
        payload.put("subject_types_supported", List.of("public"));
        payload.put("response_types_supported", List.of("code"));
        payload.put("grant_types_supported", List.of("authorization_code"));
        payload.put("scopes_supported", List.of("openid", "profile", "email"));
        payload.put("id_token_signing_alg_values_supported", List.of(OidcSessionManager.ID_TOKEN_ALGORITHM));
        payload.put("code_challenge_methods_supported", List.of("S256", "plain"));
        payload.put("token_endpoint_auth_methods_supported", List.of("client_secret_basic", "client_secret_post", "none"));
        return payload;
    }

    private Map<String, Object> authorizationServerConfiguration() {
        String issuer = this.issuer();
        LinkedHashMap<String, Object> payload = new LinkedHashMap<String, Object>();
        payload.put("issuer", issuer);
        payload.put("authorization_endpoint", issuer + "/authorize");
        payload.put("token_endpoint", issuer + "/token");
        payload.put("jwks_uri", issuer + "/jwks");
        payload.put("response_types_supported", List.of("code"));
        payload.put("grant_types_supported", List.of("authorization_code"));
        payload.put("scopes_supported", List.of("openid", "profile", "email"));
        payload.put("code_challenge_methods_supported", List.of("S256", "plain"));
        payload.put("token_endpoint_auth_methods_supported", List.of("client_secret_basic", "client_secret_post", "none"));
        return payload;
    }

    private Map<String, Object> protectedResourceConfiguration() {
        LinkedHashMap<String, Object> payload = new LinkedHashMap<String, Object>();
        payload.put("issuer", this.issuer());
        payload.put("authorization_servers", List.of(this.issuer()));
        payload.put("jwks_uri", this.issuer() + "/jwks");
        payload.put("scopes_supported", List.of("openid", "profile", "email"));
        payload.put("resource", this.mcpResource());
        return payload;
    }
}

