/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.gotosource.viewer.internal;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.prefs.Preferences;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.SpinnerNumberModel;
import javax.swing.text.DefaultFormatter;
import org.graalvm.visualvm.gotosource.viewer.internal.Bundle;
import org.openide.awt.Mnemonics;
import org.openide.util.NbPreferences;

final class InternalSourceAppearance {
    private static final String PROP_FONT_NAME = "prop_InternalSourceAppearance_fontName";
    private static final String PROP_FONT_STYLE = "prop_InternalSourceAppearance_fontStyle";
    private static final String PROP_FONT_SIZE = "prop_InternalSourceAppearance_fontSize";
    private static final int DEFAULT_FONT_STYLE = 0;
    private static final int DEFAULT_FONT_SIZE = new JTextArea().getFont().getSize();
    private static final String DEFAULT_FONT_NAME = new Font("Monospaced", 0, DEFAULT_FONT_SIZE).getName();
    private final PropertyChangeSupport changeSupport = new PropertyChangeSupport(this);
    private JPanel settingsPanel;
    private JComboBox<String> fontSelect;
    private JComboBox<FontStyle> styleSelect;
    private JSpinner sizeSelect;

    InternalSourceAppearance() {
    }

    Font getFont() {
        Preferences preferences = NbPreferences.forModule(InternalSourceAppearance.class);
        return new Font(this.savedFontName(preferences), this.savedFontStyle(preferences), this.savedFontSize(preferences));
    }

    void addListener(PropertyChangeListener listener) {
        this.changeSupport.addPropertyChangeListener(listener);
    }

    void removeListener(PropertyChangeListener listener) {
        this.changeSupport.removePropertyChangeListener(listener);
    }

    void loadSettings() {
        if (this.settingsPanel == null) {
            return;
        }
        Preferences settings = NbPreferences.forModule(InternalSourceAppearance.class);
        this.fontSelect.setSelectedItem(this.savedFontName(settings));
        this.styleSelect.setSelectedItem((Object)FontStyle.fromStyle(this.savedFontStyle(settings)));
        this.sizeSelect.setValue(this.savedFontSize(settings));
    }

    void saveSettings() {
        if (this.settingsPanel == null || !this.currentSettingsDirty()) {
            return;
        }
        Preferences settings = NbPreferences.forModule(InternalSourceAppearance.class);
        settings.put(PROP_FONT_NAME, this.currentFontName());
        settings.putInt(PROP_FONT_STYLE, this.currentFontStyle());
        settings.putInt(PROP_FONT_SIZE, this.currentFontSize());
        this.changeSupport.firePropertyChange(new PropertyChangeEvent(this, "appearance", null, null));
    }

    boolean currentSettingsDirty() {
        if (this.settingsPanel == null) {
            return false;
        }
        Preferences settings = NbPreferences.forModule(InternalSourceAppearance.class);
        if (!this.currentFontName().equals(this.savedFontName(settings))) {
            return true;
        }
        if (this.currentFontStyle() != this.savedFontStyle(settings)) {
            return true;
        }
        return this.currentFontSize() != this.savedFontSize(settings);
    }

    private String savedFontName(Preferences preferences) {
        return preferences.get(PROP_FONT_NAME, DEFAULT_FONT_NAME).trim();
    }

    private String currentFontName() {
        return this.fontSelect.getEditor().getItem().toString().trim();
    }

    private int savedFontStyle(Preferences preferences) {
        return preferences.getInt(PROP_FONT_STYLE, 0);
    }

    private int currentFontStyle() {
        return ((FontStyle)((Object)this.styleSelect.getSelectedItem())).getStyle();
    }

    private int savedFontSize(Preferences preferences) {
        return preferences.getInt(PROP_FONT_SIZE, DEFAULT_FONT_SIZE);
    }

    private int currentFontSize() {
        try {
            return Integer.parseInt(((JSpinner.DefaultEditor)this.sizeSelect.getEditor()).getTextField().getText().trim());
        }
        catch (Exception e) {
            return (Integer)this.sizeSelect.getValue();
        }
    }

    JComponent getSettingsComponent() {
        if (this.settingsPanel == null) {
            this.settingsPanel = new JPanel(null);
            this.settingsPanel.setLayout(new BoxLayout(this.settingsPanel, 2));
            this.settingsPanel.setOpaque(false);
            int tab = 15;
            int gap = 5;
            JLabel fontCaption = new JLabel();
            Mnemonics.setLocalizedText((JLabel)fontCaption, (String)Bundle.InternalSourceAppearance_FontLabel());
            this.settingsPanel.add(fontCaption);
            this.settingsPanel.add(Box.createHorizontalStrut(gap));
            this.fontSelect = new JComboBox<String>(InternalSourceAppearance.getAvailableFonts(false));
            this.fontSelect.setSelectedItem(new Font("Monospaced", 0, 12).getName());
            Dimension dim = this.fontSelect.getMinimumSize();
            dim.width = 20;
            this.fontSelect.setMinimumSize(dim);
            this.fontSelect.setMaximumSize(this.fontSelect.getPreferredSize());
            this.fontSelect.setEditable(true);
            fontCaption.setLabelFor(this.fontSelect);
            this.settingsPanel.add(this.fontSelect);
            this.settingsPanel.add(Box.createHorizontalStrut(tab));
            JLabel styleCaption = new JLabel();
            Mnemonics.setLocalizedText((JLabel)styleCaption, (String)Bundle.InternalSourceAppearance_StyleLabel());
            this.settingsPanel.add(styleCaption);
            this.settingsPanel.add(Box.createHorizontalStrut(gap));
            this.styleSelect = new JComboBox<FontStyle>(FontStyle.values());
            this.styleSelect.setPreferredSize(this.styleSelect.getMinimumSize());
            this.styleSelect.setMaximumSize(this.styleSelect.getMinimumSize());
            styleCaption.setLabelFor(this.styleSelect);
            this.settingsPanel.add(this.styleSelect);
            this.settingsPanel.add(Box.createHorizontalStrut(tab));
            JLabel sizeCaption = new JLabel();
            Mnemonics.setLocalizedText((JLabel)sizeCaption, (String)Bundle.InternalSourceAppearance_SizeLabel());
            this.settingsPanel.add(sizeCaption);
            this.settingsPanel.add(Box.createHorizontalStrut(gap));
            this.sizeSelect = new JSpinner(new SpinnerNumberModel(sizeCaption.getFont().getSize(), 1, 99, 1));
            try {
                JFormattedTextField editor = ((JSpinner.DefaultEditor)this.sizeSelect.getEditor()).getTextField();
                ((DefaultFormatter)editor.getFormatter()).setAllowsInvalid(false);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.sizeSelect.setPreferredSize(this.sizeSelect.getMinimumSize());
            this.sizeSelect.setMaximumSize(this.sizeSelect.getMinimumSize());
            sizeCaption.setLabelFor(this.sizeSelect);
            this.settingsPanel.add(this.sizeSelect);
            this.loadSettings();
        }
        return this.settingsPanel;
    }

    private static String[] getAvailableFonts(boolean monospaced) {
        return GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
    }

    private static enum FontStyle {
        PLAIN(0, Bundle.InternalSourceAppearance_FontPlain()),
        BOLD(1, Bundle.InternalSourceAppearance_FontBold()),
        ITALIC(2, Bundle.InternalSourceAppearance_FontItalic()),
        BOLD_ITALIC(3, Bundle.InternalSourceAppearance_FontBoldItalic());

        private final int style;
        private final String name;

        private FontStyle(int style, String name) {
            this.style = style;
            this.name = name;
        }

        int getStyle() {
            return this.style;
        }

        String getName() {
            return this.name;
        }

        public String toString() {
            return this.getName();
        }

        static FontStyle fromStyle(int style) {
            switch (style) {
                case 0: {
                    return PLAIN;
                }
                case 1: {
                    return BOLD;
                }
                case 2: {
                    return ITALIC;
                }
            }
            return BOLD_ITALIC;
        }
    }
}

