/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.jfr.impl;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.graalvm.visualvm.application.Application;
import org.graalvm.visualvm.application.ApplicationFinder;
import org.graalvm.visualvm.core.VisualVM;
import org.graalvm.visualvm.jfr.JFRSnapshotSupport;
import org.netbeans.api.sendopts.CommandException;
import org.netbeans.spi.sendopts.Env;
import org.netbeans.spi.sendopts.Option;
import org.netbeans.spi.sendopts.OptionProcessor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;

public class JFRArguments
extends OptionProcessor {
    private static final String START_LONG_NAME = "start-jfr";
    private static final Option START_JFR_ARGUMENT = Option.shortDescription((Option)Option.requiredArgument((char)'\uffff', (String)"start-jfr"), (String)"org.graalvm.visualvm.jfr.impl.Bundle", (String)"Argument_Start_ShortDescr");
    private static final String DUMP_LONG_NAME = "dump-jfr";
    private static final Option DUMP_JFR_ARGUMENT = Option.shortDescription((Option)Option.requiredArgument((char)'\uffff', (String)"dump-jfr"), (String)"org.graalvm.visualvm.jfr.impl.Bundle", (String)"Argument_Dump_ShortDescr");
    private static final String STOP_LONG_NAME = "stop-jfr";
    private static final Option STOP_JFR_ARGUMENT = Option.shortDescription((Option)Option.requiredArgument((char)'\uffff', (String)"stop-jfr"), (String)"org.graalvm.visualvm.jfr.impl.Bundle", (String)"Argument_Stop_ShortDescr");

    protected Set<Option> getOptions() {
        HashSet<Option> options = new HashSet<Option>();
        options.add(START_JFR_ARGUMENT);
        options.add(DUMP_JFR_ARGUMENT);
        options.add(STOP_JFR_ARGUMENT);
        return options;
    }

    protected void process(Env env, Map<Option, String[]> maps) throws CommandException {
        String[] startJFR = maps.get(START_JFR_ARGUMENT);
        if (startJFR != null) {
            String[] _startJFR;
            String[] stringArray = _startJFR = startJFR.length == 1 ? startJFR[0].split("@") : null;
            if (_startJFR != null && _startJFR.length == 2) {
                startJFR[0] = _startJFR[0];
            }
            new Finder(startJFR, START_LONG_NAME){

                public void found(final Application application) {
                    VisualVM.getInstance().runTask(new Runnable(){

                        @Override
                        public void run() {
                            if (JFRSnapshotSupport.supportsJfrStart(application)) {
                                String params = _startJFR != null && _startJFR.length == 2 ? _startJFR[1] : null;
                                JFRSnapshotSupport.jfrStartRecording(application, params);
                            }
                        }
                    });
                }
            }.find();
            return;
        }
        final String[] dumpJFR = maps.get(DUMP_JFR_ARGUMENT);
        final String[] stopJFR = maps.get(STOP_JFR_ARGUMENT);
        if (dumpJFR != null) {
            new Finder(dumpJFR, DUMP_LONG_NAME){

                public void found(final Application application) {
                    VisualVM.getInstance().runTask(new Runnable(){

                        @Override
                        public void run() {
                            if (JFRSnapshotSupport.supportsJfrDump(application)) {
                                boolean stop;
                                boolean bl = stop = stopJFR != null && stopJFR.length == 1 && stopJFR[0].equals(dumpJFR[0]);
                                if (stop && !JFRSnapshotSupport.supportsJfrStop(application)) {
                                    stop = false;
                                }
                                JFRSnapshotSupport.takeJfrDump(application, stop, true);
                            }
                        }
                    });
                }
            }.find();
            return;
        }
        if (stopJFR != null) {
            new Finder(stopJFR, STOP_LONG_NAME){

                public void found(final Application application) {
                    VisualVM.getInstance().runTask(new Runnable(){

                        @Override
                        public void run() {
                            if (JFRSnapshotSupport.supportsJfrStop(application)) {
                                JFRSnapshotSupport.jfrStopRecording(application);
                            }
                        }
                    });
                }
            }.find();
        }
    }

    private static abstract class Finder
    extends ApplicationFinder {
        Finder(String[] pids, String longName) throws CommandException {
            super(Finder.resolvePid(pids, longName));
        }

        public final void notFound(int pid, String id) {
            NotifyDescriptor.Message desc = new NotifyDescriptor.Message((Object)NbBundle.getMessage(JFRArguments.class, (String)"MSG_NO_APP_PID", (Object[])new Object[]{Integer.toString(pid)}), 2);
            DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)desc);
        }

        private static int resolvePid(String[] pids, String longName) throws CommandException {
            if (pids.length == 1) {
                try {
                    return Integer.valueOf(pids[0]);
                }
                catch (NumberFormatException e) {
                    throw new CommandException(0, "Incorrect pid format for --" + longName + ": " + e.getMessage());
                }
            }
            throw new CommandException(0, "--" + longName + " requires exactly one value");
        }
    }
}

