/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.profiler.api.icons;

import java.awt.Image;
import java.util.Collection;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.graalvm.visualvm.lib.profiler.spi.IconsProvider;
import org.openide.util.Lookup;

public final class Icons {
    public static Icon getIcon(String key) {
        return Icons.getImageIcon(key);
    }

    public static ImageIcon getImageIcon(String key) {
        Image image = Icons.getImage(key);
        if (image == null) {
            return null;
        }
        return new ImageIcon(image);
    }

    public static Image getImage(String key) {
        Collection<? extends IconsProvider> ps = Icons.providers();
        for (IconsProvider iconsProvider : ps) {
            Image image = iconsProvider.getImage(key);
            if (image == null) continue;
            return image;
        }
        return null;
    }

    public static String getResource(String key) {
        Collection<? extends IconsProvider> ps = Icons.providers();
        for (IconsProvider iconsProvider : ps) {
            String resource = iconsProvider.getResource(key);
            if (resource == null) continue;
            return resource;
        }
        return null;
    }

    private static Collection<? extends IconsProvider> providers() {
        return Lookup.getDefault().lookupAll(IconsProvider.class);
    }

    public static interface Keys {
    }
}

