/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Polygon;
import java.util.Vector;

public class AWGraphApplet
extends Applet {
    private Graphics bfr;
    private Image img;
    private static final int VERTICAL = 0;
    private static final int HORIZONTAL = 1;
    private static final int SOLID = 0;
    private static final int STRIPED = 1;
    private static final int DEBUG = 3;
    private static final int SHIFTBAR = 3;
    private static final String VERSION = "1.1";
    private String title;
    private String special = "Not yet defined";
    private Font font;
    private Font fontb;
    private FontMetrics fontmetrics;
    private int orientation;
    private int barsize;
    private int nbblocks;
    private String[] blabels;
    private int b_fontsize = 11;
    private int blockSpacing = 5;
    private int textVertSpacing = 0;
    private int nbvalues;
    private Color[] colors;
    private String[] vlabels;
    private int[] styles;
    private float[] max;
    private int valSpacing = 0;
    private int valWidth = 5;
    private float[][] values;
    private int maxLabelWidth = 0;
    private Color background_color = Color.white;
    private Color border_color = Color.white;
    private Color special_color = Color.gray;
    private Color backgraph_colorl = Color.decode("#F6F6F6");
    private Color backgraph_colorm = Color.decode("#EDEDED");
    private Color backgraph_colorh = Color.decode("#E0E0E0");

    public synchronized void start() {
        this.special = this.getParameter("special");
        if (this.special == null) {
            this.special = "";
        }
        this.Log("Applet 1.1 ($Revision: 1.5 $) init");
        String string = this.getParameter("b_fontsize");
        if (string != null) {
            this.b_fontsize = Integer.parseInt(string);
        }
        this.title = this.getParameter("title");
        if (this.title == null) {
            this.title = "Chart";
        }
        if ((string = this.getParameter("nbblocks")) != null) {
            this.nbblocks = Integer.parseInt(string);
        }
        if ((string = this.getParameter("nbvalues")) != null) {
            this.nbvalues = Integer.parseInt(string);
        }
        if ((string = this.getParameter("blockspacing")) != null) {
            this.blockSpacing = Integer.parseInt(string);
        }
        if ((string = this.getParameter("valspacing")) != null) {
            this.valSpacing = Integer.parseInt(string);
        }
        if ((string = this.getParameter("valwidth")) != null) {
            this.valWidth = Integer.parseInt(string);
        }
        this.orientation = (string = this.getParameter("orientation")) == null ? 0 : (string.equalsIgnoreCase("horizontal") ? 1 : 0);
        string = this.getParameter("barsize");
        if (string != null) {
            this.barsize = Integer.parseInt(string);
        }
        if ((string = this.getParameter("background_color")) != null) {
            this.background_color = Color.decode("#" + string);
        }
        if ((string = this.getParameter("border_color")) != null) {
            this.border_color = Color.decode("#" + string);
        }
        if ((string = this.getParameter("special_color")) != null) {
            this.special_color = Color.decode("#" + string);
        }
        this.Log("bblocks " + this.nbblocks);
        this.Log("nbvalues " + this.nbvalues);
        this.Log("barsize " + this.barsize);
        this.font = new Font("Verdana,Arial,Helvetica", 0, this.b_fontsize);
        this.fontb = new Font("Verdana,Arial,Helvetica", 1, this.b_fontsize);
        this.fontmetrics = this.getFontMetrics(this.font);
        this.blabels = new String[this.nbblocks];
        this.vlabels = new String[this.nbvalues];
        this.styles = new int[this.nbvalues];
        this.max = new float[this.nbvalues];
        this.colors = new Color[this.nbvalues];
        this.values = new float[this.nbblocks][this.nbvalues];
        int n = 0;
        while (n < this.nbvalues) {
            this.parseLabel(n);
            this.parseStyle(n);
            this.parseColor(n);
            this.parseMax(n);
            ++n;
        }
        int n2 = 0;
        while (n2 < this.nbblocks) {
            this.parsebLabel(n2);
            this.parseValue(n2);
            ++n2;
        }
        int n3 = 0;
        while (n3 < this.nbvalues) {
            if (this.max[n3] <= 0.0f) {
                this.max[n3] = 1.0f;
            }
            this.Log("max[" + n3 + "]=" + this.max[n3]);
            ++n3;
        }
    }

    private synchronized void Log(String string) {
        System.out.println(this.getClass().getName() + " (" + this.special + "): " + string);
    }

    private synchronized void parsebLabel(int n) {
        String string = this.getParameter("b" + (n + 1) + "_label");
        this.blabels[n] = string == null ? "" : string;
        this.maxLabelWidth = Math.max(this.fontmetrics.stringWidth(this.blabels[n]), this.maxLabelWidth);
    }

    private synchronized void parseLabel(int n) {
        String string = this.getParameter("v" + (n + 1) + "_label");
        this.vlabels[n] = string == null ? "" : string;
    }

    private synchronized void parseStyle(int n) {
        String string = this.getParameter("v" + (n + 1) + "_style");
        this.styles[n] = string == null || string.equalsIgnoreCase("solid") ? 0 : (string.equalsIgnoreCase("striped") ? 1 : 0);
    }

    private synchronized void parseColor(int n) {
        String string = this.getParameter("v" + (n + 1) + "_color");
        this.colors[n] = string != null ? Color.decode("#" + string) : Color.gray;
    }

    private synchronized void parseMax(int n) {
        String string = this.getParameter("v" + (n + 1) + "_max");
        this.max[n] = string != null ? Float.valueOf(string).floatValue() : 1.0f;
    }

    private synchronized void parseValue(int n) {
        String string = this.getParameter("b" + (n + 1));
        if (string != null) {
            String[] stringArray = this.split(string, " ", 0);
            int n2 = 0;
            while (n2 < stringArray.length) {
                this.values[n][n2] = stringArray[n2].compareTo("?") == 0 ? 0.0f : Float.parseFloat(stringArray[n2]);
                ++n2;
            }
        }
    }

    private String[] split(String string, String string2, int n) {
        int n2;
        Vector<String> vector = new Vector<String>();
        boolean bl = false;
        String string3 = "";
        int n3 = n2 = n - 1;
        while (!bl) {
            n3 = n2;
            if ((n2 = string.indexOf(string2, n3 + 1)) != -1) {
                string3 = string.substring(n3 + 1, n2);
            } else {
                string3 = string.substring(n3 + 1, string.length());
                bl = true;
            }
            vector.addElement(string3);
        }
        String[] stringArray = new String[vector.size()];
        n2 = 0;
        while (n2 < vector.size()) {
            stringArray[n2] = (String)vector.elementAt(n2);
            ++n2;
        }
        return stringArray;
    }

    private String remove(String string, String string2) {
        int n;
        Vector<String> vector = new Vector<String>();
        boolean bl = false;
        String string3 = "";
        int n2 = n = -1;
        while (!bl) {
            n2 = n;
            if ((n = string.indexOf(string2, n2 + 1)) != -1) {
                string3 = string.substring(n2 + 1, n);
            } else {
                string3 = string.substring(n2 + 1, string.length());
                bl = true;
            }
            vector.addElement(string3);
        }
        string3 = "";
        n = 0;
        while (n < vector.size()) {
            string3 = string3 + (String)vector.elementAt(n);
            ++n;
        }
        return string3;
    }

    public void init() {
        this.img = this.createImage(this.getSize().width, this.getSize().height);
        this.bfr = this.img.getGraphics();
    }

    public synchronized void paint(Graphics graphics) {
        this.bfr.setColor(this.background_color);
        this.bfr.fillRect(0, 0, this.getSize().width, this.getSize().height);
        this.bfr.setColor(this.border_color);
        this.bfr.drawRect(0, 0, this.getSize().width, this.getSize().height);
        if (this.orientation == 1) {
            this.paintHorizontal(this.bfr);
        } else {
            this.paintVertical(this.bfr);
        }
        graphics.drawImage(this.img, 0, 0, this);
    }

    private synchronized void draw3DBar(Graphics graphics, int n, int n2, float f, float f2, int n3, Color color) {
        Polygon polygon = new Polygon();
        int n4 = new Float(f).intValue();
        int n5 = new Float(f2).intValue();
        polygon.addPoint(n, n2);
        polygon.addPoint(n + n4, n2);
        polygon.addPoint(n + n4, n2 - n5);
        polygon.addPoint(n, n2 - n5);
        graphics.setColor(color);
        graphics.fillPolygon(polygon);
        graphics.setColor(color.darker());
        graphics.drawPolygon(polygon);
        Polygon polygon2 = new Polygon();
        polygon2.addPoint(n + n4, n2);
        polygon2.addPoint(n + n4 + n3, n2 - n3);
        polygon2.addPoint(n + n4 + n3, n2 - n3 - n5);
        polygon2.addPoint(n + n4, n2 - n5);
        graphics.setColor(color.darker());
        graphics.fillPolygon(polygon2);
        graphics.setColor(color.darker().darker());
        graphics.drawPolygon(polygon2);
        Polygon polygon3 = new Polygon();
        polygon3.addPoint(n, n2 - n5);
        polygon3.addPoint(n + n4, n2 - n5);
        polygon3.addPoint(n + n4 + n3, n2 - n5 - n3);
        polygon3.addPoint(n + n3, n2 - n5 - n3);
        graphics.setColor(color);
        graphics.fillPolygon(polygon3);
        graphics.setColor(color.darker());
        graphics.drawPolygon(polygon3);
    }

    private synchronized void paintHorizontal(Graphics graphics) {
    }

    private synchronized void paintVertical(Graphics graphics) {
        graphics.setColor(Color.black);
        graphics.setFont(this.font);
        int n = 10;
        int n2 = (this.nbvalues * (this.valWidth + this.valSpacing) + this.blockSpacing) * this.nbblocks;
        int n3 = this.barsize;
        int n4 = (this.getSize().width - n2) / 2 - 2 * n;
        int n5 = this.getSize().height - 2 * this.fontmetrics.getHeight() - 2 - this.textVertSpacing;
        int n6 = n4;
        int n7 = n5;
        Polygon polygon = new Polygon();
        polygon.addPoint(n6, n7);
        polygon.addPoint(n6 + n2 + 3 * n, n7);
        polygon.addPoint(n6 + n2 + 4 * n, n7 - n);
        polygon.addPoint(n6 + n, n7 - n);
        graphics.setColor(this.backgraph_colorl);
        graphics.fillPolygon(polygon);
        graphics.setColor(Color.lightGray);
        graphics.drawPolygon(polygon);
        Polygon polygon2 = new Polygon();
        polygon2.addPoint(n6, n7);
        polygon2.addPoint(n6 + n, n7 - n);
        polygon2.addPoint(n6 + n, n7 - n - this.barsize);
        polygon2.addPoint(n6, n7 - this.barsize);
        graphics.setColor(this.backgraph_colorh);
        graphics.fillPolygon(polygon2);
        graphics.setColor(Color.lightGray);
        graphics.drawPolygon(polygon2);
        Polygon polygon3 = new Polygon();
        polygon3.addPoint(n6 + n, n7 - n);
        polygon3.addPoint(n6 + n2 + 4 * n, n7 - n);
        polygon3.addPoint(n6 + n2 + 4 * n, n7 - n - this.barsize);
        polygon3.addPoint(n6 + n, n7 - n - this.barsize);
        graphics.setColor(this.backgraph_colorm);
        graphics.fillPolygon(polygon3);
        graphics.setColor(Color.lightGray);
        graphics.drawPolygon(polygon3);
        n6 += 2 * n;
        int n8 = 0;
        while (n8 < this.nbblocks) {
            int n9;
            n7 = this.getSize().height - this.fontmetrics.getHeight() - 3 - this.textVertSpacing;
            graphics.setColor(Color.black);
            boolean bl = false;
            boolean bl2 = false;
            String string = this.blabels[n8];
            if (this.blabels[n8].indexOf(":") > 0) {
                bl = true;
                string = this.remove(this.blabels[n8], ":");
            }
            if (this.blabels[n8].indexOf("!") > 0) {
                bl2 = true;
                string = this.remove(this.blabels[n8], "!");
            }
            if (bl) {
                graphics.setFont(this.fontb);
            }
            String[] stringArray = this.split(string, "\u00a7", 0);
            if (bl2) {
                graphics.setColor(this.special_color);
                graphics.fillRect(n6 - Math.max(-1 + this.blockSpacing >> 1, 0), n7 - this.fontmetrics.getHeight() + 2, this.nbvalues * (this.valWidth + this.valSpacing) + Math.max(this.blockSpacing - 2, 0) + 1, (this.fontmetrics.getHeight() + this.textVertSpacing) * stringArray.length + 2);
                graphics.setColor(Color.black);
            }
            int n10 = 0;
            while (n10 < stringArray.length) {
                n9 = this.nbvalues * (this.valWidth + this.valSpacing) - this.fontmetrics.stringWidth(stringArray[n10]) >> 1;
                if (n9 < 0) {
                    n9 = 0;
                }
                graphics.drawString(stringArray[n10], n6 + n9, n7);
                n7 += this.fontmetrics.getHeight() + this.textVertSpacing - 1;
                ++n10;
            }
            if (bl) {
                graphics.setFont(this.font);
            }
            n9 = 0;
            while (n9 < this.nbvalues) {
                n7 = this.getSize().height - this.fontmetrics.getHeight() - 6 - this.textVertSpacing;
                this.draw3DBar(graphics, n6, n7 -= this.fontmetrics.getHeight() - 4, this.valWidth, this.values[n8][n9] * (float)this.barsize / this.max[n9], 3, this.colors[n9]);
                n7 = (int)((float)n7 - (this.values[n8][n9] + 5.0f));
                n6 += this.valWidth + this.valSpacing;
                ++n9;
            }
            n6 += this.blockSpacing;
            ++n8;
        }
    }

    public synchronized String getAppletInfo() {
        return "Title: " + this.title + "\n";
    }

    public synchronized String[][] getParameterInfo() {
        String[][] stringArray = new String[][]{{"version", "string", "AWGraphApplet 1.1"}, {"copyright", "string", "GPL"}, {"title", "string", this.title}};
        return stringArray;
    }
}

