<?php
/**
 * AuthorizationsService
 * PHP version 5
 *
 * @category Class
 * @package  InfluxDB2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * InfluxDB OSS API Service
 *
 * The InfluxDB v2 API provides a programmatic interface for all interactions with InfluxDB. Access the InfluxDB API using the `/api/v2/` endpoint.
 *
 * OpenAPI spec version: 2.0.0
 * 
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 3.3.4
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace InfluxDB2\Service;

use InfluxDB2\DefaultApi;
use InfluxDB2\HeaderSelector;
use InfluxDB2\ObjectSerializer;

/**
 * AuthorizationsService Class Doc Comment
 *
 * @category Class
 * @package  InfluxDB2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class AuthorizationsService
{
    /**
     * @var DefaultApi
     */
    protected $defaultApi;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @param DefaultApi $defaultApi
     * @param HeaderSelector  $selector
     */
    public function __construct(DefaultApi $defaultApi)
    {
        $this->defaultApi = $defaultApi;
        $this->headerSelector = new HeaderSelector();
    }


    /**
     * Operation deleteAuthorizationsID
     *
     * Delete an authorization
     *
     * @param  string $auth_id The ID of the authorization to delete. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return void
     */
    public function deleteAuthorizationsID($auth_id, $zap_trace_span = null)
    {
        $this->deleteAuthorizationsIDWithHttpInfo($auth_id, $zap_trace_span);
    }

    /**
     * Operation deleteAuthorizationsIDWithHttpInfo
     *
     * Delete an authorization
     *
     * @param  string $auth_id The ID of the authorization to delete. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteAuthorizationsIDWithHttpInfo($auth_id, $zap_trace_span = null)
    {
        $request = $this->deleteAuthorizationsIDRequest($auth_id, $zap_trace_span);

        $response = $this->defaultApi->sendRequest($request);

        return [null, $response->getStatusCode(), $response->getHeaders()];
    }

    /**
     * Create request for operation 'deleteAuthorizationsID'
     *
     * @param  string $auth_id The ID of the authorization to delete. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InvalidArgumentException
     * @return \Psr\Http\Message\RequestInterface
     */
    protected function deleteAuthorizationsIDRequest($auth_id, $zap_trace_span = null)
    {
        // verify the required parameter 'auth_id' is set
        if ($auth_id === null || (is_array($auth_id) && count($auth_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $auth_id when calling deleteAuthorizationsID'
            );
        }

        $resourcePath = '/api/v2/authorizations/{authID}';
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($zap_trace_span !== null) {
            $headerParams['Zap-Trace-Span'] = ObjectSerializer::toHeaderValue($zap_trace_span);
        }

        // path params
        if ($auth_id !== null) {
            $resourcePath = str_replace(
                '{' . 'authID' . '}',
                ObjectSerializer::toPathValue($auth_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        }

        $headers = array_merge(
            $headerParams,
            $headers
        );

        return $this->defaultApi->createRequest('DELETE', $resourcePath, $httpBody, $headers, $queryParams);
    }

    /**
     * Operation getAuthorizations
     *
     * List authorizations
     *
     * @param  string $zap_trace_span OpenTracing span context (optional)
     * @param  string $user_id A user ID. Only returns authorizations scoped to this user. (optional)
     * @param  string $user A user name. Only returns authorizations scoped to this user. (optional)
     * @param  string $org_id An organization ID. Only returns authorizations that belong to this organization. (optional)
     * @param  string $org An organization name. Only returns authorizations that belong to this organization. (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \InfluxDB2\Model\Authorizations|string|object|\InfluxDB2\Model\Error|string
     */
    public function getAuthorizations($zap_trace_span = null, $user_id = null, $user = null, $org_id = null, $org = null)
    {
        list($response) = $this->getAuthorizationsWithHttpInfo($zap_trace_span, $user_id, $user, $org_id, $org);
        return $response;
    }

    /**
     * Operation getAuthorizationsWithHttpInfo
     *
     * List authorizations
     *
     * @param  string $zap_trace_span OpenTracing span context (optional)
     * @param  string $user_id A user ID. Only returns authorizations scoped to this user. (optional)
     * @param  string $user A user name. Only returns authorizations scoped to this user. (optional)
     * @param  string $org_id An organization ID. Only returns authorizations that belong to this organization. (optional)
     * @param  string $org An organization name. Only returns authorizations that belong to this organization. (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \InfluxDB2\Model\Authorizations|string|object|\InfluxDB2\Model\Error|string, HTTP status code, HTTP response headers (array of strings)
     */
    public function getAuthorizationsWithHttpInfo($zap_trace_span = null, $user_id = null, $user = null, $org_id = null, $org = null)
    {
        $request = $this->getAuthorizationsRequest($zap_trace_span, $user_id, $user, $org_id, $org);

        $response = $this->defaultApi->sendRequest($request);

        $returnType = '\InfluxDB2\Model\Authorizations';
        $responseBody = $response->getBody();
        if ($returnType === '\SplFileObject') {
            $content = $responseBody; //stream goes to serializer
        } else {
            $content = $responseBody->getContents();
        }

        return [
            ObjectSerializer::deserialize($content, $returnType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    /**
     * Create request for operation 'getAuthorizations'
     *
     * @param  string $zap_trace_span OpenTracing span context (optional)
     * @param  string $user_id A user ID. Only returns authorizations scoped to this user. (optional)
     * @param  string $user A user name. Only returns authorizations scoped to this user. (optional)
     * @param  string $org_id An organization ID. Only returns authorizations that belong to this organization. (optional)
     * @param  string $org An organization name. Only returns authorizations that belong to this organization. (optional)
     *
     * @throws \InvalidArgumentException
     * @return \Psr\Http\Message\RequestInterface
     */
    protected function getAuthorizationsRequest($zap_trace_span = null, $user_id = null, $user = null, $org_id = null, $org = null)
    {

        $resourcePath = '/api/v2/authorizations';
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        if ($user_id !== null) {
            $queryParams['userID'] = ObjectSerializer::toQueryValue($user_id);
        }
        // query params
        if ($user !== null) {
            $queryParams['user'] = ObjectSerializer::toQueryValue($user);
        }
        // query params
        if ($org_id !== null) {
            $queryParams['orgID'] = ObjectSerializer::toQueryValue($org_id);
        }
        // query params
        if ($org !== null) {
            $queryParams['org'] = ObjectSerializer::toQueryValue($org);
        }
        // header params
        if ($zap_trace_span !== null) {
            $headerParams['Zap-Trace-Span'] = ObjectSerializer::toHeaderValue($zap_trace_span);
        }


        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        }

        $headers = array_merge(
            $headerParams,
            $headers
        );

        return $this->defaultApi->createRequest('GET', $resourcePath, $httpBody, $headers, $queryParams);
    }

    /**
     * Operation getAuthorizationsID
     *
     * Retrieve an authorization
     *
     * @param  string $auth_id The ID of the authorization to get. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \InfluxDB2\Model\Authorization|string
     */
    public function getAuthorizationsID($auth_id, $zap_trace_span = null)
    {
        list($response) = $this->getAuthorizationsIDWithHttpInfo($auth_id, $zap_trace_span);
        return $response;
    }

    /**
     * Operation getAuthorizationsIDWithHttpInfo
     *
     * Retrieve an authorization
     *
     * @param  string $auth_id The ID of the authorization to get. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \InfluxDB2\Model\Authorization|string, HTTP status code, HTTP response headers (array of strings)
     */
    public function getAuthorizationsIDWithHttpInfo($auth_id, $zap_trace_span = null)
    {
        $request = $this->getAuthorizationsIDRequest($auth_id, $zap_trace_span);

        $response = $this->defaultApi->sendRequest($request);

        $returnType = '\InfluxDB2\Model\Authorization';
        $responseBody = $response->getBody();
        if ($returnType === '\SplFileObject') {
            $content = $responseBody; //stream goes to serializer
        } else {
            $content = $responseBody->getContents();
        }

        return [
            ObjectSerializer::deserialize($content, $returnType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    /**
     * Create request for operation 'getAuthorizationsID'
     *
     * @param  string $auth_id The ID of the authorization to get. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InvalidArgumentException
     * @return \Psr\Http\Message\RequestInterface
     */
    protected function getAuthorizationsIDRequest($auth_id, $zap_trace_span = null)
    {
        // verify the required parameter 'auth_id' is set
        if ($auth_id === null || (is_array($auth_id) && count($auth_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $auth_id when calling getAuthorizationsID'
            );
        }

        $resourcePath = '/api/v2/authorizations/{authID}';
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($zap_trace_span !== null) {
            $headerParams['Zap-Trace-Span'] = ObjectSerializer::toHeaderValue($zap_trace_span);
        }

        // path params
        if ($auth_id !== null) {
            $resourcePath = str_replace(
                '{' . 'authID' . '}',
                ObjectSerializer::toPathValue($auth_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        }

        $headers = array_merge(
            $headerParams,
            $headers
        );

        return $this->defaultApi->createRequest('GET', $resourcePath, $httpBody, $headers, $queryParams);
    }

    /**
     * Operation patchAuthorizationsID
     *
     * Update an authorization to be active or inactive
     *
     * @param  string $auth_id The ID of the authorization to update. (required)
     * @param  \InfluxDB2\Model\AuthorizationUpdateRequest $authorization_update_request Authorization to update (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \InfluxDB2\Model\Authorization|string
     */
    public function patchAuthorizationsID($auth_id, $authorization_update_request, $zap_trace_span = null)
    {
        list($response) = $this->patchAuthorizationsIDWithHttpInfo($auth_id, $authorization_update_request, $zap_trace_span);
        return $response;
    }

    /**
     * Operation patchAuthorizationsIDWithHttpInfo
     *
     * Update an authorization to be active or inactive
     *
     * @param  string $auth_id The ID of the authorization to update. (required)
     * @param  \InfluxDB2\Model\AuthorizationUpdateRequest $authorization_update_request Authorization to update (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \InfluxDB2\Model\Authorization|string, HTTP status code, HTTP response headers (array of strings)
     */
    public function patchAuthorizationsIDWithHttpInfo($auth_id, $authorization_update_request, $zap_trace_span = null)
    {
        $request = $this->patchAuthorizationsIDRequest($auth_id, $authorization_update_request, $zap_trace_span);

        $response = $this->defaultApi->sendRequest($request);

        $returnType = '\InfluxDB2\Model\Authorization';
        $responseBody = $response->getBody();
        if ($returnType === '\SplFileObject') {
            $content = $responseBody; //stream goes to serializer
        } else {
            $content = $responseBody->getContents();
        }

        return [
            ObjectSerializer::deserialize($content, $returnType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    /**
     * Create request for operation 'patchAuthorizationsID'
     *
     * @param  string $auth_id The ID of the authorization to update. (required)
     * @param  \InfluxDB2\Model\AuthorizationUpdateRequest $authorization_update_request Authorization to update (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InvalidArgumentException
     * @return \Psr\Http\Message\RequestInterface
     */
    protected function patchAuthorizationsIDRequest($auth_id, $authorization_update_request, $zap_trace_span = null)
    {
        // verify the required parameter 'auth_id' is set
        if ($auth_id === null || (is_array($auth_id) && count($auth_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $auth_id when calling patchAuthorizationsID'
            );
        }
        // verify the required parameter 'authorization_update_request' is set
        if ($authorization_update_request === null || (is_array($authorization_update_request) && count($authorization_update_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $authorization_update_request when calling patchAuthorizationsID'
            );
        }

        $resourcePath = '/api/v2/authorizations/{authID}';
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($zap_trace_span !== null) {
            $headerParams['Zap-Trace-Span'] = ObjectSerializer::toHeaderValue($zap_trace_span);
        }

        // path params
        if ($auth_id !== null) {
            $resourcePath = str_replace(
                '{' . 'authID' . '}',
                ObjectSerializer::toPathValue($auth_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;
        if (isset($authorization_update_request)) {
            $_tempBody = $authorization_update_request;
        }

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        }

        $headers = array_merge(
            $headerParams,
            $headers
        );

        return $this->defaultApi->createRequest('PATCH', $resourcePath, $httpBody, $headers, $queryParams);
    }

    /**
     * Operation postAuthorizations
     *
     * Create an authorization
     *
     * @param  \InfluxDB2\Model\AuthorizationPostRequest $authorization_post_request The authorization to create. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \InfluxDB2\Model\Authorization|string|object|\InfluxDB2\Model\Error|string
     */
    public function postAuthorizations($authorization_post_request, $zap_trace_span = null)
    {
        list($response) = $this->postAuthorizationsWithHttpInfo($authorization_post_request, $zap_trace_span);
        return $response;
    }

    /**
     * Operation postAuthorizationsWithHttpInfo
     *
     * Create an authorization
     *
     * @param  \InfluxDB2\Model\AuthorizationPostRequest $authorization_post_request The authorization to create. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \InfluxDB2\Model\Authorization|string|object|\InfluxDB2\Model\Error|string, HTTP status code, HTTP response headers (array of strings)
     */
    public function postAuthorizationsWithHttpInfo($authorization_post_request, $zap_trace_span = null)
    {
        $request = $this->postAuthorizationsRequest($authorization_post_request, $zap_trace_span);

        $response = $this->defaultApi->sendRequest($request);

        $returnType = '\InfluxDB2\Model\Authorization';
        $responseBody = $response->getBody();
        if ($returnType === '\SplFileObject') {
            $content = $responseBody; //stream goes to serializer
        } else {
            $content = $responseBody->getContents();
        }

        return [
            ObjectSerializer::deserialize($content, $returnType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    /**
     * Create request for operation 'postAuthorizations'
     *
     * @param  \InfluxDB2\Model\AuthorizationPostRequest $authorization_post_request The authorization to create. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InvalidArgumentException
     * @return \Psr\Http\Message\RequestInterface
     */
    protected function postAuthorizationsRequest($authorization_post_request, $zap_trace_span = null)
    {
        // verify the required parameter 'authorization_post_request' is set
        if ($authorization_post_request === null || (is_array($authorization_post_request) && count($authorization_post_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $authorization_post_request when calling postAuthorizations'
            );
        }

        $resourcePath = '/api/v2/authorizations';
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($zap_trace_span !== null) {
            $headerParams['Zap-Trace-Span'] = ObjectSerializer::toHeaderValue($zap_trace_span);
        }


        // body params
        $_tempBody = null;
        if (isset($authorization_post_request)) {
            $_tempBody = $authorization_post_request;
        }

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        }

        $headers = array_merge(
            $headerParams,
            $headers
        );

        return $this->defaultApi->createRequest('POST', $resourcePath, $httpBody, $headers, $queryParams);
    }

}
