/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.webservices.client.cmd;

import com.amazon.aes.webservices.client.Jec2;
import com.amazon.aes.webservices.client.RequestResult;
import com.amazon.aes.webservices.client.RequestResultPair;
import com.amazon.aes.webservices.client.cmd.BaseCmd;
import com.amazon.aes.webservices.client.cmd.Outputter;
import org.apache.commons.cli.Options;

public class EnableVpcClassicLink
extends BaseCmd {
    public static final String[] VPC_DESC = new String[]{"The ID of the VPC."};

    public EnableVpcClassicLink(String[] args) {
        super("ec2enablecl", "ec2-enable-vpc-classic-link");
        this.init(this.getOptions());
        this.parseOpts(args);
    }

    protected Options getOptions() {
        return new Options();
    }

    @Override
    public String getOptionString() {
        return "VPC";
    }

    @Override
    public void printDescription() {
        super.printDescription();
        System.out.println("     Enables a VPC for ClassicLink. You can then link EC2-Classic instances to your ClassicLink-enabled VPC to allow communication over private IP addresses. You cannot enable your VPC for ClassicLink if any of your VPC's route tables have existing routes for address ranges within the 10.0.0.0/8 IP address range, excluding local routes for VPCs in the 10.0.0.0/16 and 10.1.0.0/16 IP address ranges.");
    }

    @Override
    public void printOptions() {
        super.printOptions();
    }

    @Override
    protected boolean invokeOnline(Jec2 jec2, Outputter out) throws Exception {
        this.warnIfTooManyNonOptions();
        this.assertNonOptionSet("VPC");
        String vpcId = this.getNonOptions()[0];
        RequestResultPair result = jec2.enableVpcClassicLink(vpcId);
        out.output(System.out, (Boolean)result.getResponse());
        out.printRequestId(System.out, (RequestResult)result);
        return true;
    }

    public static void main(String[] args) {
        new EnableVpcClassicLink(args).invoke();
    }
}

