/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.telemetry.internals;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.telemetry.internals.MetricKeyable;

public class MetricKey
implements MetricKeyable {
    private final String name;
    private final Map<String, String> tags;

    public MetricKey(String name) {
        this(name, null);
    }

    public MetricKey(String name, Map<String, String> tags) {
        this.name = Objects.requireNonNull(name);
        this.tags = tags != null ? Collections.unmodifiableMap(tags) : Collections.emptyMap();
    }

    public MetricKey(MetricName metricName) {
        this(metricName.name(), metricName.tags());
    }

    @Override
    public MetricKey key() {
        return this;
    }

    public String name() {
        return this.name;
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.tags);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MetricKey other = (MetricKey)obj;
        return this.name().equals(other.name()) && this.tags().equals(other.tags());
    }

    public String toString() {
        return "MetricKey {name=" + this.name() + ", tags=" + this.tags() + "}";
    }
}

