/*
 * Decompiled with CFR 0.152.
 */
package com.projectlibre1.script.object;

import com.projectlibre1.script.object.TimeWindow;
import com.projectlibre1.timescale.CalendarUtil;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Locale;
import org.apache.commons.lang.time.DateUtils;

public class TimeIntervals
implements Serializable,
Cloneable {
    static final long serialVersionUID = 18828392223063L;
    public static final int DAY = 1;
    public static final int WEEK = 2;
    public static final int MONTH = 3;
    public static final int QUARTER = 4;
    public static final int YEAR = 5;
    public static final int ETERNITY = 1000000;
    public static final int MIN_SCALE = 1;
    public static final int MAX_SCALE = 2;
    protected static final int DEFAULT_WINDOW_COUNT = 3;
    protected static final int WINDOW_INTERVALS = 50;
    protected LinkedList<TimeWindow> win = new LinkedList();
    protected int scale = 1;
    protected int translation;
    protected int winId;
    protected float center;
    protected LinkedList<TimeWindow> history = new LinkedList();
    protected long start;
    protected long end;

    public int getScale() {
        return this.scale;
    }

    public void setScale(int n) {
        if (n >= 1 && n <= 2) {
            this.scale = n;
        }
    }

    public LinkedList<TimeWindow> getWin() {
        return this.win;
    }

    public long getStart() {
        if (this.win.size() == 0) {
            return 0L;
        }
        return this.win.getFirst().getS();
    }

    public long getEnd() {
        if (this.win.size() == 0) {
            return Long.MAX_VALUE;
        }
        return this.win.getLast().getE();
    }

    public TimeWindow getCenterWin() {
        int n = this.win.size();
        if (n == 0) {
            return null;
        }
        int n2 = n / 2;
        if (n % 2 == 1) {
            return this.win.get(n2);
        }
        TimeWindow timeWindow = new TimeWindow();
        timeWindow.setS(this.win.get(n2 - 1).calculateCenter());
        timeWindow.setE(this.win.get(n2).calculateCenter());
        return timeWindow;
    }

    public int getTranslation() {
        return this.translation;
    }

    public void setTranslation(int n) {
        this.translation = n;
    }

    public float getCenter() {
        return this.center;
    }

    public void setCenter(float f) {
        this.center = f;
    }

    public void update() {
        if (this.win.size() > 0) {
            this.update(this.win.getFirst().getS(), this.end);
        }
    }

    public void update(long l, long l2) {
        this.update(l, l2, 3);
    }

    public void update(long l, long l2, int n) {
        this.start = l;
        this.end = l2;
        this.win.clear();
        this.history.clear();
        TimeIntervals.generateWindows(this.scale, l, 0L, Long.MAX_VALUE, n, this.win);
        TimeIntervals.indexWindows(this.winId, this.win);
        this.history.addAll(this.win);
    }

    protected static void indexWindows(int n, LinkedList<TimeWindow> linkedList) {
        int n2 = n;
        for (TimeWindow timeWindow : linkedList) {
            timeWindow.setId(n2++);
        }
    }

    public TimeIntervals translate(int n) {
        int n2;
        TimeIntervals timeIntervals = new TimeIntervals();
        timeIntervals.setScale(this.scale);
        LinkedList<TimeWindow> linkedList = timeIntervals.getWin();
        if (n == 0 || this.win.size() == 0) {
            return timeIntervals;
        }
        if (n > 0) {
            timeIntervals.winId = this.winId + this.win.size();
            n2 = timeIntervals.winId - 1 + n;
            var6_7 = timeIntervals.winId;
            var5_5 = Math.min(this.history.getLast().getId(), n2);
            if (var6_7 <= var5_5) {
                var7_9 = this.history.listIterator();
                while (var7_9.hasNext()) {
                    var8_10 = (TimeWindow)var7_9.next();
                    if (var8_10.getId() != timeIntervals.winId) continue;
                    var7_9.previous();
                    break;
                }
                while (var6_7 <= var5_5 && var7_9.hasNext()) {
                    var8_10 = (TimeWindow)var7_9.next();
                    linkedList.add(var8_10);
                    ++var6_7;
                }
            }
            var7_9 = new LinkedList();
            TimeIntervals.generateWindows(this.scale, (linkedList.size() > 0 ? linkedList : this.win).getLast().getE(), this.start, this.end, n2 - var6_7 + 1, (LinkedList<TimeWindow>)var7_9);
            TimeIntervals.indexWindows(timeIntervals.winId + timeIntervals.getWin().size(), (LinkedList<TimeWindow>)var7_9);
            timeIntervals.getWin().addAll((Collection<TimeWindow>)var7_9);
            this.history.addAll((Collection<TimeWindow>)var7_9);
        } else {
            timeIntervals.winId = this.winId - 1;
            n2 = timeIntervals.winId + 1 + n;
            var6_7 = timeIntervals.winId;
            var5_5 = Math.max(this.history.getFirst().getId(), n2);
            if (var6_7 >= var5_5) {
                var7_9 = this.history.listIterator(this.history.size() - 1);
                while (var7_9.hasPrevious()) {
                    var8_10 = (TimeWindow)var7_9.previous();
                    if (var8_10.getId() != timeIntervals.winId) continue;
                    var7_9.next();
                    break;
                }
                while (var6_7 >= var5_5) {
                    var8_10 = (TimeWindow)var7_9.previous();
                    linkedList.addFirst(var8_10);
                    --var6_7;
                }
            }
            var7_9 = new LinkedList();
            TimeIntervals.generateWindows(this.scale, (linkedList.size() > 0 ? linkedList : this.win).getFirst().getS(), this.start, this.end, n2 - var6_7 - 1, (LinkedList<TimeWindow>)var7_9);
            TimeIntervals.indexWindows(n2, (LinkedList<TimeWindow>)var7_9);
            timeIntervals.getWin().addAll(0, (Collection<TimeWindow>)var7_9);
            this.history.addAll(0, (Collection<TimeWindow>)var7_9);
        }
        n2 = 0;
        for (TimeWindow timeWindow : timeIntervals.getWin()) {
            if (n > 0) {
                this.win.removeFirst();
                this.win.addLast(timeWindow);
                ++n2;
                continue;
            }
            this.win.removeLast();
            this.win.addFirst(timeWindow);
            --n2;
        }
        this.winId += n2;
        timeIntervals.setTranslation(n2);
        return timeIntervals;
    }

    public static int generateWindows(int n, long l, long l2, long l3, int n2, LinkedList<TimeWindow> linkedList) {
        TimeWindow timeWindow = null;
        if (n2 > 0) {
            for (int i = 0; i <= n2; ++i) {
                TimeWindow timeWindow2 = TimeIntervals.generateWindow(l, n, 1);
                if (timeWindow != null) {
                    timeWindow.setE(timeWindow2.getS());
                    linkedList.add(timeWindow);
                }
                l = timeWindow2.getE();
                timeWindow = timeWindow2;
            }
        } else {
            for (int i = 0; i >= n2; --i) {
                TimeWindow timeWindow3 = TimeIntervals.generateWindow(l, n, -1);
                if (timeWindow != null) {
                    timeWindow.setS(timeWindow3.getE());
                    linkedList.addFirst(timeWindow);
                }
                l = timeWindow3.getS();
                timeWindow = timeWindow3;
            }
        }
        return n2;
    }

    public static TimeWindow generateWindow(long l, int n, int n2) {
        long l2;
        int n3;
        int n4 = 0;
        int n5 = 1;
        int n6 = 1;
        switch (n) {
            case 1: {
                n3 = 5;
                n4 = 3;
                break;
            }
            case 2: {
                n3 = 3;
                n4 = 2;
                break;
            }
            case 3: {
                n3 = 2;
                n4 = 2;
                n6 = 3;
                break;
            }
            case 4: {
                n3 = 2;
                n4 = 1;
                n5 = 3;
                break;
            }
            case 5: {
                n3 = 1;
                n4 = 1;
                break;
            }
            default: {
                return null;
            }
        }
        Calendar calendar = Calendar.getInstance(DateUtils.UTC_TIME_ZONE, Locale.US);
        calendar.setTimeInMillis(l);
        TimeIntervals.floorCal(n, calendar);
        long l3 = calendar.getTimeInMillis();
        TimeIntervals.floorCal(n + 1, calendar);
        long l4 = calendar.getTimeInMillis();
        calendar.setTimeInMillis(l3);
        while ((l2 = calendar.getTimeInMillis()) >= l4) {
            l3 = l2;
            calendar.add(n3, -n5);
        }
        calendar.setTimeInMillis(l3);
        calendar.add(n3, n2 * n5 * 50);
        TimeWindow timeWindow = new TimeWindow();
        if (n2 > 0) {
            timeWindow.setS(l3);
        } else {
            timeWindow.setE(l3);
        }
        if (n2 > 0) {
            timeWindow.setE(calendar.getTimeInMillis());
        } else {
            timeWindow.setS(calendar.getTimeInMillis());
        }
        return timeWindow;
    }

    private static void floorCal(int n, Calendar calendar) {
        switch (n) {
            case 1: {
                CalendarUtil.dayFloor(calendar);
                break;
            }
            case 2: {
                CalendarUtil.weekFloor(calendar);
                break;
            }
            case 3: {
                CalendarUtil.monthFloor(calendar);
                break;
            }
            case 4: {
                CalendarUtil.monthFloor(calendar);
                calendar.set(2, calendar.get(2) / 3 * 3);
                break;
            }
            case 5: {
                CalendarUtil.yearFloor(calendar);
            }
        }
    }

    public Object clone() {
        try {
            TimeIntervals timeIntervals = (TimeIntervals)super.clone();
            timeIntervals.win = new LinkedList();
            timeIntervals.history = new LinkedList();
            for (TimeWindow timeWindow : this.win) {
                timeIntervals.win.add(timeWindow);
            }
            for (TimeWindow timeWindow : this.history) {
                timeIntervals.history.add(timeWindow);
            }
            return timeIntervals;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }
}

